/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.screen;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.framework.network.message.IMessage;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.inventory.PostBoxMenu;
import com.mrcrayfish.furniture.refurbished.mail.DeliveryResult;
import com.mrcrayfish.furniture.refurbished.mail.IMailbox;
import com.mrcrayfish.furniture.refurbished.network.Network;
import com.mrcrayfish.furniture.refurbished.network.message.MessageSendPackage;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.MultiLineEditBox;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.GameType;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public class PostBoxScreen
extends AbstractContainerScreen<PostBoxMenu> {
    private static final Component MAILBOXES_LABEL = Utils.translation("gui", "mailboxes", new Object[0]);
    private static final MutableComponent DEFAULT_MAILBOX_NAME = Utils.translation("gui", "default_mailbox_name", new Object[0]);
    private static final MutableComponent UNKNOWN_MAILBOX_OWNER = Utils.translation("gui", "unknown_mailbox_owner", new Object[0]);
    private static final ResourceLocation POST_BOX_TEXTURE = Utils.resource("textures/gui/container/post_box.png");
    private static final ResourceLocation VILLAGER_TEXTURE = new ResourceLocation("textures/gui/container/villager2.png");
    private static final Map<UUID, PlayerInfo> PLAYER_INFO_CACHE = new HashMap<UUID, PlayerInfo>();
    private static final int SCROLL_SPEED = 5;
    private static final int SCROLL_BAR_WIDTH = 6;
    private static final int SCROLL_BAR_HEIGHT = 27;
    private static final int MAILBOX_ENTRY_WIDTH = 85;
    private static final int MAILBOX_ENTRY_HEIGHT = 14;
    private static final int CONTAINER_LEFT = 8;
    private static final int CONTAINER_TOP = 34;
    private static final int CONTAINER_HEIGHT = 130;
    private static final int CONTAINER_WIDTH = 85;
    private static final int MAX_VISIBLE_ITEMS = Mth.m_14165_((double)9.285714285714286) + 1;
    private static final int MAX_RESPONSE_DISPLAY_TIME = 100;
    protected List<IMailbox> mailboxes = new ArrayList<IMailbox>();
    protected IMailbox selected;
    protected EditBox searchEditBox;
    protected String query = "";
    protected MultiLineEditBox messageEditBox;
    protected Button sendButton;
    protected String message = "";
    protected int scroll;
    protected int clickedY = -1;
    protected List<FormattedCharSequence> tooltip;
    @Nullable
    protected String responseTranslationKey;
    protected boolean responseSuccess;
    protected int responseTimer;

    public PostBoxScreen(PostBoxMenu menu, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)menu, playerInventory, (Component)Component.m_237119_());
        this.f_97726_ = 283;
        this.f_97727_ = 172;
        this.f_97730_ = 113;
        this.f_97731_ = this.f_97727_ - 93;
        this.updateSearchFilter();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.searchEditBox = new EditBox(this.f_96547_, this.f_97735_ + 8, this.f_97736_ + 18, 92, 12, (Component)Utils.translation("gui", "search_mailboxes", new Object[0]));
        this.m_142416_((GuiEventListener)this.searchEditBox);
        this.searchEditBox.m_94144_("");
        this.searchEditBox.m_94151_(s -> {
            this.query = s;
            this.updateSearchFilter();
            this.scroll(0);
        });
        if (!this.query.isBlank()) {
            this.searchEditBox.m_94144_(this.query);
        }
        this.messageEditBox = new MultiLineEditBox(this.f_96547_, this.f_97735_ + 118, this.f_97736_ + 13, 116, 54, (Component)Utils.translation("gui", "enter_message", new Object[0]), (Component)Utils.translation("gui", "package_message", new Object[0])){

            protected void m_239516_(PoseStack poseStack) {
            }

            protected boolean m_239656_() {
                return false;
            }
        };
        this.m_142416_((GuiEventListener)this.messageEditBox);
        if (!this.message.isBlank()) {
            this.messageEditBox.m_240159_(this.message);
        } else {
            this.messageEditBox.m_240159_("");
        }
        this.messageEditBox.m_239273_(s -> {
            this.message = s;
        });
        this.sendButton = new IconButton(this.f_97735_ + 284, this.f_97736_ + 22, 20, 0, 18, 18, CommonComponents.f_237098_, btn -> {
            if (this.selected != null) {
                Network.getPlay().sendToServer((IMessage)new MessageSendPackage(this.selected.getId(), this.message));
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
            }
        }, (btn, poseStack, mouseX, mouseY) -> this.m_96602_(poseStack, (Component)Utils.translation("gui", "send", new Object[0]), mouseX, mouseY));
        this.m_142416_((GuiEventListener)this.sendButton);
    }

    protected void m_181908_() {
        this.searchEditBox.m_94120_();
        this.messageEditBox.m_239213_();
        if (this.responseTranslationKey != null) {
            ++this.responseTimer;
            if (this.responseTimer == 100) {
                this.responseTranslationKey = null;
            }
        }
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
        this.searchEditBox.m_94167_(this.searchEditBox.m_94155_().isBlank() ? Utils.translation("gui", "search", new Object[0]).getString() : "");
        this.sendButton.f_93623_ = this.selected != null && !((PostBoxMenu)this.f_97732_).getContainer().m_7983_();
        this.searchEditBox.m_94202_(this.searchEditBox.m_94155_().isEmpty() && !this.searchEditBox.m_93696_() ? 0x707070 : 0xE0E0E0);
        this.m_7333_(poseStack);
        super.m_6305_(poseStack, mouseX, mouseY, partialTick);
        this.m_7025_(poseStack, mouseX, mouseY);
    }

    protected void m_7027_(PoseStack poseStack, int mouseX, int mouseY) {
        super.m_7027_(poseStack, mouseX, mouseY);
        ScreenHelper.drawString(poseStack, MAILBOXES_LABEL, this.f_97728_, this.f_97729_, -2039584, false);
    }

    protected void m_7286_(PoseStack poseStack, float partialTick, int mouseX, int mouseY) {
        this.tooltip = null;
        RenderSystem.m_157456_((int)0, (ResourceLocation)POST_BOX_TEXTURE);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)(this.f_97726_ + 25), (int)this.f_97727_, (int)512, (int)256);
        GuiComponent.m_239260_((int)(this.f_97735_ + 8), (int)(this.f_97736_ + 34), (int)(this.f_97735_ + 8 + 85), (int)(this.f_97736_ + 34 + 130));
        int scroll = this.clampScroll(this.scroll + this.getDeltaScroll(mouseY));
        int startIndex = Mth.m_14045_((int)(scroll / 14), (int)0, (int)Math.max(0, this.mailboxes.size() - MAX_VISIBLE_ITEMS));
        int maxItems = Math.min(MAX_VISIBLE_ITEMS, this.mailboxes.size());
        for (int i = 0; i < maxItems; ++i) {
            int entryIndex = startIndex + i;
            int entryX = this.f_97735_ + 8;
            int entryY = this.f_97736_ + 34 + entryIndex * 14 - scroll;
            IMailbox mailbox = this.mailboxes.get(entryIndex);
            boolean selected = this.selected == mailbox;
            RenderSystem.m_157456_((int)0, (ResourceLocation)POST_BOX_TEXTURE);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)entryX, (int)entryY, (float)0.0f, (float)(selected ? 172.0f : 186.0f), (int)85, (int)14, (int)512, (int)256);
            Optional<GameProfile> optional = mailbox.getOwner();
            if (optional.isPresent()) {
                PlayerInfo info = this.getPlayerInfo(optional.get());
                RenderSystem.m_157456_((int)0, (ResourceLocation)info.m_105337_());
                PlayerFaceRenderer.m_240071_((PoseStack)poseStack, (int)(entryX + 3), (int)(entryY + 3), (int)8);
            }
            Component mailboxName = (Component)mailbox.getCustomName().filter(s -> !s.isBlank()).map(Component::m_237113_).orElse(DEFAULT_MAILBOX_NAME);
            ScreenHelper.drawString(poseStack, mailboxName, entryX + 15, entryY + 3, selected ? -171 : -1, true);
            if (!this.m_6774_(entryX - this.f_97735_ + 3, entryY - this.f_97736_ + 3, 8, 8, mouseX, mouseY)) continue;
            Component ownerName = (Component)mailbox.getOwner().map(GameProfile::getName).map(Component::m_237113_).orElse(UNKNOWN_MAILBOX_OWNER);
            this.tooltip = ScreenHelper.createMultilineTooltip(List.of(ownerName));
        }
        GuiComponent.m_240060_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)VILLAGER_TEXTURE);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 8 + 85 + 1), (int)(this.f_97736_ + 34 + this.getScrollBarOffset(mouseY)), (float)(this.canScroll() ? 0.0f : 6.0f), (float)199.0f, (int)6, (int)27, (int)512, (int)256);
        for (int j = 0; j < 3; ++j) {
            for (int i = 0; i < 2; ++i) {
                if (!((PostBoxMenu)this.f_97732_).getContainer().m_8020_(j * 2 + i).m_41619_()) continue;
                RenderSystem.m_157456_((int)0, (ResourceLocation)POST_BOX_TEXTURE);
                GuiComponent.m_93133_((PoseStack)poseStack, (int)(this.f_97735_ + 235 + i * 18), (int)(this.f_97736_ + 14 + j * 18), (float)85.0f, (float)172.0f, (int)16, (int)16, (int)512, (int)256);
            }
        }
        if (this.responseTranslationKey != null && this.responseTimer < 100) {
            MutableComponent responseMessage = Component.m_237115_((String)this.responseTranslationKey);
            int contentWidth = this.f_96547_.m_92852_((FormattedText)responseMessage) + 4;
            int responseToastWidth = 4 + contentWidth + 3;
            int responseToastLeft = this.f_97735_ + this.f_97726_ / 2 - responseToastWidth / 2;
            int responseToastTop = this.f_97736_ - 22;
            poseStack.m_85836_();
            if (this.responseTimer < 5) {
                float frameTime = this.f_96541_.m_91296_();
                poseStack.m_85837_(0.0, (double)((5.0f - ((float)this.responseTimer + frameTime)) * 5.0f), 0.0);
            } else if (100 - this.responseTimer < 5) {
                float frameTime = this.f_96541_.m_91296_();
                float offset = 5.0f - (100.0f - ((float)this.responseTimer + frameTime));
                poseStack.m_85837_(0.0, (double)(offset * 5.0f), 0.0);
            }
            GuiComponent.m_239260_((int)responseToastLeft, (int)(this.f_97736_ - 22), (int)(responseToastLeft + responseToastWidth), (int)this.f_97736_);
            RenderSystem.m_157456_((int)0, (ResourceLocation)POST_BOX_TEXTURE);
            int toastU = this.responseSuccess ? 8 : 0;
            GuiComponent.m_93133_((PoseStack)poseStack, (int)responseToastLeft, (int)responseToastTop, (float)toastU, (float)200.0f, (int)4, (int)18, (int)512, (int)256);
            GuiComponent.m_93160_((PoseStack)poseStack, (int)(responseToastLeft + 4), (int)responseToastTop, (int)contentWidth, (int)18, (float)(toastU + 4), (float)200.0f, (int)1, (int)18, (int)512, (int)256);
            GuiComponent.m_93133_((PoseStack)poseStack, (int)(responseToastLeft + 4 + contentWidth), (int)responseToastTop, (float)(toastU + 5), (float)200.0f, (int)3, (int)18, (int)512, (int)256);
            this.f_96547_.m_92889_(poseStack, (Component)responseMessage, (float)(responseToastLeft + 6), (float)(responseToastTop + 5), -1);
            GuiComponent.m_240060_();
            poseStack.m_85849_();
        }
        if (this.m_6774_(91, 5, 10, 10, mouseX, mouseY)) {
            this.tooltip = ScreenHelper.createMultilineTooltip(List.of(Utils.translation("gui", "how_to", new Object[0]).m_130940_(ChatFormatting.GOLD), Utils.translation("gui", "post_box_info", new Object[0])));
        }
    }

    protected void m_7025_(PoseStack poseStack, int mouseX, int mouseY) {
        if (this.tooltip != null) {
            this.m_96617_(poseStack, this.tooltip, mouseX, mouseY);
            return;
        }
        super.m_7025_(poseStack, mouseX, mouseY);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            int relativeMouseY;
            int clickedIndex;
            this.m_7522_(null);
            if (this.m_6774_(8, 34, 85, 130, mouseX, mouseY) && (clickedIndex = (this.scroll + (relativeMouseY = (int)(mouseY - (double)this.f_97736_ - 34.0))) / 14) >= 0 && clickedIndex < this.mailboxes.size()) {
                IMailbox mailbox = this.mailboxes.get(clickedIndex);
                this.selected = this.selected != mailbox ? mailbox : null;
                this.f_96541_.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11714_, (float)1.0f, (float)1.0f));
                this.sendButton.f_93623_ = this.selected != null;
                return true;
            }
            if (this.m_6774_(94, 34 + this.getScrollBarOffset((int)mouseY), 6, 27, mouseX, mouseY)) {
                this.clickedY = (int)mouseY;
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.clickedY >= 0) {
            this.scroll(this.getDeltaScroll((int)mouseY));
            this.clickedY = -1;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7933_(int key, int scanCode, int modifiers) {
        if (this.searchEditBox.m_93696_()) {
            return this.searchEditBox.m_7933_(key, scanCode, modifiers);
        }
        if (this.messageEditBox.m_93696_()) {
            return this.messageEditBox.m_7933_(key, scanCode, modifiers);
        }
        return super.m_7933_(key, scanCode, modifiers);
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        if (this.m_6774_(8, 34, 85, 130, mouseX, mouseY)) {
            this.scroll((int)(-5.0 * amount));
            return true;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    private void scroll(int amount) {
        this.scroll = this.clampScroll(this.scroll + amount);
    }

    private int clampScroll(int scroll) {
        return Mth.m_14045_((int)scroll, (int)0, (int)this.getMaxScroll());
    }

    private int getMaxScroll() {
        return Math.max(this.mailboxes.size() * 14 - 130, 0);
    }

    private boolean canScroll() {
        return this.getMaxScroll() > 0;
    }

    private int getScrollBarOffset(int mouseY) {
        int scroll = this.clampScroll(this.scroll + this.getDeltaScroll(mouseY));
        return (int)(103.0 * ((double)scroll / (double)this.getMaxScroll()));
    }

    private int getDeltaScroll(int mouseY) {
        if (this.clickedY != -1) {
            double pixelsPerScroll = 103.0 / (double)this.getMaxScroll();
            return (int)((double)(mouseY - this.clickedY) / pixelsPerScroll);
        }
        return 0;
    }

    private void updateSearchFilter() {
        List<IMailbox> filteredMailboxes = ((PostBoxMenu)this.f_97732_).getMailboxes().stream().filter(mailbox -> {
            if (this.query.startsWith("@")) {
                String ownerName = mailbox.getOwner().map(GameProfile::getName).orElse("Unknown");
                return StringUtils.containsIgnoreCase((CharSequence)ownerName, (CharSequence)this.query.substring(1));
            }
            String mailboxName = mailbox.getCustomName().orElse("Mailbox");
            return StringUtils.containsIgnoreCase((CharSequence)mailboxName, (CharSequence)this.query);
        }).sorted(Comparator.comparing(mailbox -> mailbox.getOwner().map(GameProfile::getName).orElse("Unknown")).thenComparing(mailbox -> mailbox.getCustomName().orElse("Mailbox"))).toList();
        this.mailboxes.clear();
        this.mailboxes.addAll(filteredMailboxes);
    }

    private PlayerInfo getPlayerInfo(GameProfile profile) {
        PlayerInfo info;
        ClientPacketListener listener;
        if (this.f_96541_ != null && (listener = this.f_96541_.m_91403_()) != null && (info = listener.m_104949_(profile.getId())) != null) {
            return info;
        }
        return PLAYER_INFO_CACHE.computeIfAbsent(profile.getId(), uuid -> {
            ClientboundPlayerInfoPacket.PlayerUpdate update = new ClientboundPlayerInfoPacket.PlayerUpdate(profile, 0, GameType.SURVIVAL, null, null);
            return new PlayerInfo(update, this.f_96541_.m_231417_(), false);
        });
    }

    public void showResponse(DeliveryResult result) {
        result.message().ifPresent(key -> {
            this.responseSuccess = result.success();
            this.responseTranslationKey = key;
            this.responseTimer = 0;
        });
    }

    public void clearMessage() {
        this.messageEditBox.m_240159_("");
    }
}

