/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.furniture.refurbished.Components;
import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.client.LinkHandler;
import com.mrcrayfish.furniture.refurbished.client.gui.overlay.IHudOverlay;
import com.mrcrayfish.furniture.refurbished.client.gui.widget.IconButton;
import com.mrcrayfish.furniture.refurbished.client.util.ScreenHelper;
import com.mrcrayfish.furniture.refurbished.electricity.Connection;
import com.mrcrayfish.furniture.refurbished.electricity.IElectricityNode;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class NodeIndicatorOverlay
implements IHudOverlay {
    @Override
    public void draw(PoseStack poseStack, float partialTick) {
        IElectricityNode node1;
        BlockHitResult result;
        BlockEntity entity;
        Connection connection;
        IElectricityNode linking;
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91073_ == null || mc.f_91077_ == null) {
            return;
        }
        if (mc.f_91074_ == null) {
            return;
        }
        LinkHandler handler = LinkHandler.get();
        IElectricityNode target = handler.getTargetNode();
        if (handler.isLinking()) {
            double linkLength = handler.getLinkLength();
            if (linkLength > 512.0) {
                this.drawLabel(mc, poseStack, Components.GUI_LINK_TOO_LONG, 40, 0);
                return;
            }
            linking = handler.getLinkingNode((Level)mc.f_91073_);
            if (target != null && linking != null && target != linking) {
                if (target.isSourceNode() && linking.isSourceNode()) {
                    this.drawLabel(mc, poseStack, Components.GUI_LINK_INVALID_NODE, 40, 0);
                    return;
                }
                int nodeLinkLength = (int)(Vec3.m_82512_((Vec3i)linking.getNodePosition()).m_82554_(Vec3.m_82512_((Vec3i)target.getNodePosition())) + 0.5);
                if ((double)nodeLinkLength > 512.0) {
                    this.drawLabel(mc, poseStack, Components.GUI_LINK_TOO_LONG, 40, 0);
                    return;
                }
                if (target.isNodeConnectionLimitReached()) {
                    this.drawLabel(mc, poseStack, Components.GUI_LINK_TOO_MANY, 40, 0);
                    return;
                }
                if (handler.canLinkToNode((Level)mc.f_91073_, target)) {
                    if (!handler.isLinkInsidePowerableArea()) {
                        this.drawLabel(mc, poseStack, Components.GUI_LINK_UNPOWERABLE, 30, 0);
                        return;
                    }
                    MutableComponent label = Utils.translation("gui", "progress", target.getNodeConnections().size(), Components.GUI_SLASH, target.getNodeMaximumConnections());
                    this.drawLabel(mc, poseStack, (Component)label, 0, 10);
                    return;
                }
            }
            if (!handler.isLinkInsidePowerableArea()) {
                this.drawLabel(mc, poseStack, Components.GUI_LINK_OUTSIDE_AREA, 40, 0);
                return;
            }
        } else if (target != null) {
            MutableComponent label = Utils.translation("gui", "progress", target.getNodeConnections().size(), Components.GUI_SLASH, target.getNodeMaximumConnections());
            this.drawLabel(mc, poseStack, (Component)label, 0, 10);
            return;
        }
        if ((connection = handler.getTargetConnection()) != null && connection.isCrossingPowerableZone((Level)mc.f_91073_)) {
            this.drawLabel(mc, poseStack, Components.GUI_LINK_OUTSIDE_AREA, 40, 0);
            return;
        }
        if (!LinkHandler.isHoldingWrench() && (linking = mc.f_91077_) instanceof BlockHitResult && (entity = mc.f_91073_.m_7702_((result = (BlockHitResult)linking).m_82425_())) instanceof IElectricityNode && !(node1 = (IElectricityNode)entity).isNodeInPowerableNetwork() && !((Boolean)Config.SERVER.electricity.cheats.everythingIsPowered.get()).booleanValue()) {
            this.drawLabel(mc, poseStack, Components.GUI_NO_POWER, 20, 20);
        }
    }

    private void drawLabel(Minecraft mc, PoseStack poseStack, Component label, int iconU, int iconV) {
        int padding = 3;
        int iconSize = 10;
        int messageWidth = mc.f_91062_.m_92852_((FormattedText)label);
        int contentWidth = padding + iconSize + padding + messageWidth + padding;
        Objects.requireNonNull(mc.f_91062_);
        int contentHeight = padding + 9 + padding;
        int guiWidth = mc.m_91268_().m_85445_();
        int guiHeight = mc.m_91268_().m_85446_();
        int contentStart = (guiWidth - contentWidth) / 2;
        int contentTop = (guiHeight - contentHeight) / 2 + 50;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)contentStart, (int)(contentTop + 1), (int)(contentStart + 1), (int)(contentTop + contentHeight - 1), (int)0x77000000);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(contentStart + 1), (int)contentTop, (int)(contentStart + contentWidth - 1), (int)(contentTop + contentHeight), (int)0x77000000);
        GuiComponent.m_93172_((PoseStack)poseStack, (int)(contentStart + contentWidth - 1), (int)(contentTop + 1), (int)(contentStart + contentWidth), (int)(contentTop + contentHeight - 1), (int)0x77000000);
        RenderSystem.m_157456_((int)0, (ResourceLocation)IconButton.ICON_TEXTURES);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)(contentStart + padding), (int)(contentTop + padding), (float)iconU, (float)iconV, (int)iconSize, (int)iconSize, (int)64, (int)64);
        ScreenHelper.drawString(poseStack, label, contentStart + padding + iconSize + padding, contentTop + padding + 1, -1, true);
    }
}

