/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.refurbished.blockentity;

import com.mrcrayfish.furniture.refurbished.Config;
import com.mrcrayfish.furniture.refurbished.blockentity.ElectricityModuleLootBlockEntity;
import com.mrcrayfish.furniture.refurbished.blockentity.IHomeControlDevice;
import com.mrcrayfish.furniture.refurbished.blockentity.ILevelAudio;
import com.mrcrayfish.furniture.refurbished.blockentity.IPowerSwitch;
import com.mrcrayfish.furniture.refurbished.blockentity.IProcessingBlock;
import com.mrcrayfish.furniture.refurbished.client.audio.AudioManager;
import com.mrcrayfish.furniture.refurbished.core.ModBlockEntities;
import com.mrcrayfish.furniture.refurbished.core.ModSounds;
import com.mrcrayfish.furniture.refurbished.inventory.BuildableContainerData;
import com.mrcrayfish.furniture.refurbished.inventory.RecycleBinMenu;
import com.mrcrayfish.furniture.refurbished.util.BlockEntityHelper;
import com.mrcrayfish.furniture.refurbished.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class RecycleBinBlockEntity
extends ElectricityModuleLootBlockEntity
implements IProcessingBlock,
IPowerSwitch,
ILevelAudio,
IHomeControlDevice,
Nameable {
    public static final int[] INPUT_SLOTS = new int[]{0, 1, 2};
    public static final int DATA_POWERED = 0;
    public static final int DATA_ENABLED = 1;
    public static final int DATA_PROCESSING_TIME = 2;
    public static final int DATA_RECYCLED = 3;
    protected final Vec3 audioPosition;
    protected boolean powered;
    protected boolean processing;
    protected int processingTime;
    protected boolean enabled;
    protected int recycled;
    protected final ContainerData data = new BuildableContainerData(builder -> {
        builder.add(1, () -> this.enabled ? 1 : 0, value -> {});
        builder.add(0, () -> this.powered ? 1 : 0, value -> {});
        builder.add(2, () -> this.processingTime, value -> {});
        builder.add(3, () -> this.recycled, value -> {});
    });

    public RecycleBinBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.RECYCLE_BIN.get(), pos, state);
    }

    public RecycleBinBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state, 3);
        this.audioPosition = Vec3.m_82512_((Vec3i)pos);
    }

    @Override
    public int[] m_7071_(Direction direction) {
        return INPUT_SLOTS;
    }

    @Override
    public boolean isMatchingContainerMenu(AbstractContainerMenu menu) {
        RecycleBinMenu recycleBin;
        return menu instanceof RecycleBinMenu && (recycleBin = (RecycleBinMenu)menu).getContainer() == this;
    }

    protected Component m_6820_() {
        return Utils.translation("container", "recycle_bin", new Object[0]);
    }

    protected AbstractContainerMenu m_6555_(int windowId, Inventory playerInventory) {
        return new RecycleBinMenu(windowId, playerInventory, (Container)this, this.data);
    }

    @Override
    public SoundEvent getSound() {
        return (SoundEvent)ModSounds.BLOCK_RECYCLE_BIN_ENGINE.get();
    }

    @Override
    public SoundSource getSource() {
        return SoundSource.BLOCKS;
    }

    @Override
    public Vec3 getAudioPosition() {
        return this.audioPosition;
    }

    @Override
    public boolean canPlayAudio() {
        return this.isNodePowered() && this.processing && this.enabled && !this.m_58901_();
    }

    @Override
    public int getAudioHash() {
        return this.f_58858_.hashCode();
    }

    @Override
    public boolean isAudioEqual(ILevelAudio other) {
        return other == this;
    }

    @Override
    public boolean isNodePowered() {
        return this.powered;
    }

    @Override
    public void setNodePowered(boolean powered) {
        this.powered = powered;
        this.m_6596_();
        this.sync();
    }

    @Override
    public int getEnergy() {
        return 0;
    }

    @Override
    public void addEnergy(int energy) {
    }

    @Override
    public boolean requiresEnergy() {
        return false;
    }

    @Override
    public int retrieveEnergy(boolean simulate) {
        return 0;
    }

    @Override
    public int updateAndGetTotalProcessingTime() {
        return this.getTotalProcessingTime();
    }

    @Override
    public int getTotalProcessingTime() {
        return (Integer)Config.SERVER.recycleBin.processingTime.get();
    }

    @Override
    public int getProcessingTime() {
        return this.processingTime;
    }

    @Override
    public void setProcessingTime(int time) {
        this.processingTime = time;
    }

    @Override
    public void onCompleteProcess() {
        this.recycleItem();
    }

    @Override
    public boolean canProcess() {
        if (this.enabled && this.isNodePowered()) {
            for (int index : INPUT_SLOTS) {
                if (this.m_8020_(index).m_41619_()) continue;
                return !this.isMaxExperience();
            }
        }
        return false;
    }

    private int getCurrentExperiencePoints() {
        return (int)Mth.m_14008_((double)((double)this.recycled * (Double)Config.SERVER.recycleBin.experiencePerItem.get()), (double)0.0, (double)this.getMaxExperience());
    }

    private boolean isMaxExperience() {
        return this.getCurrentExperiencePoints() >= this.getMaxExperience();
    }

    public void withdrawExperience(ServerPlayer player) {
        int points = this.getCurrentExperiencePoints();
        if (points > 0) {
            player.m_9236_().m_7967_((Entity)new ExperienceOrb((Level)player.m_9236_(), player.m_20185_(), player.m_20186_(), player.m_20189_(), points));
            this.recycled = 0;
            this.m_6596_();
        }
    }

    private int getMaxExperience() {
        int maxLevel = (Integer)Config.SERVER.recycleBin.maximumExperienceLevels.get();
        if (maxLevel <= 16) {
            return Mth.m_144944_((int)maxLevel) + 6 * maxLevel;
        }
        if (maxLevel <= 31) {
            return (int)(2.5 * (double)Mth.m_144944_((int)maxLevel) - 40.5 * (double)maxLevel + 360.0);
        }
        return (int)(4.5 * (double)Mth.m_144944_((int)maxLevel) - 162.5 * (double)maxLevel + 2220.0);
    }

    @Override
    public void togglePower() {
        this.enabled = !this.enabled;
        this.m_6596_();
        this.sync();
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, RecycleBinBlockEntity recycleBin) {
        boolean processing = recycleBin.processTick();
        if (recycleBin.processing != processing) {
            recycleBin.processing = processing;
            recycleBin.sync();
        }
    }

    public static void clientTick(Level level, BlockPos pos, BlockState state, RecycleBinBlockEntity recycleBin) {
        AudioManager.get().playLevelAudio(recycleBin);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("Powered", 1)) {
            this.powered = tag.m_128471_("Powered");
        }
        if (tag.m_128425_("Enabled", 1)) {
            this.enabled = tag.m_128471_("Enabled");
        }
        if (tag.m_128425_("ProcessTime", 3)) {
            this.processingTime = tag.m_128451_("ProcessTime");
        }
        if (tag.m_128425_("Processing", 1)) {
            this.processing = tag.m_128471_("Processing");
        }
        if (tag.m_128425_("Recycled", 3)) {
            this.recycled = Math.max(tag.m_128451_("Recycled"), 0);
        }
    }

    @Override
    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128379_("Powered", this.powered);
        tag.m_128379_("Enabled", this.enabled);
        tag.m_128405_("ProcessTime", this.processingTime);
        tag.m_128405_("Recycled", this.recycled);
    }

    @Override
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.writeNodeNbt(tag);
        tag.m_128379_("Powered", this.powered);
        tag.m_128379_("Enabled", this.enabled);
        tag.m_128379_("Processing", this.processing);
        BlockEntityHelper.saveCustomName(tag, this.m_7770_());
        return tag;
    }

    private void sync() {
        if (!this.f_58857_.m_5776_()) {
            BlockEntityHelper.sendCustomUpdate((BlockEntity)this, this.m_5995_());
        }
    }

    private void recycleItem() {
        for (int index : INPUT_SLOTS) {
            ItemStack stack = this.m_8020_(index);
            if (stack.m_41619_()) continue;
            stack.m_41774_(1);
            ++this.recycled;
            this.m_6596_();
            break;
        }
    }

    @Override
    public BlockPos getDevicePos() {
        return this.f_58858_;
    }

    @Override
    public boolean isDeviceEnabled() {
        return this.enabled;
    }

    @Override
    public void toggleDeviceState() {
        this.enabled = !this.enabled;
        this.m_6596_();
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, this.m_5995_());
    }

    @Override
    public void setDeviceState(boolean enabled) {
        this.enabled = enabled;
        this.m_6596_();
        BlockEntityHelper.sendCustomUpdate((BlockEntity)this, this.m_5995_());
    }

    @Override
    public Component getDeviceName() {
        if (this.m_8077_()) {
            return this.m_7770_();
        }
        return this.m_6820_();
    }
}

