/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.currentgamemusictrack_common_forge.mixin;

import com.natamus.currentgamemusictrack_common_forge.data.Variables;
import com.natamus.currentgamemusictrack_common_forge.util.Util;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.MusicManager;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={MusicManager.class}, priority=1001)
public class MusicManagerMixin {
    @Shadow
    private SoundInstance currentMusic;

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo ci) {
        if (this.currentMusic != null) {
            ResourceLocation currentMusicRl;
            Sound sound = this.currentMusic.getSound();
            if (sound != null && (currentMusicRl = sound.getLocation()) != Variables.lastMusicResourceLocation) {
                Util.displaySongTitle(this.currentMusic, currentMusicRl);
            }
        } else if (Variables.lastMusicResourceLocation != null) {
            Variables.lastMusicResourceLocation = null;
        }
    }
}

