/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.currentgamemusictrack_common_forge.events;

import com.mojang.blaze3d.platform.Window;
import com.natamus.collective_common_forge.functions.GUIFunctions;
import com.natamus.currentgamemusictrack_common_forge.config.ConfigHandler;
import com.natamus.currentgamemusictrack_common_forge.data.Constants;
import com.natamus.currentgamemusictrack_common_forge.data.Variables;
import com.natamus.currentgamemusictrack_common_forge.util.Util;
import java.awt.Color;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.chat.Component;
import org.joml.Matrix3x2fStack;

public class GUIEvent {
    public static void renderOverlay(GuiGraphics guiGraphics, DeltaTracker deltaTracker) {
        if (GUIFunctions.shouldHideGUI()) {
            return;
        }
        if (Variables.guiOpacity <= 0) {
            return;
        }
        Object musicGUIString = "";
        if (Variables.lastMusicResourceLocation != null) {
            musicGUIString = "\ud83c\udfb5 " + Util.getMusicTitle(Variables.lastMusicResourceLocation) + " \ud83c\udfb5";
        }
        if (((String)musicGUIString).equals("")) {
            return;
        }
        Matrix3x2fStack matrixStack = guiGraphics.pose();
        matrixStack.pushMatrix();
        Font font = Constants.mc.font;
        Window scaled = Constants.mc.getWindow();
        int width = scaled.getGuiScaledWidth();
        int height = scaled.getGuiScaledHeight();
        if (Variables.guiOpacity > 255) {
            Variables.guiOpacity = 255;
        }
        Color colour = new Color(ConfigHandler.RGB_R, ConfigHandler.RGB_G, ConfigHandler.RGB_B, Variables.guiOpacity);
        int titleStringWidth = font.width((String)musicGUIString);
        int titleXCoord = 0;
        titleXCoord = ConfigHandler.musicGUIPositionIsLeft ? 5 : (ConfigHandler.musicGUIPositionIsCenter ? width / 2 - titleStringWidth / 2 : width - titleStringWidth - 5);
        GUIEvent.drawText(font, guiGraphics, (String)musicGUIString, titleXCoord, height - ConfigHandler.musicGUIBottomHeightOffset, colour, ConfigHandler.drawTextShadow);
        matrixStack.popMatrix();
    }

    public static void onClientTick(ClientLevel clientLevel) {
        if (Variables.fadeIn) {
            if (!ConfigHandler.titleShouldFadeIn) {
                Variables.guiOpacity = 255;
            } else if (Variables.guiOpacity < 255) {
                Variables.guiOpacity += 5;
                return;
            }
            Variables.fadeIn = false;
            return;
        }
        if (Variables.guiTicksLeft > 0) {
            --Variables.guiTicksLeft;
            Variables.fadeOut = true;
            return;
        }
        if (Variables.fadeOut) {
            if (!ConfigHandler.titleShouldFadeIn) {
                Variables.guiOpacity = 0;
            } else if (Variables.guiOpacity > 0) {
                Variables.guiOpacity -= 5;
                return;
            }
            Variables.fadeOut = false;
        }
    }

    private static void drawText(Font font, GuiGraphics guiGraphics, String content, int x, int y, Color colour, boolean drawShadow) {
        if (Variables.guiOpacity > 10 && !content.equals("")) {
            guiGraphics.drawString(font, (Component)Component.literal((String)content), x, y, colour.getRGB(), drawShadow);
        }
    }
}

