/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.wanderingtradermayleave_common_forge.button;

import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;

public class SmallTextButton
extends Button {
    protected static final WidgetSprites SPRITES = new WidgetSprites(ResourceLocation.withDefaultNamespace((String)"widget/button"), ResourceLocation.withDefaultNamespace((String)"widget/button_disabled"), ResourceLocation.withDefaultNamespace((String)"widget/button_highlighted"));

    public SmallTextButton(int x, int y, int width, int height, Component message, Button.OnPress onPress) {
        super(x, y, width, height, message, onPress, DEFAULT_NARRATION);
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        Font font = Minecraft.getInstance().font;
        guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SPRITES.get(this.active, this.isHoveredOrFocused()), this.getX(), this.getY(), this.getWidth(), this.getHeight(), ARGB.white((float)this.alpha));
        float scale = 0.66f;
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().scale(scale, scale);
        int scaledX = (int)(((double)this.getX() + 0.5 + (double)((float)this.getWidth() / 2.0f) - (double)((float)font.width((FormattedText)this.getMessage()) * scale / 2.0f)) / (double)scale);
        double d = (double)this.getY() + 0.8 + (double)((float)this.getHeight() / 2.0f);
        Objects.requireNonNull(font);
        int scaledY = (int)((d - (double)(9.0f * scale / 2.0f)) / (double)scale);
        guiGraphics.drawString(font, this.getMessage(), scaledX, scaledY, -1);
        guiGraphics.pose().popMatrix();
    }

    private boolean isHovered(int mouseX, int mouseY) {
        return mouseX >= this.getX() && mouseX <= this.getX() + this.getWidth() && mouseY >= this.getY() && mouseY <= this.getY() + this.getHeight();
    }
}

