/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.giantspawn_common_neoforge.mixin;

import com.natamus.giantspawn_common_neoforge.ai.GiantAttackGoal;
import com.natamus.giantspawn_common_neoforge.ai.GiantAttackTurtleEggGoal;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.monster.Giant;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={Giant.class}, priority=1001)
public class GiantMixin
extends Mob {
    protected GiantMixin(EntityType<? extends Mob> entityType, Level level) {
        super(entityType, level);
    }

    protected void registerGoals() {
        Giant giant = (Giant)this;
        this.goalSelector.addGoal(4, (Goal)new GiantAttackTurtleEggGoal((PathfinderMob)giant, 1.0, 3));
        this.goalSelector.addGoal(8, (Goal)new LookAtPlayerGoal((Mob)giant, Player.class, 8.0f));
        this.goalSelector.addGoal(8, (Goal)new RandomLookAroundGoal((Mob)giant));
        this.addBehaviourGoals(giant);
    }

    protected void addBehaviourGoals(Giant giant) {
        this.goalSelector.addGoal(2, (Goal)new GiantAttackGoal(giant, 1.0, false));
        this.goalSelector.addGoal(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)giant, 1.0));
        this.targetSelector.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)giant, new Class[0]).setAlertOthers(new Class[]{ZombifiedPiglin.class}));
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)giant, Player.class, true));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)giant, AbstractVillager.class, false));
        this.targetSelector.addGoal(3, (Goal)new NearestAttackableTargetGoal((Mob)giant, IronGolem.class, true));
        this.targetSelector.addGoal(5, (Goal)new NearestAttackableTargetGoal((Mob)giant, Turtle.class, 10, true, false, Turtle.BABY_ON_LAND_SELECTOR));
    }
}

