/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.firespreadtweaks_common_forge.events;

import com.natamus.collective_common_forge.functions.BlockFunctions;
import com.natamus.collective_common_forge.functions.HashMapFunctions;
import com.natamus.firespreadtweaks_common_forge.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;

public class FireSpreadEvent {
    private static final HashMap<BlockPos, Integer> ticksleft = new HashMap();
    private static final HashMap<Level, CopyOnWriteArrayList<BlockPos>> firepositions = new HashMap();
    private static final List<Block> fireblocks = new ArrayList<Block>(Arrays.asList(Blocks.NETHERRACK, Blocks.MAGMA_BLOCK, Blocks.SOUL_SAND, Blocks.SOUL_SOIL));

    public static void onWorldTick(ServerLevel level) {
        for (BlockPos firepos : (CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(firepositions, (Object)level, k -> new CopyOnWriteArrayList())) {
            if (!ticksleft.containsKey(firepos)) {
                ticksleft.put(firepos, Util.getFireBurnDurationInTicks());
                continue;
            }
            int tl = ticksleft.get(firepos) - 1;
            if (tl <= 0) {
                ticksleft.remove(firepos);
                firepositions.get(level).remove(firepos);
                BlockState firestate = level.getBlockState(firepos);
                Block fireblock = firestate.getBlock();
                if (!(fireblock instanceof FireBlock)) continue;
                level.setBlockAndUpdate(firepos, Blocks.AIR.defaultBlockState());
                continue;
            }
            ticksleft.put(firepos, tl);
        }
    }

    public static void onWorldLoad(ServerLevel level) {
        GameRules.BooleanValue firetickvalue = (GameRules.BooleanValue)level.getGameRules().getRule(GameRules.RULE_DOFIRETICK);
        if (firetickvalue.get()) {
            firetickvalue.set(false, level.getServer());
        }
    }

    public static void onWorldUnload(ServerLevel level) {
        for (BlockPos firepos : (CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(firepositions, (Object)level, k -> new CopyOnWriteArrayList())) {
            BlockState firestate = level.getBlockState(firepos);
            Block fireblock = firestate.getBlock();
            if (!(fireblock instanceof FireBlock)) continue;
            level.setBlockAndUpdate(firepos, Blocks.AIR.defaultBlockState());
        }
    }

    public static void onNeighbourNotice(Level level, BlockPos pos, BlockState state, EnumSet<Direction> notifiedSides, boolean forceRedstoneUpdate) {
        if (level.isClientSide()) {
            return;
        }
        Block block = state.getBlock();
        if (!(block instanceof FireBlock)) {
            return;
        }
        Block belowblock = level.getBlockState(pos.below()).getBlock();
        if (BlockFunctions.isOneOfBlocks(fireblocks, (Block)belowblock).booleanValue()) {
            return;
        }
        ticksleft.put(pos, Util.getFireBurnDurationInTicks());
        ((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(firepositions, (Object)level, k -> new CopyOnWriteArrayList())).add(pos);
    }
}

