/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.automaticdoors_common_forge.events;

import com.natamus.automaticdoors_common_forge.config.ConfigHandler;
import com.natamus.automaticdoors_common_forge.util.Util;
import com.natamus.collective_common_forge.functions.HashMapFunctions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class DoorEvent {
    public static HashMap<Level, List<BlockPos>> toclosedoors = new HashMap();
    public static HashMap<Level, List<BlockPos>> newclosedoors = new HashMap();

    public static void onWorldTick(ServerLevel level) {
        if (ConfigHandler.doorOpenTime == 0) {
            return;
        }
        if (((List)HashMapFunctions.computeIfAbsent(newclosedoors, (Object)level, k -> new ArrayList())).size() > 0) {
            ((List)HashMapFunctions.computeIfAbsent(toclosedoors, (Object)level, k -> new ArrayList())).addAll((Collection)newclosedoors.get(level));
            newclosedoors.get(level).clear();
        }
        ArrayList<BlockPos> closetoremove = new ArrayList<BlockPos>();
        for (BlockPos bp : (List)HashMapFunctions.computeIfAbsent(toclosedoors, (Object)level, k -> new ArrayList())) {
            if (bp == null) {
                closetoremove.add(bp);
                continue;
            }
            BlockState state = level.getBlockState(bp);
            Block block = state.getBlock();
            if (!Util.isDoor(block).booleanValue()) {
                closetoremove.add(bp);
                continue;
            }
            boolean canclose = true;
            for (Entity entity : level.getEntities(null, new AABB((double)(bp.getX() - 2), (double)(bp.getY() - 1), (double)(bp.getZ() - 2), (double)(bp.getX() + 2), (double)(bp.getY() + 1), (double)(bp.getZ() + 2)))) {
                Player player;
                BlockPos ppos;
                if (!(entity instanceof Player) || !(ppos = (player = (Player)entity).blockPosition()).closerThan((Vec3i)bp, 3.0) || ConfigHandler.preventOpeningOnSneak && player.isCrouching()) continue;
                canclose = false;
                break;
            }
            if (!canclose) continue;
            for (BlockPos aroundpos : BlockPos.betweenClosed((int)(bp.getX() - 1), (int)bp.getY(), (int)(bp.getZ() - 1), (int)(bp.getX() + 1), (int)bp.getY(), (int)(bp.getZ() + 1))) {
                BlockState aroundstate = level.getBlockState(aroundpos);
                Block aroundblock = aroundstate.getBlock();
                if (!Util.isDoor(aroundblock).booleanValue()) continue;
                ((DoorBlock)block).setOpen(null, (Level)level, aroundstate, aroundpos, false);
            }
            closetoremove.add(bp);
        }
        if (closetoremove.size() > 0) {
            for (BlockPos tr : closetoremove) {
                toclosedoors.get(level).remove(tr);
            }
        }
    }

    public static void onPlayerTick(ServerLevel level, ServerPlayer player) {
        if (ConfigHandler.doorOpenTime == 0) {
            return;
        }
        if (player.isSpectator()) {
            return;
        }
        if (player.isShiftKeyDown() && ConfigHandler.preventOpeningOnSneak) {
            return;
        }
        BlockPos ppos = player.blockPosition().above().immutable();
        Iterator it1 = BlockPos.betweenClosedStream((int)(ppos.getX() - 1), (int)ppos.getY(), (int)(ppos.getZ() - 1), (int)(ppos.getX() + 1), (int)ppos.getY(), (int)(ppos.getZ() + 1)).iterator();
        while (it1.hasNext()) {
            BlockPos np = (BlockPos)it1.next();
            BlockState state = level.getBlockState(np);
            Block block = state.getBlock();
            if (!Util.isDoor(block).booleanValue() || ((List)HashMapFunctions.computeIfAbsent(toclosedoors, (Object)level, k -> new ArrayList())).contains(np) || ((List)HashMapFunctions.computeIfAbsent(newclosedoors, (Object)level, k -> new ArrayList())).contains(np)) continue;
            ((DoorBlock)block).setOpen(null, (Level)level, state, np, true);
            Util.delayDoorClose((Level)level, np.immutable());
        }
    }
}

