/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.villagerdeathmessages_common_forge.events;

import com.natamus.collective_common_forge.functions.EntityFunctions;
import com.natamus.collective_common_forge.functions.StringFunctions;
import com.natamus.villagerdeathmessages_common_forge.config.ConfigHandler;
import net.minecraft.ChatFormatting;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class VillagerEvent {
    public static void villagerDeath(Level world, Entity entity, DamageSource source) {
        if (world.isClientSide()) {
            return;
        }
        boolean goname = false;
        if (!(entity instanceof Villager)) {
            if (ConfigHandler.mentionModdedVillagers && EntityFunctions.isModdedVillager((Entity)entity)) {
                goname = true;
            }
            if (!goname) {
                return;
            }
        }
        boolean modded = false;
        Object prefix = "";
        if (goname) {
            modded = true;
        } else {
            Villager villager = (Villager)entity;
            VillagerData d = villager.getVillagerData();
            VillagerProfession prof = (VillagerProfession)d.profession().value();
            if (prof != null) {
                String profession = prof.name().getString();
                if (!profession.equals("Villager")) {
                    prefix = "A " + profession + " villager";
                    if (villager.hasCustomName()) {
                        prefix = villager.getName().getString() + " the " + profession;
                    }
                } else {
                    prefix = "A villager";
                    if (villager.hasCustomName()) {
                        prefix = villager.getName().getString();
                    }
                }
            } else {
                modded = true;
            }
        }
        if (modded) {
            prefix = "A special villager";
            if (entity.hasCustomName()) {
                prefix = entity.getName().getString();
            }
        }
        String imsourcename = source.getMsgId();
        String sourcename = "";
        Entity truesource = source.getEntity();
        if (truesource != null) {
            sourcename = truesource.getName().getString();
        }
        if (!sourcename.equals("") && imsourcename.equals("player")) {
            imsourcename = sourcename;
        } else if (imsourcename.contains(".")) {
            imsourcename = imsourcename.split("\\.")[0];
        }
        Object locstring = "";
        if (ConfigHandler.showLocation) {
            Vec3 loc = entity.position();
            String location = "x=" + (int)loc.x + ", y=" + (int)loc.y + ", z=" + (int)loc.z;
            locstring = " at " + location;
        }
        StringFunctions.broadcastMessage((Level)world, (String)((String)prefix + " has died" + (String)locstring + " by " + imsourcename + "."), (ChatFormatting)ChatFormatting.DARK_GREEN);
    }
}

