/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.transcendingtrident_common_neoforge.events;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;

public class TridentEvent {
    public static InteractionResult onItem(Player player, Level world, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (world.isClientSide()) {
            return InteractionResult.PASS;
        }
        ItemStack mainhand = player.getItemInHand(InteractionHand.MAIN_HAND);
        ItemStack offhand = player.getItemInHand(InteractionHand.OFF_HAND);
        if (!mainhand.getItem().equals(Items.TRIDENT)) {
            if (!offhand.getItem().equals(Items.TRIDENT)) {
                return InteractionResult.PASS;
            }
            if (EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)offhand, (LivingEntity)player) <= 0.0f) {
                return InteractionResult.PASS;
            }
        } else if (EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)mainhand, (LivingEntity)player) <= 0.0f) {
            return InteractionResult.PASS;
        }
        if (mainhand.getItem().equals(Items.WATER_BUCKET) ? hand.equals((Object)InteractionHand.MAIN_HAND) : offhand.getItem().equals(Items.WATER_BUCKET) && hand.equals((Object)InteractionHand.OFF_HAND)) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }
}

