/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.betterbeaconplacement_common_forge.events;

import com.natamus.betterbeaconplacement_common_forge.config.ConfigHandler;
import com.natamus.betterbeaconplacement_common_forge.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BeaconEvent {
    public static boolean onBeaconClick(Level world, Player player, InteractionHand hand, BlockPos cpos, BlockHitResult hitVec) {
        if (world.isClientSide()) {
            return true;
        }
        if (!world.getBlockState(cpos).getBlock().equals(Blocks.BEACON)) {
            return true;
        }
        ItemStack handstack = player.getItemInHand(hand);
        if (!Block.byItem((Item)handstack.getItem()).defaultBlockState().is(BlockTags.BEACON_BASE_BLOCKS)) {
            return true;
        }
        boolean set = false;
        while (handstack.getCount() > 0) {
            BlockPos nextpos = Util.getNextLocation(world, cpos);
            if (nextpos == null) {
                return !set;
            }
            Block block = world.getBlockState(nextpos).getBlock();
            if (ConfigHandler.dropReplacedBlockTopBeacon && !block.equals(Blocks.AIR) && !player.isCreative()) {
                ItemEntity ei = new ItemEntity(world, (double)cpos.getX(), (double)(cpos.getY() + 2), (double)cpos.getZ(), new ItemStack((ItemLike)block, 1));
                world.addFreshEntity((Entity)ei);
            }
            world.setBlockAndUpdate(nextpos, Block.byItem((Item)handstack.getItem()).defaultBlockState());
            if (!player.isCreative()) {
                handstack.shrink(1);
            }
            set = true;
            if (player.isCrouching()) continue;
            break;
        }
        return false;
    }

    public static void onBlockBreak(Level world, Player player, BlockPos bpos, BlockState state, BlockEntity blockEntity) {
        if (world.isClientSide()) {
            return;
        }
        if (!ConfigHandler.breakBeaconBaseBlocks) {
            return;
        }
        if (!state.getBlock().equals(Blocks.BEACON)) {
            return;
        }
        Util.processAllBaseBlocks(world, bpos, player.isCreative());
    }
}

