/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.easyelevators_common_forge.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.easyelevators_common_forge.config.ConfigHandler;
import com.natamus.easyelevators_common_forge.data.Variables;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;

public class Util {
    public static final List<Block> elevatorBlocks = new ArrayList<Block>();
    public static final List<Block> elevatorChains = new ArrayList<Block>();

    public static void processConfigBlocks(Level level) {
        if (Variables.processedConfigBlocks) {
            return;
        }
        Variables.processedConfigBlocks = true;
        Registry blockRegistry = level.registryAccess().lookupOrThrow(Registries.BLOCK);
        for (String rawElevatorBlock : ConfigHandler.elevatorBlocks.split(",")) {
            Block elevatorBlock;
            Optional elevatorBlockOptionalReference;
            ResourceLocation rawElevatorBlockRL = ResourceLocation.tryParse((String)rawElevatorBlock.strip());
            if (!blockRegistry.containsKey(rawElevatorBlockRL) || !(elevatorBlockOptionalReference = blockRegistry.get(rawElevatorBlockRL)).isPresent() || elevatorBlocks.contains(elevatorBlock = (Block)((Holder.Reference)elevatorBlockOptionalReference.get()).value())) continue;
            elevatorBlocks.add(elevatorBlock);
        }
        for (String rawElevatorChain : ConfigHandler.elevatorChains.split(",")) {
            Block elevatorChain;
            Optional elevatorChainOptionalReference;
            ResourceLocation rawElevatorChainRL = ResourceLocation.tryParse((String)rawElevatorChain.strip());
            if (!blockRegistry.containsKey(rawElevatorChainRL) || !(elevatorChainOptionalReference = blockRegistry.get(rawElevatorChainRL)).isPresent() || elevatorChains.contains(elevatorChain = (Block)((Holder.Reference)elevatorChainOptionalReference.get()).value())) continue;
            elevatorChains.add(elevatorChain);
        }
    }

    public static boolean isElevatorBlock(Level level, BlockPos blockPos) {
        return Util.isElevatorBlock(level.getBlockState(blockPos).getBlock());
    }

    public static boolean isElevatorBlock(Block block) {
        return elevatorBlocks.contains(block);
    }

    public static boolean isElevatorChain(Level level, BlockPos blockPos) {
        return Util.isElevatorChain(level.getBlockState(blockPos).getBlock());
    }

    public static boolean isElevatorChain(Block block) {
        return elevatorChains.contains(block);
    }

    public static Pair<BlockPos, BlockPos> getElevatorData(Level level, Player player, BlockPos blockPos) {
        Block insideBlock = level.getBlockState(blockPos).getBlock();
        if (!insideBlock.equals(Blocks.AIR) && !Util.isElevatorChain(insideBlock)) {
            return null;
        }
        if (!Util.isElevatorBlock(level, blockPos.below())) {
            return null;
        }
        BlockPos currentElevatorPos = blockPos.below().immutable();
        int elevatorSize = Util.calculateElevatorSize(level, currentElevatorPos);
        if (elevatorSize < ConfigHandler.minimumElevatorSize) {
            return null;
        }
        Object elevatorData = null;
        elevatorData = !ConfigHandler.elevatorMustBeConnectedViaChains ? Util.getChainlessElevatorAboveAndBelow(level, currentElevatorPos) : Util.getChainElevatorAboveAndBelow(level, Util.findChainPositionAbove(level, currentElevatorPos), Util.findChainPositionBelow(level, currentElevatorPos));
        if (elevatorData != null) {
            int belowSize;
            int aboveSize = elevatorData.getFirst() != null ? Util.calculateElevatorSize(level, (BlockPos)elevatorData.getFirst()) : 0;
            int n = belowSize = elevatorData.getSecond() != null ? Util.calculateElevatorSize(level, (BlockPos)elevatorData.getSecond()) : 0;
            if (aboveSize < ConfigHandler.minimumElevatorSize && belowSize < ConfigHandler.minimumElevatorSize) {
                return null;
            }
            elevatorData = Pair.of((Object)(aboveSize < ConfigHandler.minimumElevatorSize ? null : (BlockPos)elevatorData.getFirst()), belowSize < ConfigHandler.minimumElevatorSize ? null : (BlockPos)elevatorData.getSecond());
        }
        return elevatorData;
    }

    private static Pair<BlockPos, BlockPos> getChainElevatorAboveAndBelow(Level level, @Nullable BlockPos aboveChain, @Nullable BlockPos belowChain) {
        return Pair.of((Object)Util.findChainElevator(level, aboveChain, true), (Object)Util.findChainElevator(level, belowChain, false));
    }

    private static Pair<BlockPos, BlockPos> getChainlessElevatorAboveAndBelow(Level level, BlockPos elevatorPos) {
        return Pair.of((Object)Util.findChainlessElevator(level, elevatorPos, true), (Object)Util.findChainlessElevator(level, elevatorPos, false));
    }

    public static Vec3 getFinalElevatorVec(Level level, BlockPos elevatorPos, Vec3 playerVec) {
        double z;
        double x = playerVec.x;
        double y = elevatorPos.getY();
        if (!Util.isElevatorBlock(level, BlockPos.containing((double)x, (double)y, (double)(z = playerVec.z)))) {
            return new Vec3((double)elevatorPos.getX(), y + 1.0, (double)elevatorPos.getZ());
        }
        return new Vec3(x, y + 1.0, z);
    }

    @Nullable
    private static BlockPos findChainPositionAbove(Level level, BlockPos blockPos) {
        return Util.findChainPosition(level, blockPos, 0, 1);
    }

    @Nullable
    private static BlockPos findChainPositionBelow(Level level, BlockPos blockPos) {
        return Util.findChainPosition(level, blockPos, 0, -1);
    }

    @Nullable
    private static BlockPos findChainPosition(Level level, BlockPos blockPos, int ... yOffsets) {
        int size = ConfigHandler.maximumElevatorSize;
        int range = size % 2 == 0 ? size / 2 : (size - 1) / 2;
        for (int yOffset : yOffsets) {
            for (BlockPos aroundPos : BlockPos.betweenClosed((int)(blockPos.getX() - 2), (int)(blockPos.getY() + yOffset), (int)(blockPos.getZ() - 2), (int)(blockPos.getX() + 2), (int)(blockPos.getY() + yOffset), (int)(blockPos.getZ() + 2))) {
                if (!Util.isElevatorChain(level, aroundPos)) continue;
                return aroundPos.immutable();
            }
        }
        return null;
    }

    @Nullable
    private static BlockPos findChainElevator(Level level, @Nullable BlockPos chainPos, boolean searchAbove) {
        BlockPos possibleElevatorPos;
        if (chainPos == null) {
            return null;
        }
        BlockPos currentChainPos = chainPos.immutable();
        while (Util.isElevatorChain(level, searchAbove ? currentChainPos.above() : currentChainPos.below())) {
            currentChainPos = (searchAbove ? currentChainPos.above() : currentChainPos.below()).immutable();
        }
        BlockPos blockPos = possibleElevatorPos = searchAbove ? currentChainPos.above() : currentChainPos.below();
        if (Util.isElevatorBlock(level, possibleElevatorPos)) {
            return possibleElevatorPos.immutable();
        }
        return null;
    }

    @Nullable
    private static BlockPos findChainlessElevator(Level level, BlockPos elevatorPos, boolean searchAbove) {
        BlockPos currentPos = elevatorPos.immutable();
        int direction = searchAbove ? 1 : -1;
        for (int i = 1; i <= ConfigHandler.maximumChainlessElevatorHeight; ++i) {
            BlockPos nextPos = currentPos.offset(0, i * direction, 0);
            if (!Util.isElevatorBlock(level, nextPos)) continue;
            return nextPos.immutable();
        }
        return null;
    }

    public static int calculateElevatorSize(Level level, BlockPos startPos) {
        Block targetBlock = level.getBlockState(startPos).getBlock();
        if (!Util.isElevatorBlock(level, startPos)) {
            return 0;
        }
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> queue = new LinkedList<BlockPos>();
        queue.add(startPos);
        visited.add(startPos);
        while (!queue.isEmpty()) {
            BlockPos current = (BlockPos)queue.poll();
            for (BlockPos neighbor : new BlockPos[]{current.north(), current.south(), current.east(), current.west()}) {
                if (visited.contains(neighbor) || !Util.isElevatorBlock(level, neighbor)) continue;
                visited.add(neighbor);
                queue.add(neighbor);
            }
        }
        return Util.findLargestSquare(visited);
    }

    private static int findLargestSquare(Set<BlockPos> visited) {
        int maxSize = 0;
        for (BlockPos pos : visited) {
            boolean squareFound;
            int size = 1;
            do {
                squareFound = true;
                for (int x = 0; x < size; ++x) {
                    for (int y = 0; y < size; ++y) {
                        BlockPos checkPos = pos.offset(x, 0, y);
                        if (visited.contains(checkPos)) continue;
                        squareFound = false;
                        break;
                    }
                    if (!squareFound) break;
                }
                if (!squareFound) continue;
                maxSize = Math.max(maxSize, size);
                ++size;
            } while (squareFound);
        }
        return maxSize;
    }
}

