/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_neoforge.functions;

import com.natamus.collective_common_neoforge.functions.GearFunctions;
import com.natamus.starterkit_common_neoforge.data.Constants;
import com.natamus.starterkit_common_neoforge.data.ConstantsClient;
import com.natamus.starterkit_common_neoforge.data.VariablesClient;
import com.natamus.starterkit_common_neoforge.functions.StarterGearFunctions;
import com.natamus.starterkit_common_neoforge.inventory.StarterKitInventoryScreen;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.EntityEquipment;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class StarterClientFunctions {
    public static void showInitialChooseKitScreen() {
        StarterClientFunctions.showInitialChooseKitScreen((Player)ConstantsClient.mc.player);
    }

    public static void showInitialChooseKitScreen(Player player) {
        if (!StarterClientFunctions.cacheLocalPlayerEquipment()) {
            Constants.logger.warn("[Starter Kit] Unable to cache the local player's prior equipment.");
            return;
        }
        StarterClientFunctions.removeLocalPlayerEquipment();
        StarterClientFunctions.setCachedStarterKitInventory(player, 0);
        if (VariablesClient.cachedStarterKitInventory == null) {
            Constants.logger.warn("[Starter Kit] Cannot initiate StarterKitInventoryScreen, the cached starter kit inventory is null.");
            return;
        }
        ConstantsClient.mc.setScreen((Screen)new StarterKitInventoryScreen(player));
    }

    public static void cycleChooseKitScreen(Player player, boolean next) {
        if (player == null) {
            Constants.logger.warn("[Starter Kit] Unable to cycle the choose kit screen, player is null.");
            return;
        }
        List<String> activeKitNames = StarterGearFunctions.getActiveKitNames(VariablesClient.cachedStarterGearEntries);
        int kitIndex = 0;
        for (String activeKitName : activeKitNames) {
            if (activeKitName.equals(VariablesClient.cachedStarterKitName)) break;
            ++kitIndex;
        }
        kitIndex = next ? ++kitIndex : --kitIndex;
        if (kitIndex < 0) {
            kitIndex = activeKitNames.size() - 1;
        } else if (kitIndex >= activeKitNames.size()) {
            kitIndex = 0;
        }
        StarterClientFunctions.removeLocalPlayerEquipment();
        StarterClientFunctions.setCachedStarterKitInventory(player, kitIndex);
        if (VariablesClient.cachedStarterKitInventory == null) {
            Constants.logger.warn("[Starter Kit] Cannot cycle StarterKitInventoryScreen, the cached starter kit inventory is null.");
            return;
        }
        ConstantsClient.mc.setScreen((Screen)new StarterKitInventoryScreen(player));
    }

    public static void setCachedStarterKitInventory(Player player, int kitIndex) {
        Inventory inventory = new Inventory(player, new EntityEquipment());
        if (VariablesClient.cachedStarterGearEntries.isEmpty()) {
            Constants.logger.warn("[Starter Kit] Unable to show the choose kit screen, starter gear entries are empty.");
            return;
        }
        if (kitIndex >= VariablesClient.cachedStarterGearEntries.size()) {
            Constants.logger.warn("[Starter Kit] Unable to show the choose kit screen, kit index higher than the cached starter gear entries.");
            return;
        }
        String kitName = StarterGearFunctions.getActiveKitNames(VariablesClient.cachedStarterGearEntries).get(kitIndex);
        String gearString = VariablesClient.cachedStarterGearEntries.get(kitName);
        if (gearString == null) {
            Constants.logger.warn("[Starter Kit] Unable to show the choose kit screen, gearString is null from kit name '{}' and kit index {}.", (Object)kitName, (Object)kitIndex);
            return;
        }
        GearFunctions.setInventoryFromGearString((Level)player.level(), (Inventory)inventory, (String)gearString);
        VariablesClient.cachedStarterKitName = kitName;
        VariablesClient.cachedStarterKitInventory = inventory;
        VariablesClient.cachedStarterKitEffects = GearFunctions.getEffectsFromGearString((Player)player, (String)gearString);
    }

    public static boolean cacheLocalPlayerEquipment() {
        LocalPlayer localPlayer = ConstantsClient.mc.player;
        if (localPlayer == null) {
            return false;
        }
        return StarterClientFunctions.cacheLocalPlayerEquipment((Player)localPlayer);
    }

    public static boolean cacheLocalPlayerEquipment(Player player) {
        VariablesClient.priorPlayerEquipment = new HashMap();
        VariablesClient.priorPlayerHotbar = new ArrayList<ItemStack>();
        player.getInventory().setSelectedSlot(0);
        for (EquipmentSlot equipmentSlot : Constants.equipmentSlots) {
            VariablesClient.priorPlayerEquipment.put(equipmentSlot, player.getItemBySlot(equipmentSlot).copy());
        }
        for (int i = 0; i < 9; ++i) {
            VariablesClient.priorPlayerHotbar.add(player.getInventory().getItem(i).copy());
        }
        return true;
    }

    public static boolean removeLocalPlayerEquipment() {
        LocalPlayer localPlayer = ConstantsClient.mc.player;
        if (localPlayer == null) {
            return false;
        }
        return StarterClientFunctions.removeLocalPlayerEquipment((Player)localPlayer);
    }

    public static boolean removeLocalPlayerEquipment(Player player) {
        ItemStack airStack = new ItemStack((ItemLike)Items.AIR, 1);
        for (EquipmentSlot equipmentSlot : Constants.equipmentSlots) {
            player.setItemSlot(equipmentSlot, airStack.copy());
        }
        for (int i = 0; i < 9; ++i) {
            player.getInventory().setItem(i, airStack.copy());
        }
        return true;
    }

    public static boolean setPriorLocalPlayerEquipment() {
        LocalPlayer localPlayer = ConstantsClient.mc.player;
        if (localPlayer == null) {
            return false;
        }
        return StarterClientFunctions.setPriorLocalPlayerEquipment((Player)localPlayer);
    }

    public static boolean setPriorLocalPlayerEquipment(Player player) {
        if (VariablesClient.priorPlayerEquipment == null || VariablesClient.priorPlayerHotbar == null) {
            return false;
        }
        player.getInventory().setSelectedSlot(0);
        for (EquipmentSlot equipmentSlot : Constants.equipmentSlots) {
            ItemStack slotStack = VariablesClient.priorPlayerEquipment.get(equipmentSlot);
            if (slotStack == null) continue;
            player.setItemSlot(equipmentSlot, slotStack.copy());
        }
        for (int i = 0; i < 9; ++i) {
            player.getInventory().setItem(i, VariablesClient.priorPlayerHotbar.get(i).copy());
        }
        ConstantsClient.mc.options.hideGui = false;
        return true;
    }

    public static void clearStarterKitClientCache() {
        VariablesClient.cachedStarterKitName = "";
        VariablesClient.cachedStarterKitInventory = null;
        VariablesClient.cachedStarterKitEffects = new ArrayList<MobEffectInstance>();
        StarterClientFunctions.clearPriorEquipmentCache();
    }

    public static void clearPriorEquipmentCache() {
        VariablesClient.priorPlayerEquipment = null;
        VariablesClient.priorPlayerHotbar = null;
        ConstantsClient.mc.options.hideGui = false;
    }

    public static void selectFirstSlot() {
        LocalPlayer player = ConstantsClient.mc.player;
        if (player != null) {
            player.getInventory().setSelectedSlot(0);
        }
    }
}

