/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.barebackhorseriding_common_neoforge.events;

import com.natamus.barebackhorseriding_common_neoforge.config.ConfigHandler;
import com.natamus.barebackhorseriding_common_neoforge.util.Util;
import com.natamus.collective_common_neoforge.functions.ItemFunctions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class RidingEvent {
    public static void onPlayerTick(ServerLevel level, ServerPlayer player) {
        boolean wearingLeatherPants;
        if (!player.isPassenger()) {
            return;
        }
        if (player.isCreative()) {
            return;
        }
        Entity vehicleEntity = player.getVehicle();
        if (!(vehicleEntity instanceof AbstractHorse)) {
            return;
        }
        AbstractHorse abstractHorse = (AbstractHorse)vehicleEntity;
        if (!abstractHorse.isTamed()) {
            return;
        }
        if (Util.isActuallyWearingASaddle(abstractHorse)) {
            return;
        }
        ItemStack legsStack = player.getItemBySlot(EquipmentSlot.LEGS);
        Item legsItem = legsStack.getItem();
        boolean bl = wearingLeatherPants = legsStack.is(ItemTags.LEG_ARMOR) && legsStack.isValidRepairItem(Items.LEATHER.getDefaultInstance());
        if (ConfigHandler.shouldReceiveSlownessDuringRidingWithoutSaddle && player.tickCount % 20 == 0) {
            if (ConfigHandler.leatherPantsNegateEffect && wearingLeatherPants) {
                if (ConfigHandler.leatherPantsLoseDurabilityOnNegation) {
                    ItemFunctions.itemHurtBreakAndEvent((ItemStack)player.getItemBySlot(EquipmentSlot.LEGS), (ServerPlayer)player, null, (int)1);
                }
                return;
            }
            Util.giveSlowness((Player)player);
        }
        if (ConfigHandler.shouldDamageDuringRidingWithoutSaddle && player.tickCount % ConfigHandler.ticksBetweenDamage == 0) {
            if (ConfigHandler.leatherPantsNegateEffect && wearingLeatherPants) {
                if (ConfigHandler.leatherPantsLoseDurabilityOnNegation) {
                    ItemFunctions.itemHurtBreakAndEvent((ItemStack)player.getItemBySlot(EquipmentSlot.LEGS), (ServerPlayer)player, null, (int)1);
                }
                return;
            }
            Util.damagePlayer((Player)player, ConfigHandler.halfHeartDamageAmount);
        }
    }
}

