/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.betterspawnercontrol.forge.events;

import com.natamus.betterspawnercontrol_common_forge.events.MobSpawnerEvent;
import com.natamus.collective_common_forge.functions.WorldFunctions;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class ForgeMobSpawnerEvent {
    public static void registerEventsInBus() {
        MobSpawnEvent.FinalizeSpawn.BUS.addListener(ForgeMobSpawnerEvent::onMobSpawn);
    }

    @SubscribeEvent
    public static boolean onMobSpawn(MobSpawnEvent.FinalizeSpawn e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return false;
        }
        BaseSpawner msbl = e.getSpawner();
        if (msbl != null) {
            BlockEntity spawnerEntity = msbl.getSpawnerBlockEntity();
            if (spawnerEntity == null) {
                return false;
            }
            BlockPos spawnerPos = spawnerEntity.getBlockPos();
            if (!MobSpawnerEvent.onMobSpawn(e.getEntity(), (ServerLevel)level, spawnerPos, null)) {
                e.setSpawnCancelled(true);
                return true;
            }
        }
        return false;
    }
}

