/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.biggerspongeabsorptionradius_common_forge.mixin;

import com.google.common.collect.Lists;
import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.SpongeBlock;
import net.minecraft.world.level.block.WetSpongeBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.MapColor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={SpongeBlock.class}, priority=1001)
public class SpongeBlockMixin
extends Block {
    @Unique
    private static final List<MapColor> spongematerials = Arrays.asList(MapColor.COLOR_YELLOW);

    public SpongeBlockMixin(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
    }

    @Inject(method={"removeWaterBreadthFirstSearch(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;)Z"}, at={@At(value="HEAD")}, cancellable=true)
    private void removeWaterBreadthFirstSearch(Level level, BlockPos blockPos, CallbackInfoReturnable<Boolean> cir) {
        List spongePositions = BlockPosFunctions.getBlocksNextToEachOtherMaterial((Level)level, (BlockPos)blockPos, spongematerials);
        int spongeCount = spongePositions.size();
        int absorbDistance = 6 * spongeCount;
        int maxCount = 64 * spongeCount;
        LinkedList queue = Lists.newLinkedList();
        queue.add(new Tuple((Object)blockPos, (Object)0));
        int i = 0;
        while (!queue.isEmpty()) {
            Tuple tuple = (Tuple)queue.poll();
            BlockPos blockpos = (BlockPos)tuple.getA();
            int j = (Integer)tuple.getB();
            for (Direction direction : Direction.values()) {
                BlockPos blockpos1 = blockpos.relative(direction);
                BlockState blockstate = level.getBlockState(blockpos1);
                Block block = blockstate.getBlock();
                FluidState ifluidstate = level.getFluidState(blockpos1);
                MapColor material = blockstate.getMapColor((BlockGetter)level, blockpos1);
                if (!ifluidstate.is(FluidTags.WATER) && !(block instanceof SpongeBlock) && !(block instanceof WetSpongeBlock)) continue;
                if (blockstate.getBlock() instanceof BucketPickup && !((BucketPickup)blockstate.getBlock()).pickupBlock(null, (LevelAccessor)level, blockpos1, blockstate).isEmpty()) {
                    ++i;
                    if (j >= absorbDistance) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (block instanceof LiquidBlock) {
                    level.setBlock(blockpos1, Blocks.AIR.defaultBlockState(), 3);
                    ++i;
                    if (j >= absorbDistance) continue;
                    queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
                    continue;
                }
                if (!blockstate.is(Blocks.KELP) && !blockstate.is(Blocks.KELP_PLANT) && !blockstate.is(Blocks.SEAGRASS) && !blockstate.is(Blocks.TALL_SEAGRASS)) continue;
                BlockEntity tileentity = blockstate.hasBlockEntity() ? level.getBlockEntity(blockpos1) : null;
                SpongeBlockMixin.dropResources((BlockState)blockstate, (LevelAccessor)level, (BlockPos)blockpos1, (BlockEntity)tileentity);
                level.setBlock(blockpos1, Blocks.AIR.defaultBlockState(), 3);
                ++i;
                if (j >= absorbDistance) continue;
                queue.add(new Tuple((Object)blockpos1, (Object)(j + 1)));
            }
            if (i <= maxCount) continue;
            break;
        }
        if (i > 0) {
            for (BlockPos spongepos : spongePositions) {
                Block block = level.getBlockState(spongepos).getBlock();
                if (!(block instanceof SpongeBlock) && !(block instanceof WetSpongeBlock)) continue;
                level.setBlockAndUpdate(spongepos, Blocks.WET_SPONGE.defaultBlockState());
            }
            cir.setReturnValue((Object)true);
        }
        cir.setReturnValue((Object)false);
    }
}

