/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.flowermimics_common_neoforge.data;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.DynamicOps;
import com.natamus.collective_common_neoforge.functions.DataFunctions;
import com.natamus.collective_common_neoforge.functions.ItemFunctions;
import com.natamus.flowermimics_common_neoforge.data.Variables;
import com.natamus.flowermimics_common_neoforge.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class MimicData {
    public static List<Block> allFlowers = new ArrayList<Block>();
    private static HashMap<Block, EntityType<?>> flowerToMimic = new HashMap();
    private static HashMap<Block, ItemStack> flowerMimicDrops = new HashMap();
    private static final HashMap<Block, EntityType<?>> defaultFlowerToMimic = new HashMap();
    private static final HashMap<Block, ItemStack> defaultFlowerMimicDrops = new HashMap();
    private static final String dirPath = DataFunctions.getConfigDirectory() + File.separator + "flowermimics";
    private static final File dir = new File(dirPath);
    private static final File flowerMimicsFile = new File(dirPath + File.separator + "flower_mimics.txt");
    private static final File flowerItemDropsFile = new File(dirPath + File.separator + "flower_item_drops.txt");

    public static EntityType<?> getMimicFromFlower(Block block) {
        if (!flowerToMimic.containsKey(block)) {
            return null;
        }
        return flowerToMimic.get(block);
    }

    public static ItemStack getFlowerMimicDrop(Block block) {
        if (!flowerMimicDrops.containsKey(block)) {
            return new ItemStack((ItemLike)Blocks.AIR, 1);
        }
        return flowerMimicDrops.get(block).copy();
    }

    public static void loadDefaultMimicData() {
        defaultFlowerToMimic.put(Blocks.ALLIUM, EntityType.ILLUSIONER);
        defaultFlowerToMimic.put(Blocks.AZURE_BLUET, EntityType.WANDERING_TRADER);
        defaultFlowerToMimic.put(Blocks.BLUE_ORCHID, EntityType.DROWNED);
        defaultFlowerToMimic.put(Blocks.CORNFLOWER, EntityType.PHANTOM);
        defaultFlowerToMimic.put(Blocks.DANDELION, EntityType.ZOMBIE_VILLAGER);
        defaultFlowerToMimic.put(Blocks.LILAC, EntityType.SHULKER);
        defaultFlowerToMimic.put(Blocks.LILY_OF_THE_VALLEY, EntityType.GHAST);
        defaultFlowerToMimic.put(Blocks.ORANGE_TULIP, EntityType.SNOW_GOLEM);
        defaultFlowerToMimic.put(Blocks.OXEYE_DAISY, EntityType.STRAY);
        defaultFlowerToMimic.put(Blocks.PEONY, EntityType.VINDICATOR);
        defaultFlowerToMimic.put(Blocks.PINK_TULIP, EntityType.SLIME);
        defaultFlowerToMimic.put(Blocks.POPPY, EntityType.CAVE_SPIDER);
        defaultFlowerToMimic.put(Blocks.RED_TULIP, EntityType.SPIDER);
        defaultFlowerToMimic.put(Blocks.ROSE_BUSH, EntityType.MAGMA_CUBE);
        defaultFlowerToMimic.put(Blocks.SUNFLOWER, EntityType.CREEPER);
        defaultFlowerToMimic.put(Blocks.TORCHFLOWER, EntityType.BLAZE);
        defaultFlowerToMimic.put(Blocks.WHITE_TULIP, EntityType.SKELETON);
        defaultFlowerToMimic.put(Blocks.WITHER_ROSE, EntityType.WITHER_SKELETON);
    }

    public static void loadDefaultFlowerMimicDrops() {
        defaultFlowerMimicDrops.put(Blocks.ALLIUM, new ItemStack((ItemLike)Items.CHORUS_FRUIT, 2));
        defaultFlowerMimicDrops.put(Blocks.AZURE_BLUET, new ItemStack((ItemLike)Items.EMERALD, 1));
        defaultFlowerMimicDrops.put(Blocks.BLUE_ORCHID, new ItemStack((ItemLike)Items.SOUL_LANTERN, 1));
        defaultFlowerMimicDrops.put(Blocks.CORNFLOWER, new ItemStack((ItemLike)Items.FEATHER, 32));
        defaultFlowerMimicDrops.put(Blocks.DANDELION, new ItemStack((ItemLike)Items.GOLDEN_APPLE, 1));
        defaultFlowerMimicDrops.put(Blocks.LILAC, new ItemStack((ItemLike)Items.END_CRYSTAL, 1));
        defaultFlowerMimicDrops.put(Blocks.LILY_OF_THE_VALLEY, new ItemStack((ItemLike)Items.IRON_INGOT, 8));
        defaultFlowerMimicDrops.put(Blocks.ORANGE_TULIP, new ItemStack((ItemLike)Items.POWDER_SNOW_BUCKET, 1));
        defaultFlowerMimicDrops.put(Blocks.OXEYE_DAISY, new ItemStack((ItemLike)Items.SPECTRAL_ARROW, 16));
        defaultFlowerMimicDrops.put(Blocks.PEONY, new ItemStack((ItemLike)Items.CAULDRON, 1));
        defaultFlowerMimicDrops.put(Blocks.PINK_TULIP, new ItemStack((ItemLike)Items.POISONOUS_POTATO, 3));
        defaultFlowerMimicDrops.put(Blocks.POPPY, new ItemStack((ItemLike)Items.COBWEB, 6));
        defaultFlowerMimicDrops.put(Blocks.RED_TULIP, new ItemStack((ItemLike)Items.RABBIT_FOOT, 1));
        defaultFlowerMimicDrops.put(Blocks.ROSE_BUSH, new ItemStack((ItemLike)Items.MAGMA_BLOCK, 14));
        defaultFlowerMimicDrops.put(Blocks.SUNFLOWER, new ItemStack((ItemLike)Items.TNT, 5));
        defaultFlowerMimicDrops.put(Blocks.TORCHFLOWER, new ItemStack((ItemLike)Items.FIRE_CHARGE, 7));
        defaultFlowerMimicDrops.put(Blocks.WHITE_TULIP, new ItemStack((ItemLike)Items.CAKE, 1));
        defaultFlowerMimicDrops.put(Blocks.WITHER_ROSE, new ItemStack((ItemLike)Items.NETHERITE_SCRAP, 2));
    }

    public static EntityType<?> getDefaultMimicFromFlower(Block block) {
        if (!defaultFlowerToMimic.containsKey(block)) {
            return null;
        }
        return defaultFlowerToMimic.get(block);
    }

    public static void attemptMimicConfigProcessing(Level level) {
        if (!Variables.processedMimicConfig) {
            try {
                MimicData.setMimicConfig(level);
                Variables.processedMimicConfig = true;
            }
            catch (Exception ex) {
                System.out.println("[Flower Mimics] Error: Unable to generate flower mimic config list.");
            }
        }
    }

    public static void setMimicConfig(Level level) throws IOException {
        Registry blockRegistry = level.registryAccess().lookupOrThrow(Registries.BLOCK);
        Registry entityTypeRegistry = level.registryAccess().lookupOrThrow(Registries.ENTITY_TYPE);
        allFlowers = new ArrayList<Block>();
        PrintWriter flowerMimicsWriter = null;
        PrintWriter flowerItemDropsWriter = null;
        if (!(dir.isDirectory() && flowerMimicsFile.isFile() && flowerItemDropsFile.isFile())) {
            if (dir.mkdirs()) {
                flowerMimicsWriter = new PrintWriter(dirPath + File.separator + "flower_mimics.txt", StandardCharsets.UTF_8);
                flowerItemDropsWriter = new PrintWriter(dirPath + File.separator + "flower_item_drops.txt", StandardCharsets.UTF_8);
            }
            flowerToMimic = new HashMap();
            flowerMimicDrops = new HashMap();
        } else {
            String flowerMimicsContent = new String(Files.readAllBytes(Paths.get(dirPath + File.separator + "flower_mimics.txt", new String[0])));
            for (String line : flowerMimicsContent.split("\n")) {
                if (line.strip().equals("")) continue;
                String[] lspl = line.split(";");
                if (lspl.length < 2) {
                    Variables.logger.warn("[Flower Mimics] Unable to parse flower_mimics.txt line: " + line);
                    continue;
                }
                String flowerBlockRlString = lspl[0].strip();
                ResourceLocation flowerBlockResourceLocation = ResourceLocation.parse((String)flowerBlockRlString);
                Optional flowerBlockOptionalReference = level.registryAccess().lookupOrThrow(BuiltInRegistries.BLOCK.key()).get(flowerBlockResourceLocation);
                if (flowerBlockOptionalReference.isEmpty()) {
                    Variables.logger.warn("[Flower Mimics] 1. Unable to find flower '" + flowerBlockRlString + "' in registry.");
                    continue;
                }
                Block flowerBlock = (Block)((Holder.Reference)flowerBlockOptionalReference.get()).value();
                String mimicEntityTypeString = lspl[1].strip();
                if (mimicEntityTypeString.equals("")) continue;
                ResourceLocation mimicEntityTypeResourceLocation = ResourceLocation.parse((String)mimicEntityTypeString);
                Optional mimicEntityTypeOptionalReference = level.registryAccess().lookupOrThrow(BuiltInRegistries.ENTITY_TYPE.key()).get(mimicEntityTypeResourceLocation);
                if (mimicEntityTypeOptionalReference.isEmpty()) {
                    Variables.logger.warn("[Flower Mimics] Unable to find entity type '" + mimicEntityTypeString + "' in registry.");
                    continue;
                }
                flowerToMimic.put(flowerBlock, (EntityType)((Holder.Reference)mimicEntityTypeOptionalReference.get()).value());
            }
            String flowerItemDropsContent = new String(Files.readAllBytes(Paths.get(dirPath + File.separator + "flower_item_drops.txt", new String[0])));
            for (String line : flowerItemDropsContent.split("\n")) {
                if (line.strip().equals("")) continue;
                String[] lspl = line.split(";");
                if (lspl.length < 2) {
                    Variables.logger.warn("[Flower Mimics] Unable to parse flower_item_drops.txt line: " + line);
                    continue;
                }
                String flowerBlockRlString = lspl[0].strip();
                ResourceLocation flowerBlockResourceLocation = ResourceLocation.parse((String)flowerBlockRlString);
                Optional flowerBlockOptionalReference = level.registryAccess().lookupOrThrow(BuiltInRegistries.BLOCK.key()).get(flowerBlockResourceLocation);
                if (flowerBlockOptionalReference.isEmpty()) {
                    Variables.logger.warn("[Flower Mimics] 2. Unable to find flower '" + flowerBlockRlString + "' in registry.");
                    continue;
                }
                String itemStackNBTString = lspl[1].strip();
                try {
                    CompoundTag newNBT = TagParser.parseCompoundFully((String)itemStackNBTString);
                    ItemStack itemStack = ItemStack.CODEC.parse((DynamicOps)level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)newNBT).result().orElse(ItemStack.EMPTY);
                    if (itemStack.isEmpty()) continue;
                    flowerMimicDrops.put((Block)((Holder.Reference)flowerBlockOptionalReference.get()).value(), itemStack.copy());
                }
                catch (CommandSyntaxException ex) {
                    Variables.logger.warn("[Flower Mimics] Unable to find itemstack from NBT: " + itemStackNBTString);
                }
            }
        }
        ArrayList<String> flowerRLStrings = new ArrayList<String>();
        HashMap<String, Block> flowerBlocks = new HashMap<String, Block>();
        for (Block block : blockRegistry) {
            ResourceLocation rl;
            if (!Util.isFlower(block) || (rl = blockRegistry.getKey((Object)block)) == null) continue;
            String flowerRLString = rl.toString();
            flowerRLStrings.add(flowerRLString);
            flowerBlocks.put(flowerRLString, block);
        }
        Collections.sort(flowerRLStrings);
        for (String flowerRLString : flowerRLStrings) {
            Block flowerBlock = (Block)flowerBlocks.get(flowerRLString);
            allFlowers.add(flowerBlock);
            if (flowerMimicsWriter != null) {
                ResourceLocation mimicRl;
                String mimicRlString = " ";
                EntityType<?> defaultMimic = MimicData.getDefaultMimicFromFlower(flowerBlock);
                if (defaultMimic != null && (mimicRl = entityTypeRegistry.getKey(defaultMimic)) != null) {
                    mimicRlString = mimicRl.toString();
                }
                flowerMimicsWriter.println(flowerRLString + " ; " + mimicRlString);
                flowerToMimic.put(flowerBlock, defaultMimic);
            }
            if (flowerItemDropsWriter == null) continue;
            ItemStack defaultFlowerMimicDropStack = new ItemStack((ItemLike)Blocks.AIR, 1);
            if (defaultFlowerMimicDrops.containsKey(flowerBlock)) {
                defaultFlowerMimicDropStack = defaultFlowerMimicDrops.get(flowerBlock).copy();
            }
            String nBTString = ItemFunctions.getNBTStringFromItemStack((Level)level, (ItemStack)defaultFlowerMimicDropStack);
            flowerItemDropsWriter.println(flowerRLString + " ; " + nBTString);
            flowerMimicDrops.put(flowerBlock, defaultFlowerMimicDropStack.copy());
        }
        if (flowerMimicsWriter != null) {
            flowerMimicsWriter.close();
        }
        if (flowerItemDropsWriter != null) {
            flowerItemDropsWriter.close();
        }
    }
}

