/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.flowermimics_common_fabric.util;

import com.natamus.collective_common_fabric.functions.HashMapFunctions;
import com.natamus.flowermimics_common_fabric.config.ConfigHandler;
import com.natamus.flowermimics_common_fabric.data.MimicData;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.WeakHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1538;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2356;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2521;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3730;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_7923;

public class Util {
    public static final WeakHashMap<class_1937, List<class_2338>> flowersChecked = new WeakHashMap();
    public static final WeakHashMap<class_1937, List<class_2338>> flowerIsAMimic = new WeakHashMap();

    public static boolean isFlowerAMimic(class_1937 level, class_2338 blockPos) {
        boolean isMimic;
        if (((List)HashMapFunctions.computeIfAbsent(flowersChecked, (Object)level, k -> new ArrayList())).contains(blockPos)) {
            return false;
        }
        if (((List)HashMapFunctions.computeIfAbsent(flowerIsAMimic, (Object)level, k -> new ArrayList())).contains(blockPos)) {
            return true;
        }
        flowersChecked.get(level).add(blockPos);
        boolean bl = isMimic = Math.random() <= ConfigHandler.flowerIsMimicChance;
        if (isMimic) {
            flowerIsAMimic.get(level).add(blockPos);
        }
        return isMimic;
    }

    public static boolean isFlower(class_2248 block) {
        return block instanceof class_2356 || block instanceof class_2521;
    }

    public static void transformFlower(class_1937 level, class_1657 player, class_2338 flowerPos, class_2248 flowerBlock) {
        if (!flowerIsAMimic.get(level).contains(flowerPos)) {
            return;
        }
        class_1299<?> mimicEntityType = MimicData.getMimicFromFlower(flowerBlock);
        if (mimicEntityType == null) {
            flowerIsAMimic.get(level).remove(flowerPos);
            return;
        }
        class_1297 mimic = mimicEntityType.method_5883(level, class_3730.field_16467);
        if (mimic == null) {
            return;
        }
        mimic.method_5814((double)flowerPos.method_10263() + 0.5, (double)flowerPos.method_10264(), (double)flowerPos.method_10260() + 0.5);
        mimic.method_5780("flowermimics.mimic");
        class_5250 mimicNameComponent = flowerBlock.method_9518().method_27693(" Mimic");
        mimic.method_5665((class_2561)mimicNameComponent.method_27692(class_124.field_1065));
        if (ConfigHandler.removeFlowerBlockOnMimicSpawn) {
            class_2960 resourceLocation = level.method_30349().method_30530(class_7923.field_41175.method_46765()).method_10221((Object)flowerBlock);
            mimic.method_5780("flowermimics.flower." + String.valueOf(resourceLocation));
            mimic.method_5780("flowermimics.location." + flowerPos.method_10263() + "," + flowerPos.method_10264() + "," + flowerPos.method_10260());
        }
        if (ConfigHandler.removeFlowerBlockOnMimicSpawn) {
            if (flowerBlock instanceof class_2521) {
                level.method_8652(flowerPos.method_10062().method_10084(), class_2246.field_10124.method_9564(), 3);
            }
            level.method_8652(flowerPos, class_2246.field_10124.method_9564(), 3);
        }
        if (ConfigHandler.showLightningOnMimicSpawn) {
            Util.spawnLightning(level, flowerPos, player);
        }
        level.method_8649(mimic);
    }

    public static void dropMimicItems(class_1937 level, class_243 mimicVec, String flowerTag) {
        Util.dropMimicItems(level, mimicVec, flowerTag, false);
    }

    public static void dropMimicItems(class_1937 level, class_243 mimicVec, String flowerTag, boolean flowerOnly) {
        String flowerBlockRlString = flowerTag.split(".flower.")[1];
        class_2960 flowerBlockResourceLocation = class_2960.method_60654((String)flowerBlockRlString);
        Optional flowerBlockOptionalReference = level.method_30349().method_30530(class_7923.field_41175.method_46765()).method_10223(flowerBlockResourceLocation);
        if (flowerBlockOptionalReference.isPresent()) {
            class_1799 mimicItemDropStack;
            class_2248 flowerBlock = (class_2248)((class_6880.class_6883)flowerBlockOptionalReference.get()).comp_349();
            if (ConfigHandler.dropExtraItemsOnMimicDeath && !flowerOnly && !(mimicItemDropStack = MimicData.getFlowerMimicDrop(flowerBlock)).method_7909().equals(class_1802.field_8162)) {
                level.method_8649((class_1297)new class_1542(level, mimicVec.field_1352, mimicVec.field_1351 + 1.0, mimicVec.field_1350, mimicItemDropStack));
            }
            if (ConfigHandler.dropFlowerItemOnMimicDeath) {
                class_1799 flowerItemStack = new class_1799((class_1935)flowerBlock, 1);
                level.method_8649((class_1297)new class_1542(level, mimicVec.field_1352, mimicVec.field_1351 + 1.0, mimicVec.field_1350, flowerItemStack));
            }
        }
    }

    public static void placeFlowerBlockOnMimicDeath(class_1937 level, class_243 mimicVec, String flowerTag, String locationTag) {
        class_2338 mimicPos = class_2338.method_49638((class_2374)mimicVec);
        String flowerBlockRlString = flowerTag.split(".flower.")[1];
        class_2960 flowerBlockResourceLocation = class_2960.method_60654((String)flowerBlockRlString);
        Optional flowerBlockOptionalReference = level.method_30349().method_30530(class_7923.field_41175.method_46765()).method_10223(flowerBlockResourceLocation);
        boolean flowerPlaced = false;
        if (flowerBlockOptionalReference.isPresent()) {
            class_2248 flowerBlock = (class_2248)((class_6880.class_6883)flowerBlockOptionalReference.get()).comp_349();
            if (ConfigHandler.placeFlowerBlockWhereMimicDies && level.method_8320(mimicPos).method_26204().equals(class_2246.field_10124)) {
                flowersChecked.get(level).add(mimicPos.method_10062());
                flowerIsAMimic.get(level).remove(mimicPos);
                class_2680 flowerBlockState = flowerBlock.method_9564();
                if (flowerBlock instanceof class_2521) {
                    class_2521.method_10021((class_1936)level, (class_2680)flowerBlockState, (class_2338)mimicPos, (int)3);
                } else {
                    level.method_8652(mimicPos, flowerBlockState, 3);
                }
                if (ConfigHandler.showLightningOnFlowerBlockReturn) {
                    Util.spawnLightning(level, mimicPos, null);
                }
                flowerPlaced = true;
            }
            if (ConfigHandler.replaceOriginalFlowerBlockOnMimicDeath && !locationTag.equals("")) {
                String rawCoordinates = locationTag.split(".location.")[1];
                String[] cSpl = rawCoordinates.split(",");
                try {
                    class_2338 mimicSpawnBlockPos = new class_2338(Integer.parseInt(cSpl[0]), Integer.parseInt(cSpl[1]), Integer.parseInt(cSpl[2]));
                    if (level.method_8320(mimicSpawnBlockPos).method_26204().equals(class_2246.field_10124)) {
                        flowersChecked.get(level).add(mimicSpawnBlockPos.method_10062());
                        flowerIsAMimic.get(level).remove(mimicSpawnBlockPos);
                        class_2680 flowerBlockState = flowerBlock.method_9564();
                        if (flowerBlock instanceof class_2521) {
                            class_2521.method_10021((class_1936)level, (class_2680)flowerBlockState, (class_2338)mimicSpawnBlockPos, (int)3);
                        } else {
                            level.method_8652(mimicSpawnBlockPos, flowerBlockState, 3);
                        }
                        if (ConfigHandler.showLightningOnFlowerBlockReturn) {
                            Util.spawnLightning(level, mimicSpawnBlockPos, null);
                        }
                        flowerPlaced = true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (!flowerPlaced) {
            Util.dropMimicItems(level, mimicVec, flowerTag, true);
        }
    }

    public static void spawnLightning(class_1937 level, class_2338 pos, class_1657 player) {
        class_1538 lightningbolt = (class_1538)class_1299.field_6112.method_5883(level, class_3730.field_16467);
        if (lightningbolt == null) {
            return;
        }
        lightningbolt.method_33574(class_243.method_24955((class_2382)pos));
        lightningbolt.method_5752().add("visualonly");
        level.method_8649((class_1297)lightningbolt);
        if (player != null) {
            player.method_5783(class_3417.field_14865, 5.0f, 1.0f);
        }
    }

    public static void resetFlowerMimics(class_1937 level) {
        flowersChecked.put(level, new ArrayList());
        flowerIsAMimic.put(level, new ArrayList());
    }
}

