/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.flowermimics.neoforge.events;

import com.natamus.collective_common_neoforge.functions.WorldFunctions;
import com.natamus.flowermimics_common_neoforge.data.MimicData;
import com.natamus.flowermimics_common_neoforge.events.MimicEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.LevelEvent;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public class NeoForgeMimicEvent {
    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        MimicData.attemptMimicConfigProcessing(level);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre e) {
        Player player = e.getEntity();
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        MimicEvent.onPlayerTick((ServerLevel)level, (ServerPlayer)player);
    }

    @SubscribeEvent
    public static void mobItemDrop(LivingDropsEvent e) {
        LivingEntity entity = e.getEntity();
        MimicEvent.mobItemDrop(entity.level(), (Entity)entity, e.getSource());
    }

    @SubscribeEvent
    public static void onWorldTick(LevelTickEvent.Pre e) {
        Level level = e.getLevel();
        if (level.isClientSide()) {
            return;
        }
        MimicEvent.onLevelTick((ServerLevel)level);
    }

    @SubscribeEvent
    public static void onNeighbourNotice(BlockEvent.NeighborNotifyEvent e) {
        Level level = WorldFunctions.getWorldIfInstanceOfAndNotRemote((LevelAccessor)e.getLevel());
        if (level == null) {
            return;
        }
        MimicEvent.onNeighbourNotice(level, e.getPos(), e.getState(), e.getNotifiedSides(), e.getForceRedstoneUpdate());
    }
}

