/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_neoforge.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.functions.ItemFunctions;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Conversations;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Manage;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Summon;
import com.natamus.pumpkillagersquest_common_neoforge.util.Data;
import com.natamus.pumpkillagersquest_common_neoforge.util.Util;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Scheduler {
    public static void scheduleCharacterMessage(Level level, Villager character, Pair<Player, MutableComponent> messagePair, int msDelay) {
        Scheduler.scheduleCharacterMessage(level, character, messagePair, msDelay, null, "");
    }

    public static void scheduleCharacterMessage(Level level, Villager character, Pair<Player, MutableComponent> messagePair, int msDelay, ItemStack itemStack, String itemStackBehaviour) {
        new Thread(() -> {
            try {
                Thread.sleep(msDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            level.getServer().execute(() -> {
                boolean shouldSendMessage = true;
                Vec3 characterVec = null;
                if (character != null) {
                    if (!character.isRemoved()) {
                        Set tags = character.getTags();
                        if (!tags.contains("pumpkillagersquest.iskilled") && !tags.contains("pumpkillagersquest.preventactions")) {
                            characterVec = character.position();
                            if (Util.isPumpkillager((Entity)character) && !tags.contains("pumpkillagersquest.removed") && !tags.contains("pumpkillagersquest.beingyeeted") && !characterVec.equals((Object)Data.pumpkillagerPositions.get(character))) {
                                Manage.pumpkillagerMovedWrongly(level, character, (Player)messagePair.getFirst());
                                return;
                            }
                        } else {
                            shouldSendMessage = false;
                        }
                    } else {
                        shouldSendMessage = false;
                    }
                }
                if (shouldSendMessage) {
                    Data.messagesToSend.get(level).add(messagePair);
                }
                if (itemStack != null) {
                    switch (itemStackBehaviour) {
                        case "hold": {
                            if (character == null) break;
                            character.setItemInHand(InteractionHand.MAIN_HAND, itemStack);
                            break;
                        }
                        case "give": {
                            Player player = (Player)messagePair.getFirst();
                            int amount = itemStack.getCount();
                            Object itemName = amount + " " + ItemFunctions.itemToReadableString((Item)itemStack.getItem());
                            if (amount == 1 && itemStack.has(DataComponents.CUSTOM_NAME)) {
                                itemName = itemStack.getHoverName().getString();
                            }
                            Data.messagesToSend.get(level).add(Conversations.createMessagePair(player, Component.translatable((String)("You have been given " + (String)itemName + ".")).withStyle(ChatFormatting.GRAY)));
                            ItemFunctions.giveOrDropItemStack((Player)((Player)messagePair.getFirst()), (ItemStack)itemStack);
                            break;
                        }
                        case "wear": {
                            if (character == null) break;
                            if (((MutableComponent)messagePair.getSecond()).getString().contains("freed me from these shackles")) {
                                character.setVillagerData(character.getVillagerData().withType((HolderGetter.Provider)level.registryAccess(), VillagerType.SNOW).withProfession((HolderGetter.Provider)level.registryAccess(), VillagerProfession.WEAPONSMITH));
                                character.setCustomName(null);
                                ItemStack offhandStack = character.getOffhandItem();
                                if (offhandStack.getItem().equals(Items.BARRIER)) {
                                    offhandStack.setCount(3);
                                }
                            }
                            character.setItemSlot(EquipmentSlot.HEAD, itemStack);
                            break;
                        }
                        case "drop": {
                            if (characterVec == null) break;
                            ItemEntity ie = new ItemEntity(level, characterVec.x, characterVec.y + 1.0, characterVec.z, itemStack);
                            level.addFreshEntity((Entity)ie);
                            if (!itemStack.getItem().equals(Items.PAPER)) break;
                            Player player = (Player)messagePair.getFirst();
                            player.getTags().add("pumpkillagersquest.unleashed");
                        }
                    }
                }
            });
        }).start();
    }

    public static void scheduleCharacterLeave(Level level, Villager character, int msDelay) {
        new Thread(() -> {
            try {
                Thread.sleep(msDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            character.getTags().remove("pumpkillagersquest.persistent");
            character.getTags().add("pumpkillagersquest.isleaving");
            Manage.initiateCharacterLeave(level, character);
        }).start();
    }

    public static void scheduleMinionSummoning(Level level, Villager pumpkillager, Player targetPlayer, int summonId, int msDelay) {
        if (level.isClientSide()) {
            return;
        }
        new Thread(() -> {
            try {
                Thread.sleep(msDelay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            level.getServer().execute(() -> Summon.summonFinalBossMinions(level, pumpkillager, targetPlayer, summonId));
        }).start();
    }

    public static void scheduleFireExtuingish(Level level, BlockPos firePos, LivingEntity livingEntityOnFire, boolean healTarget) {
        Scheduler.scheduleFireExtuingish(level, firePos, livingEntityOnFire, healTarget, 0);
    }

    public static void scheduleFireExtuingish(Level level, BlockPos firePos, LivingEntity livingEntityOnFire, boolean healTarget, int loopCount) {
        new Thread(() -> {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            level.getServer().execute(() -> {
                for (BlockPos apos : BlockPos.betweenClosed((int)(firePos.getX() - 1), (int)(firePos.getY() - 1), (int)(firePos.getZ() - 1), (int)(firePos.getX() + 1), (int)(firePos.getY() + 1), (int)(firePos.getZ() + 1))) {
                    if (!level.getBlockState(apos).getBlock().equals(Blocks.FIRE)) continue;
                    level.setBlock(apos, Blocks.AIR.defaultBlockState(), 3);
                }
                if (healTarget) {
                    Vec3 vec = livingEntityOnFire.position();
                    for (Entity ea : level.getEntities(null, new AABB(vec.x - 3.0, vec.y - 3.0, vec.z - 3.0, vec.x + 3.0, vec.y + 3.0, vec.z + 3.0))) {
                        LivingEntity lea;
                        if (!(ea instanceof LivingEntity) || !(lea = (LivingEntity)ea).isOnFire()) continue;
                        lea.clearFire();
                        lea.setHealth(lea.getMaxHealth());
                    }
                }
                if (loopCount < 4) {
                    Scheduler.scheduleFireExtuingish(level, firePos, livingEntityOnFire, healTarget, loopCount + 1);
                }
            });
        }).start();
    }
}

