/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_neoforge.util;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.natamus.pumpkillagersquest_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class Data {
    public static WeakHashMap<Level, CopyOnWriteArrayList<Villager>> allPumpkillagers = new WeakHashMap();
    public static WeakHashMap<Level, CopyOnWriteArrayList<Villager>> allPrisoners = new WeakHashMap();
    public static HashMap<Villager, Player> pumpkillagerPlayerTarget = new HashMap();
    public static WeakHashMap<Villager, Vec3> pumpkillagerPositions = new WeakHashMap();
    public static WeakHashMap<Villager, Vec3> prisonerPositions = new WeakHashMap();
    public static WeakHashMap<Villager, ServerBossEvent> pumpkillagerBossEvents = new WeakHashMap();
    public static WeakHashMap<Level, List<Pair<Player, MutableComponent>>> messagesToSend = new WeakHashMap();
    public static WeakHashMap<Level, CopyOnWriteArrayList<LivingEntity>> entitiesToYeet = new WeakHashMap();
    public static WeakHashMap<Level, HashMap<Villager, Runnable>> lightningTasks = new WeakHashMap();
    public static WeakHashMap<Level, List<LivingEntity>> spawnPumpkin = new WeakHashMap();
    public static HashMap<BlockPos, List<Pair<BlockPos, BlockState>>> previousStates = new HashMap();
    public static List<BlockPos> globalProcessedPoss = new ArrayList<BlockPos>();
    public static final TagKey<Block> pumpkinTag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"crops/pumpkin"));
    public static float pumpkillagerMaxHealth = 300.0f;
    public static final String pumpkillagerName = "The Pumpkillager";
    public static final String prisonerNameUnknown = "Prisoner";
    public static final String prisonerNameKnown = "Jax o'Saturn";
    public static final String questBookName = "Pumpkillager's Quest";
    public static final String stopPkBookName = "Stopping the Pumpkillager";
    public static final ChatFormatting defaultPumpkillagerColour = ChatFormatting.RED;
    public static final ChatFormatting defaultPrisonerColour = ChatFormatting.GOLD;

    public static MutableComponent addCharacterPrefix(Villager character, Player targetPlayer, MutableComponent component) {
        if (Util.isPumpkillager((Entity)character)) {
            return Data.addCharacterPrefix("pumpkillager", targetPlayer, component);
        }
        if (Util.isPrisoner((Entity)character)) {
            if (Util.prisonerIsKnown(character, targetPlayer)) {
                return Data.addCharacterPrefix("knownprisoner", targetPlayer, component);
            }
            return Data.addCharacterPrefix("unknownprisoner", targetPlayer, component);
        }
        return component;
    }

    public static MutableComponent addCharacterPrefix(String characterString, Player targetPlayer, MutableComponent component) {
        MutableComponent messageComponent = component;
        if (characterString.equals("pumpkillager")) {
            messageComponent = Component.literal((String)"<").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)pumpkillagerName).withStyle(defaultPumpkillagerColour)).append((Component)Component.literal((String)"> ").withStyle(ChatFormatting.WHITE)).append((Component)component);
        } else if (characterString.contains("prisoner")) {
            String prisonerName = prisonerNameUnknown;
            if (characterString.equals("knownprisoner")) {
                prisonerName = prisonerNameKnown;
            }
            messageComponent = Component.literal((String)"<").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)prisonerName).withStyle(defaultPrisonerColour)).append((Component)Component.literal((String)"> ").withStyle(ChatFormatting.WHITE)).append((Component)component);
        } else if (characterString.contains("Ghost")) {
            messageComponent = Component.literal((String)"<").withStyle(ChatFormatting.WHITE).append((Component)Component.literal((String)characterString).withStyle(ChatFormatting.RED)).append((Component)Component.literal((String)"> ").withStyle(ChatFormatting.WHITE)).append((Component)component);
        }
        return messageComponent;
    }

    public static ItemStack getQuestbook(Level level) {
        String nbtstring = "{components:{\"minecraft:custom_name\":'{\"color\":\"yellow\",\"translate\":\"Pumpkillager\\'s Quest\"}',\"minecraft:written_book_content\":{author:\"The Pumpkillager\",pages:[{raw:'{\"extra\":[{\"text\":\"The Quest\",\"underlined\":true},\"\\\\n\\\\nYou have accepted the Pumpkillager\\'s quest. Make sure that you\\'re prepared. You might need extra food and armour to make it through to the end of the quest. When you\\'re ready, gather the materials shown on the next page.\\\\n \"],\"text\":\"\"}'},{raw:'{\"extra\":[{\"text\":\"The Ritual\",\"underlined\":true},\"\\\\n\\\\nFor the summoning ritual you\\'ll need 16 redstone and one tnt.\\\\n\\\\nPlace the redstone in the 7x7 pattern shown on the next page, with the TNT in the middle.\"],\"text\":\"\"}'},{raw:'{\"extra\":[{\"text\":\"The Shape\",\"underlined\":true},\"\\\\n\\\\nPlace the redstone in the following shape, with a TNT in the middle:\\\\n\\\\n     \",{\"color\":\"#FCF6E9\",\"text\":\"_ _ _\"},{\"color\":\"red\",\"text\":\" R\"},{\"color\":\"#FCF6E9\",\"text\":\" _ _ _\"},\"\\\\n     \",{\"color\":\"#FCF6E9\",\"text\":\"_\"},{\"color\":\"red\",\"text\":\" R\"},{\"color\":\"#FCF6E9\",\"text\":\" _ _ _\"},{\"color\":\"red\",\"text\":\" R\"},{\"color\":\"#FCF6E9\",\"text\":\" _\"},\"\\\\n     \",{\"color\":\"#FCF6E9\",\"text\":\"_ _\"},{\"color\":\"red\",\"text\":\" R R R\"},{\"color\":\"#FCF6E9\",\"text\":\" _ _\"},\"\\\\n     \",{\"color\":\"red\",\"text\":\"R\"},{\"color\":\"#FCF6E9\",\"text\":\" _\"},{\"color\":\"red\",\"text\":\" R\"},{\"color\":\"dark_gray\",\"text\":\" T\"},{\"color\":\"red\",\"text\":\" R\"},{\"color\":\"#FCF6E9\",\"text\":\" _\"},{\"color\":\"red\",\"text\":\" R\"},\"\\\\n     \",{\"color\":\"#FCF6E9\",\"text\":\"_\"},{\"color\":\"#FCF6E9\",\"text\":\" _\"},{\"color\":\"red\",\"text\":\" R R R\"},{\"color\":\"#FCF6E9\",\"text\":\" _ _\"},\"\\\\n     \",{\"color\":\"#FCF6E9\",\"text\":\"_\"},{\"color\":\"red\",\"text\":\" R\"},{\"color\":\"#FCF6E9\",\"text\":\" _ _ _\"},{\"color\":\"red\",\"text\":\" R\"},{\"color\":\"#FCF6E9\",\"text\":\" _\"},\"\\\\n     \",{\"color\":\"#FCF6E9\",\"text\":\"_ _ _\"},{\"color\":\"red\",\"text\":\" R\"},{\"color\":\"#FCF6E9\",\"text\":\" _ _ _\"}],\"text\":\"\"}'},{raw:'{\"extra\":[{\"text\":\"The Summoning\",\"underlined\":true},\"\\\\n\\\\nLight the TNT. The blast combined with the power of the shaped redstone should do the trick.. probably.\\\\n \"],\"text\":\"\"}'}],resolved:1b,title:{raw:\"Pumpkillager's Quest\"}}},count:1,id:\"minecraft:written_book\"}";
        try {
            CompoundTag compoundTag = TagParser.parseCompoundFully((String)nbtstring);
            ItemStack questBookStack = ItemStack.CODEC.parse((DynamicOps)level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag).result().orElse(ItemStack.EMPTY);
            if (!questBookStack.isEmpty()) {
                questBookStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)questBookName).withStyle(ChatFormatting.YELLOW));
                return questBookStack;
            }
        }
        catch (CommandSyntaxException ex) {
            ex.printStackTrace();
        }
        System.out.println("Unable to get questbook.");
        return ItemStack.EMPTY;
    }

    public static ItemStack getStopPkbook(Level level) {
        String nbtstring = "{components:{\"minecraft:custom_name\":'{\"color\":\"yellow\",\"translate\":\"Stopping the Pumpkillager\"}',\"minecraft:written_book_content\":{author:\"Jax o'Saturn\",pages:[{raw:'{\"extra\":[{\"text\":\"The Pumpkillager\",\"underlined\":true},\"\\\\n\\\\nIf you\\'re reading this, it means that the Pumpkillager has been set loose on the world. This book with its knowledge has been passed down through generations in order to stop him.\\\\n \"],\"text\":\"\"}'},{raw:'{\"extra\":[{\"text\":\"The Ritual\",\"underlined\":true},\"\\\\n\\\\nFor the summoning ritual you\\'ll need 16 candles and one pumpkin. Make sure it is night-time.\\\\n\\\\nPlace the candles in the 7x7 pattern shown on the next page, with the pumpkin in the middle. The candles have to be lit.\"],\"text\":\"\"}'},{raw:'{\"extra\":[{\"text\":\"The Shape\",\"underlined\":true},\"\\\\n\\\\nPlace the lit candles in the following shape, with a pumpkin in the middle:\\\\n\\\\n     \",{\"color\":\"#FCF6E9\",\"text\":\"_ _ _\"},{\"color\":\"red\",\"text\":\" C\"},{\"color\":\"#FCF6E9\",\"text\":\" _ _ _\"},\"\\\\n     \",{\"color\":\"#FCF6E9\",\"text\":\"_\"},{\"color\":\"red\",\"text\":\" C\"},{\"color\":\"#FCF6E9\",\"text\":\" _ _ _\"},{\"color\":\"red\",\"text\":\" C\"},{\"color\":\"#FCF6E9\",\"text\":\" _\"},\"\\\\n     \",{\"color\":\"#FCF6E9\",\"text\":\"_ _\"},{\"color\":\"red\",\"text\":\" C C C\"},{\"color\":\"#FCF6E9\",\"text\":\" _ _\"},\"\\\\n     \",{\"color\":\"red\",\"text\":\"C\"},{\"color\":\"#FCF6E9\",\"text\":\" _\"},{\"color\":\"red\",\"text\":\" C\"},{\"color\":\"gold\",\"text\":\" P\"},{\"color\":\"red\",\"text\":\" C\"},{\"color\":\"#FCF6E9\",\"text\":\" _\"},{\"color\":\"red\",\"text\":\" C\"},\"\\\\n     \",{\"color\":\"#FCF6E9\",\"text\":\"_\"},{\"color\":\"#FCF6E9\",\"text\":\" _\"},{\"color\":\"red\",\"text\":\" C C C\"},{\"color\":\"#FCF6E9\",\"text\":\" _ _\"},\"\\\\n     \",{\"color\":\"#FCF6E9\",\"text\":\"_\"},{\"color\":\"red\",\"text\":\" C\"},{\"color\":\"#FCF6E9\",\"text\":\" _ _ _\"},{\"color\":\"red\",\"text\":\" C\"},{\"color\":\"#FCF6E9\",\"text\":\" _\"},\"\\\\n     \",{\"color\":\"#FCF6E9\",\"text\":\"_ _ _\"},{\"color\":\"red\",\"text\":\" C\"},{\"color\":\"#FCF6E9\",\"text\":\" _ _ _\"}],\"text\":\"\"}'},{raw:'{\"extra\":[{\"text\":\"The Summoning\",\"underlined\":true},\"\\\\n\\\\nCompleting the ritual should draw in the Pumpkillager. To weaken him, you\\'ll need to shoot a spectral arrow at his feet. This will make him vulnerable to normal attacks. Good luck, for the sake of the whole world.\\\\n \"],\"text\":\"\"}'}],resolved:1b,title:{raw:\"Stopping the Pumpkillager\"}}},count:1,id:\"minecraft:written_book\"}";
        try {
            CompoundTag compoundTag = TagParser.parseCompoundFully((String)nbtstring);
            ItemStack questBookStack = ItemStack.CODEC.parse((DynamicOps)level.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)compoundTag).result().orElse(ItemStack.EMPTY);
            if (!questBookStack.isEmpty()) {
                questBookStack.set(DataComponents.CUSTOM_NAME, (Object)Component.translatable((String)stopPkBookName).withStyle(ChatFormatting.YELLOW));
                return questBookStack;
            }
        }
        catch (CommandSyntaxException ex) {
            ex.printStackTrace();
        }
        System.out.println("Unable to get questbook.");
        return ItemStack.EMPTY;
    }
}

