/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_forge.events;

import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.pumpkillagersquest_common_forge.config.ConfigHandler;
import com.natamus.pumpkillagersquest_common_forge.pumpkillager.Conversations;
import com.natamus.pumpkillagersquest_common_forge.pumpkillager.Manage;
import com.natamus.pumpkillagersquest_common_forge.pumpkillager.RitualCheck;
import com.natamus.pumpkillagersquest_common_forge.util.Data;
import com.natamus.pumpkillagersquest_common_forge.util.GenerateStructure;
import com.natamus.pumpkillagersquest_common_forge.util.SpookyHeads;
import com.natamus.pumpkillagersquest_common_forge.util.Util;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.WrittenBookItem;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;

public class PkBlockEvents {
    public static boolean onBlockBreak(Level level, Player player, BlockPos pos, BlockState state, BlockEntity blockEntity) {
        ResolvableProfile resolvableProfile;
        SkullBlockEntity skullBlockEntity;
        Object posBlockEntity;
        if (level.isClientSide()) {
            return true;
        }
        Block block = state.getBlock();
        if ((block instanceof SkullBlock || block instanceof WallSkullBlock) && !player.isCreative() && (posBlockEntity = level.getBlockEntity(pos)) instanceof SkullBlockEntity && (skullBlockEntity = (SkullBlockEntity)posBlockEntity) != null && (resolvableProfile = skullBlockEntity.getOwnerProfile()) != null) {
            CompletableFuture gameProfileFuture = resolvableProfile.resolveProfile(level.getServer().services().profileResolver());
            gameProfileFuture.thenAccept(gameProfile -> {
                UUID uuid;
                if (gameProfile != null && (uuid = gameProfile.id()) != null) {
                    ItemStack namedHeadItemStack;
                    String headId = uuid.toString();
                    String correctHeadName = "";
                    for (String headName : SpookyHeads.allHeadData.keySet()) {
                        String headNameid = (String)SpookyHeads.allHeadData.get(headName).getFirst();
                        if (!headId.equals(headNameid)) continue;
                        correctHeadName = headName;
                        break;
                    }
                    if (!correctHeadName.isEmpty() && (namedHeadItemStack = SpookyHeads.getSpookyOrPumpkinHead(correctHeadName, 1)) != null) {
                        level.getEntitiesOfClass(ItemEntity.class, new AABB(pos).inflate(1.0), e -> e.getItem().is(Items.PLAYER_HEAD)).forEach(Entity::discard);
                        level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY() + 0.5, (double)pos.getZ(), namedHeadItemStack));
                    }
                }
            });
        }
        if (Data.globalProcessedPoss.contains(pos)) {
            for (Entity ea : level.getEntities(null, new AABB((double)(pos.getX() - 2), (double)(pos.getY() - 2), (double)(pos.getZ() - 2), (double)(pos.getX() + 2), (double)(pos.getY() + 2), (double)(pos.getZ() + 2)))) {
                if (!(ea instanceof Villager) || !Util.isPumpkillager(ea)) continue;
                Villager pumpkillager = (Villager)ea;
                MessageFunctions.sendMessage((Player)player, (MutableComponent)Component.literal((String)""));
                Conversations.addMessage(level, pumpkillager, player, "How dare you try to steal my blocks, " + player.getName().getString() + ".", ChatFormatting.WHITE, 0);
                Conversations.addMessage(level, pumpkillager, player, "I will be back.", ChatFormatting.WHITE, 0);
                pumpkillager.getTags().add("pumpkillagersquest.preventactions");
                Manage.initiateCharacterLeave(level, pumpkillager);
                return false;
            }
        }
        if (!ConfigHandler.enablePumpkillagerSpawnDuringCreative && player.isCreative()) {
            return true;
        }
        Set playerTags = player.getTags();
        if (!playerTags.contains("pumpkillagersquest.completedquest") && !playerTags.contains("pumpkillagersquest.unleashed") && Util.isPumpkinBlock(block) && !Data.pumpkillagerPlayerTarget.containsValue(player) && Util.pumpkinBlockIsClear(level, pos) && GlobalVariables.random.nextDouble() <= ConfigHandler.pumpkillagerSpawnChance) {
            boolean foundQuestBook = false;
            Inventory inventory = player.getInventory();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                String bookName;
                ItemStack inventoryStack = inventory.getItem(i);
                if (!(inventoryStack.getItem() instanceof WrittenBookItem) || !(bookName = inventoryStack.getHoverName().getString()).equals("Pumpkillager's Quest")) continue;
                foundQuestBook = true;
                break;
            }
            if (foundQuestBook) {
                return true;
            }
            Manage.spawnPumpkillager(level, player, pos);
        }
        return true;
    }

    public static boolean onCandleClick(Level level, Player player, InteractionHand hand, BlockPos pos, BlockHitResult hitVec) {
        String bookName;
        ItemStack itemStack = player.getItemInHand(hand);
        Item item = itemStack.getItem();
        if (item instanceof FlintAndSteelItem) {
            if (!player.getTags().contains("pumpkillagersquest.cansummonfinalform")) {
                return true;
            }
            BlockState state = level.getBlockState(pos);
            Block block = state.getBlock();
            if (!(block instanceof CandleBlock)) {
                return true;
            }
            CandleBlock candleBlock = (CandleBlock)block;
            boolean isLit = (Boolean)state.getValue((Property)CandleBlock.LIT);
            if (isLit) {
                return true;
            }
            BlockPos pumpkinPos = null;
            for (BlockPos aroundPos : BlockPos.betweenClosed((int)(pos.getX() - 3), (int)pos.getY(), (int)(pos.getZ() - 3), (int)(pos.getX() + 3), (int)pos.getY(), (int)(pos.getZ() + 3))) {
                if (!Util.isPumpkinBlock(level.getBlockState(aroundPos).getBlock())) continue;
                pumpkinPos = aroundPos.immutable();
                break;
            }
            if (pumpkinPos == null) {
                return true;
            }
            RitualCheck.checkRitualFinalSummoning(level, player, pumpkinPos, pos);
        } else if (item instanceof WrittenBookItem && (bookName = itemStack.getDisplayName().getString()).contains("Pumpkillager")) {
            if (level.isClientSide()) {
                GenerateStructure.generateClientRitualVision(level, player, pos, itemStack);
            }
            return false;
        }
        return true;
    }

    public static boolean onBlockPlace(Level level, BlockPos blockPos, BlockState blockState, LivingEntity livingEntity, ItemStack itemStack) {
        if (level.isClientSide()) {
            return true;
        }
        if (!(livingEntity instanceof Player)) {
            return true;
        }
        if (!Util.isPumpkinBlock(blockState.getBlock())) {
            return true;
        }
        Player player = (Player)livingEntity;
        if (!player.getTags().contains("pumpkillagersquest.cansummonfinalform")) {
            return true;
        }
        RitualCheck.checkRitualFinalSummoning(level, player, blockPos, null);
        return true;
    }
}

