/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.quickpaths_common_neoforge.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_neoforge.functions.BlockFunctions;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.functions.NumberFunctions;
import com.natamus.collective_common_neoforge.services.Services;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.phys.BlockHitResult;

public class PathEvent {
    private static final HashMap<String, BlockPos> playernamelastpos = new HashMap();
    private static final HashMap<BlockPos, Pair<Date, List<BlockPos>>> lastpath = new HashMap();
    private static int currenttick = 6000;

    public static void onServerTick(MinecraftServer minecraftServer) {
        if (currenttick != 0) {
            --currenttick;
            return;
        }
        currenttick = 6000;
        Date now = new Date();
        ArrayList<BlockPos> toremove = new ArrayList<BlockPos>();
        HashMap<BlockPos, Pair<Date, List<BlockPos>>> loop = new HashMap<BlockPos, Pair<Date, List<BlockPos>>>(lastpath);
        for (BlockPos key : loop.keySet()) {
            Date pathdate = (Date)loop.get(key).getFirst();
            long ms = now.getTime() - pathdate.getTime();
            if (ms <= 300000L) continue;
            toremove.add(key);
        }
        for (BlockPos tr : toremove) {
            lastpath.remove(tr);
        }
    }

    public static boolean onRightClickGrass(Level level, Player player, InteractionHand hand, BlockPos targetpos, BlockHitResult hitVec) {
        ArrayList<BlockPos> pathpositions;
        if (level.isClientSide()) {
            return true;
        }
        ItemStack handstack = player.getItemInHand(hand);
        if (!Services.TOOLFUNCTIONS.isShovel(handstack)) {
            return true;
        }
        Date now = new Date();
        Block block = level.getBlockState(targetpos).getBlock();
        if (block.equals(Blocks.AIR)) {
            targetpos = targetpos.below().immutable();
            block = level.getBlockState(targetpos).getBlock();
        }
        if (block.equals(Blocks.DIRT_PATH)) {
            if (lastpath.containsKey(targetpos)) {
                int count = 0;
                Pair<Date, List<BlockPos>> pair = lastpath.get(targetpos);
                long ms = now.getTime() - ((Date)pair.getFirst()).getTime();
                if (ms < 300000L) {
                    for (BlockPos pathpos : (List)pair.getSecond()) {
                        if (!level.getBlockState(pathpos).getBlock().equals(Blocks.DIRT_PATH) || !level.getBlockState(pathpos.immutable().above()).getBlock().equals(Blocks.AIR)) continue;
                        level.setBlockAndUpdate(pathpos, Blocks.GRASS_BLOCK.defaultBlockState());
                        ++count;
                    }
                }
                lastpath.remove(targetpos);
                MessageFunctions.sendMessage((Player)player, (String)("[Quick Paths] " + count + " grass blocks restored."), (ChatFormatting)ChatFormatting.DARK_GREEN);
                return false;
            }
        } else if (!block.equals(Blocks.GRASS_BLOCK)) {
            return true;
        }
        if (handstack.getDamageValue() >= handstack.getMaxDamage() - 1 && player.isCrouching()) {
            MessageFunctions.sendMessage((Player)player, (String)"[Quick Paths] Your shovel is too damaged to create paths.", (ChatFormatting)ChatFormatting.RED);
            return false;
        }
        String playername = player.getName().getString();
        if (playernamelastpos.containsKey(playername) && !player.isCrouching()) {
            BlockPos lastpos = playernamelastpos.get(playername);
            boolean movex = true;
            int difx = lastpos.getX() - targetpos.getX();
            int difz = lastpos.getZ() - targetpos.getZ();
            int begindifx = difx;
            int begindifz = difz;
            ArrayList<Pair> xzset = new ArrayList<Pair>();
            pathpositions = new ArrayList<BlockPos>(Arrays.asList(lastpos));
            for (int lyd = lastpos.getY() - 10; lyd < lastpos.getY() + 10; ++lyd) {
                difx = begindifx;
                difz = begindifz;
                while (difx != 0 || difz != 0) {
                    BlockPos betweenpos;
                    Pair xz;
                    if (movex) {
                        difx += NumberFunctions.moveToZero((int)difx);
                        movex = difz == 0;
                    } else {
                        difz += NumberFunctions.moveToZero((int)difz);
                        boolean bl = movex = difx != 0;
                    }
                    if (xzset.contains(xz = new Pair((Object)(targetpos.getX() + difx), (Object)(targetpos.getZ() + difz))) || !level.getBlockState(betweenpos = new BlockPos(targetpos.getX() + difx, lyd, targetpos.getZ() + difz)).getBlock().equals(Blocks.GRASS_BLOCK)) continue;
                    BlockPos abovepos = betweenpos.immutable().above();
                    Block aboveblock = level.getBlockState(abovepos).getBlock();
                    if (!aboveblock.equals(Blocks.AIR)) {
                        if (aboveblock instanceof BushBlock || aboveblock instanceof CropBlock) {
                            BlockFunctions.dropBlock((Level)level, (BlockPos)abovepos);
                        } else {
                            return true;
                        }
                    }
                    level.setBlockAndUpdate(betweenpos, Blocks.DIRT_PATH.defaultBlockState());
                    pathpositions.add(betweenpos.immutable());
                    xzset.add(xz);
                    if (player.isCreative()) continue;
                    handstack.hurtAndBreak(1, (ServerLevel)level, null, item -> {});
                }
            }
            if (handstack.getDamageValue() > handstack.getMaxDamage()) {
                handstack.setDamageValue(handstack.getMaxDamage() - 1);
            }
        } else {
            BlockPos lastpos;
            if (!player.isCrouching()) {
                return true;
            }
            level.setBlockAndUpdate(targetpos, Blocks.DIRT_PATH.defaultBlockState());
            if (playernamelastpos.containsKey(playername) && (lastpos = playernamelastpos.get(playername)) != targetpos && level.getBlockState(lastpos).getBlock().equals(Blocks.DIRT_PATH)) {
                level.setBlockAndUpdate(lastpos, Blocks.GRASS_BLOCK.defaultBlockState());
            }
            playernamelastpos.put(playername, targetpos);
            MessageFunctions.sendMessage((Player)player, (String)("[Quick Paths] Starting point set to " + targetpos.getX() + ", " + targetpos.getY() + ", " + targetpos.getZ() + "."), (ChatFormatting)ChatFormatting.DARK_GREEN);
            return false;
        }
        lastpath.put(targetpos, (Pair<Date, List<BlockPos>>)new Pair((Object)now, pathpositions));
        playernamelastpos.remove(playername);
        MessageFunctions.sendMessage((Player)player, (String)("[Quick Paths] Path of " + pathpositions.size() + " blocks created. To undo, right click last clicked block again."), (ChatFormatting)ChatFormatting.DARK_GREEN);
        return true;
    }
}

