/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.configurabledespawntimer_common_forge.cmd;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.natamus.collective_common_forge.functions.MessageFunctions;
import com.natamus.configurabledespawntimer_common_forge.util.Util;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.world.level.Level;

public class CommandCdt {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"cdt").requires(iCommandSender -> iCommandSender.hasPermission(2))).executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            CommandCdt.showUsage(source);
            return 1;
        })).then(Commands.literal((String)"usage").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            CommandCdt.showUsage(source);
            return 1;
        }))).then(Commands.literal((String)"reload").executes(command -> {
            CommandSourceStack source = (CommandSourceStack)command.getSource();
            try {
                Util.loadItemConfig((Level)source.getLevel());
            }
            catch (Exception ex) {
                MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Something went wrong while reloading the despawn timer config file.", (ChatFormatting)ChatFormatting.RED);
                ex.printStackTrace();
                return 0;
            }
            MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Successfully loaded the despawn timer config file.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            return 1;
        })));
    }

    private static void showUsage(CommandSourceStack source) {
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"Configurable Despawn Timer Usage:", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /cdt usage", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"  Show this message.", (ChatFormatting)ChatFormatting.DARK_GRAY);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)" /cdt reload", (ChatFormatting)ChatFormatting.DARK_GREEN);
        MessageFunctions.sendMessage((CommandSourceStack)source, (String)"  Reloads the config file.", (ChatFormatting)ChatFormatting.DARK_GRAY);
    }
}

