/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.replantingcrops_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.ItemFunctions;
import com.natamus.collective_common_neoforge.services.Services;
import com.natamus.replantingcrops_common_neoforge.config.ConfigHandler;
import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CocoaBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CropEvent {
    private static final HashMap<BlockPos, Block> checkreplant = new HashMap();
    private static final HashMap<BlockPos, BlockState> cocoaStates = new HashMap();

    public static boolean onHarvest(Level world, Player player, BlockPos hpos, BlockState state, BlockEntity blockEntity) {
        if (world.isClientSide()) {
            return true;
        }
        if (player == null) {
            return true;
        }
        InteractionHand hand = null;
        if (ConfigHandler.mustHoldHoeForReplanting) {
            hand = InteractionHand.MAIN_HAND;
            if (!Services.TOOLFUNCTIONS.isHoe(player.getMainHandItem())) {
                hand = InteractionHand.OFF_HAND;
                if (!Services.TOOLFUNCTIONS.isHoe(player.getOffhandItem())) {
                    return true;
                }
            }
        }
        if (player.isShiftKeyDown()) {
            return true;
        }
        Block block = state.getBlock();
        if (block instanceof CropBlock) {
            checkreplant.put(hpos, block);
        } else if (block.equals(Blocks.NETHER_WART)) {
            checkreplant.put(hpos, block);
        } else if (block.equals(Blocks.COCOA)) {
            cocoaStates.put(hpos, state);
            checkreplant.put(hpos, block);
        } else {
            return true;
        }
        if (hand != null && !player.isCreative()) {
            ItemFunctions.itemHurtBreakAndEvent((ItemStack)player.getItemInHand(hand), (ServerPlayer)((ServerPlayer)player), (InteractionHand)hand, (int)1);
        }
        return true;
    }

    public static boolean onCropEntity(Level world, Entity entity) {
        ItemEntity itementity;
        ItemStack itemstack;
        Item item;
        if (world.isClientSide()) {
            return true;
        }
        if (!(entity instanceof ItemEntity)) {
            return true;
        }
        BlockPos ipos = entity.blockPosition();
        if (!checkreplant.containsKey(ipos)) {
            return true;
        }
        Block preblock = checkreplant.get(ipos);
        Item compareitem = null;
        if (preblock instanceof CropBlock) {
            compareitem = preblock.asItem();
        }
        if ((item = (itemstack = (itementity = (ItemEntity)entity).getItem()).getItem()).equals(compareitem)) {
            world.setBlockAndUpdate(ipos, preblock.defaultBlockState());
        } else if (item.equals(Items.NETHER_WART)) {
            world.setBlockAndUpdate(ipos, Blocks.NETHER_WART.defaultBlockState());
        } else if (item.equals(Items.COCOA_BEANS)) {
            if (!cocoaStates.containsKey(ipos)) {
                checkreplant.remove(ipos);
                return true;
            }
            world.setBlockAndUpdate(ipos, (BlockState)cocoaStates.get(ipos).setValue((Property)CocoaBlock.AGE, (Comparable)Integer.valueOf(0)));
            cocoaStates.remove(ipos);
        } else {
            return true;
        }
        checkreplant.remove(ipos);
        if (itemstack.getCount() <= 1) {
            entity.remove(Entity.RemovalReason.DISCARDED);
            return false;
        }
        itemstack.shrink(1);
        return true;
    }
}

