/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.villagespawnpoint_common_fabric.events;

import com.mojang.logging.LogUtils;
import com.natamus.collective_common_fabric.functions.BlockPosFunctions;
import com.natamus.collective_common_fabric.functions.FeatureFunctions;
import com.natamus.villagespawnpoint_common_fabric.config.ConfigHandler;
import com.natamus.villagespawnpoint_common_fabric.data.Constants;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_5217;
import net.minecraft.class_5268;
import net.minecraft.class_5285;
import net.minecraft.class_5321;
import org.slf4j.Logger;

public class VillageSpawnEvent {
    private static final Logger logger = LogUtils.getLogger();

    public static boolean onWorldLoad(class_3218 serverLevel, class_5268 serverLevelData) {
        if (Constants.biomeSpawnPointLoaded) {
            return false;
        }
        class_5285 worldGeneratorOptions = serverLevel.method_8503().method_27728().method_28057();
        if (!worldGeneratorOptions.method_28029()) {
            return false;
        }
        logger.info("[Village Spawn Point] Finding the nearest village. This might take a few seconds.");
        class_2338 spawnPos = BlockPosFunctions.getNearbyVillage((class_3218)serverLevel, (class_2338)new class_2338(0, 0, 0), (String)ConfigHandler.locateVillageTag);
        if (spawnPos == null) {
            if (ConfigHandler.keepDefaultVillageTagBackup && !ConfigHandler.locateVillageTag.equals("#minecraft:village")) {
                spawnPos = BlockPosFunctions.getNearbyVillage((class_3218)serverLevel, (class_2338)new class_2338(0, 0, 0), (String)"#minecraft:village");
            }
            if (spawnPos == null) {
                return false;
            }
        }
        logger.info("[Village Spawn Point] Village found! The world will now generate.");
        class_5217.class_12064 oldRespawnData = serverLevel.method_74854();
        class_5217.class_12064 newRespawnData = class_5217.class_12064.method_74895((class_5321)oldRespawnData.method_74894(), (class_2338)spawnPos, (float)oldRespawnData.comp_4916(), (float)oldRespawnData.comp_4917());
        serverLevel.method_27873(newRespawnData);
        if (worldGeneratorOptions.method_28030()) {
            FeatureFunctions.placeBonusChest((class_1937)serverLevel, (class_2338)spawnPos);
        }
        return true;
    }
}

