/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.treeharvester_common_fabric.events;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_fabric.functions.BlockFunctions;
import com.natamus.collective_common_fabric.functions.ItemFunctions;
import com.natamus.collective_common_fabric.services.Services;
import com.natamus.treeharvester_common_fabric.config.ConfigHandler;
import com.natamus.treeharvester_common_fabric.data.Variables;
import com.natamus.treeharvester_common_fabric.processing.LeafProcessing;
import com.natamus.treeharvester_common_fabric.processing.TreeProcessing;
import com.natamus.treeharvester_common_fabric.util.Util;
import java.util.Date;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;

public class TreeCutEvents {
    public static boolean onTreeHarvest(class_1937 level, class_1657 player, class_2338 bpos, class_2680 state, class_2586 blockEntity) {
        int logcount;
        class_2248 block;
        if (level.method_8608()) {
            return true;
        }
        Pair cachepair = new Pair((Object)level, (Object)player);
        if (!Variables.harvestSpeedCache.containsKey(cachepair)) {
            if (ConfigHandler.treeHarvestWithoutSneak ? player.method_18276() : !player.method_18276()) {
                return true;
            }
        } else {
            Variables.harvestSpeedCache.remove(cachepair);
        }
        if (!Util.isTreeLog(block = level.method_8320(bpos).method_26204())) {
            return true;
        }
        class_1799 hand = player.method_5998(class_1268.field_5808);
        class_1792 handitem = hand.method_7909();
        if (ConfigHandler.mustHoldAxeForTreeHarvest) {
            if (!Services.TOOLFUNCTIONS.isAxe(hand)) {
                return true;
            }
            if (!Variables.allowedAxes.contains(handitem)) {
                return true;
            }
        }
        if (ConfigHandler.automaticallyFindBottomBlock) {
            class_2338 temppos = bpos.method_10062();
            while (level.method_8320(temppos.method_10074()).method_26204().equals(block)) {
                temppos = temppos.method_10074().method_10062();
            }
            for (class_2338 belowpos : class_2338.method_10094((int)(temppos.method_10263() - 1), (int)(temppos.method_10264() - 1), (int)(temppos.method_10260() - 1), (int)(temppos.method_10263() + 1), (int)(temppos.method_10264() - 1), (int)(temppos.method_10260() + 1))) {
                if (!level.method_8320(belowpos).method_26204().equals(block)) continue;
                temppos = belowpos.method_10062();
                while (level.method_8320(temppos.method_10074()).method_26204().equals(block)) {
                    temppos = temppos.method_10074().method_10062();
                }
                break block1;
            }
            bpos = temppos.method_10062();
        }
        if ((logcount = TreeProcessing.isTreeAndReturnLogAmount(level, bpos)) < 0) {
            return true;
        }
        int durabilitylosecount = (int)Math.ceil(1.0 / ConfigHandler.loseDurabilityModifier);
        int durabilitystartcount = -1;
        class_3222 serverPlayer = (class_3222)player;
        class_2338 highestLogPos = bpos.method_10062();
        List<class_2338> logsToBreak = TreeProcessing.getAllLogsToBreak(level, bpos, logcount, block);
        for (class_2338 logpos : logsToBreak) {
            if (logpos.method_10264() > highestLogPos.method_10264()) {
                highestLogPos = logpos.method_10062();
            }
            class_2680 logstate = level.method_8320(logpos);
            class_2248 log = logstate.method_26204();
            BlockFunctions.dropBlock((class_1937)level, (class_2338)logpos);
            if (player.method_68878()) continue;
            if (ConfigHandler.loseDurabilityPerHarvestedLog) {
                if (durabilitystartcount == -1) {
                    durabilitystartcount = durabilitylosecount;
                    ItemFunctions.itemHurtBreakAndEvent((class_1799)hand, (class_3222)serverPlayer, (class_1268)class_1268.field_5808, (int)1);
                } else if (--durabilitylosecount == 0) {
                    ItemFunctions.itemHurtBreakAndEvent((class_1799)hand, (class_3222)serverPlayer, (class_1268)class_1268.field_5808, (int)1);
                    durabilitylosecount = durabilitystartcount;
                }
            }
            if (!ConfigHandler.increaseExhaustionPerHarvestedLog) continue;
            player.method_7322(0.025f * (float)ConfigHandler.increaseExhaustionModifier);
        }
        LeafProcessing.breakTreeLeaves(level, logsToBreak, bpos, highestLogPos);
        return logsToBreak.size() == 0;
    }

    public static float onHarvestBreakSpeed(class_1937 level, class_1657 player, float digSpeed, class_2680 state) {
        if (!ConfigHandler.increaseHarvestingTimePerLog) {
            return digSpeed;
        }
        class_2248 block = state.method_26204();
        if (!Util.isTreeLog(block)) {
            return digSpeed;
        }
        if (ConfigHandler.treeHarvestWithoutSneak ? player.method_18276() : !player.method_18276()) {
            return digSpeed;
        }
        class_1799 hand = player.method_5998(class_1268.field_5808);
        class_1792 handitem = hand.method_7909();
        if (ConfigHandler.mustHoldAxeForTreeHarvest) {
            if (!Services.TOOLFUNCTIONS.isAxe(hand)) {
                return digSpeed;
            }
            if (!Variables.allowedAxes.contains(handitem)) {
                return digSpeed;
            }
        }
        int logcount = -1;
        Date now = new Date();
        Pair keypair = new Pair((Object)level, (Object)player);
        if (Variables.harvestSpeedCache.containsKey(keypair)) {
            Pair<Date, Integer> valuepair = Variables.harvestSpeedCache.get(keypair);
            long ms = now.getTime() - ((Date)valuepair.getFirst()).getTime();
            if (ms < 1000L) {
                logcount = (Integer)valuepair.getSecond();
            } else {
                Variables.harvestSpeedCache.remove(keypair);
            }
        }
        class_2338 bpos = null;
        class_239 hitResult = player.method_5745(20.0, 0.0f, false);
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            bpos = ((class_3965)hitResult).method_17777();
        }
        if (bpos == null) {
            return digSpeed;
        }
        boolean recheck = false;
        if (logcount < 0) {
            if (TreeProcessing.isTreeAndReturnLogAmount(level, bpos) < 0) {
                return digSpeed;
            }
            logcount = TreeProcessing.isTreeAndReturnLogAmount(level, bpos);
            if (logcount == 0) {
                return digSpeed;
            }
            Variables.harvestSpeedCache.put((Pair<class_1937, class_1657>)keypair, (Pair<Date, Integer>)new Pair((Object)now, (Object)logcount));
            recheck = true;
        }
        return digSpeed / (1.0f + (float)logcount * (float)ConfigHandler.increasedHarvestingTimePerLogModifier);
    }
}

