/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.simplemenu_common_forge.mixin;

import com.natamus.collective_common_forge.functions.ScreenFunctions;
import com.natamus.collective_common_forge.services.Services;
import com.natamus.simplemenu_common_forge.config.ConfigHandler;
import com.natamus.simplemenu_common_forge.data.Buttons;
import com.natamus.simplemenu_common_forge.data.Constants;
import com.natamus.simplemenu_common_forge.util.Util;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.network.chat.Component;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Screen.class}, priority=1001)
public abstract class ScreenMixin {
    @Unique
    private static int singlePlayerButtonWidth = 0;

    @Inject(method={"addRenderableWidget(Lnet/minecraft/client/gui/components/events/GuiEventListener;)Lnet/minecraft/client/gui/components/events/GuiEventListener;"}, at={@At(value="HEAD")})
    protected <T extends GuiEventListener & Renderable> void addRenderableWidget(T renderableWidget, CallbackInfoReturnable<T> cir) {
        Screen screen = (Screen)this;
        if (!(screen instanceof TitleScreen)) {
            return;
        }
        if (renderableWidget instanceof Button) {
            Button button = (Button)renderableWidget;
            Component buttonMessage = button.getMessage();
            if (buttonMessage.equals((Object)Constants.singlePlayerButtonComponent)) {
                singlePlayerButtonWidth = button.getWidth();
            } else if (buttonMessage.equals((Object)Constants.realmsButtonComponent)) {
                if (ConfigHandler.hideMinecraftRealmsButton) {
                    button.visible = false;
                }
                if (ConfigHandler.enableServerPromoButton) {
                    Buttons.serverPromoButton = (Button)ScreenFunctions.addRenderableWidget((Screen)screen, (GuiEventListener)Button.builder((Component)Component.literal((String)ConfigHandler.serverPromoButtonTextDefault), f -> Util.openUrl(ConfigHandler.serverPromoButtonClickURL)).bounds(button.getX(), button.getY(), button.getWidth(), button.getHeight()).build());
                }
            }
            if (ConfigHandler.expandModsButton && singlePlayerButtonWidth != 0 && button.getMessage().toString().contains("menu.mods") && !Services.MODLOADER.getModLoaderName().equals("Fabric")) {
                button.setWidth(singlePlayerButtonWidth);
            }
        }
    }
}

