/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.netherportalspread_common_neoforge.util;

import com.natamus.collective_common_neoforge.functions.BlockFunctions;
import com.natamus.collective_common_neoforge.functions.CompareBlockFunctions;
import com.natamus.collective_common_neoforge.functions.DataFunctions;
import com.natamus.collective_common_neoforge.functions.DimensionFunctions;
import com.natamus.collective_common_neoforge.functions.HashMapFunctions;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.functions.NumberFunctions;
import com.natamus.collective_common_neoforge.functions.WorldFunctions;
import com.natamus.collective_common_neoforge.objects.RandomCollection;
import com.natamus.netherportalspread_common_neoforge.config.ConfigHandler;
import com.natamus.netherportalspread_common_neoforge.data.Variables;
import com.natamus.netherportalspread_common_neoforge.util.DefaultConfigs;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.ChatFormatting;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class Util {
    public static HashMap<Level, CopyOnWriteArrayList<BlockPos>> portals = new HashMap();
    public static HashMap<Level, HashMap<BlockPos, Boolean>> preventedportals = new HashMap();
    private static final HashMap<Block, HashMap<Block, Double>> convertinto = new HashMap();
    private static final List<Block> convertblocks = new ArrayList<Block>();
    private static final List<Block> convertedblocks = new ArrayList<Block>();
    private static Block preventSpreadBlock = null;

    public static void attemptSpreadBlockProcess(Level level) {
        if (!Variables.processedSpreadBlockLoad) {
            try {
                Util.loadSpreadBlocks(level);
                Variables.processedSpreadBlockLoad = true;
            }
            catch (IOException ex) {
                System.out.println("[Nether Portal Spread] Something went wrong loading the nether spread block config.");
            }
        }
    }

    public static void loadSpreadBlocks(Level level) throws IOException {
        Registry blockRegistry = level.registryAccess().lookupOrThrow(Registries.BLOCK);
        String dirpath = DataFunctions.getConfigDirectory() + File.separator + "netherportalspread";
        File dir = new File(dirpath);
        File file = new File(dirpath + File.separator + "spreadsettings.txt");
        if (dir.isDirectory() && file.isFile()) {
            String spreadsettings = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "spreadsettings.txt", new String[0])));
            spreadsettings = spreadsettings.replace("\n", "").replace("\r", "").replace(" ", "");
            for (String line : spreadsettings.split(",")) {
                if (line.length() < 4) {
                    System.out.println("The Nether Portal Spread spread settings contains an empty line. Ignoring it.");
                    continue;
                }
                String[] linespl = line.split(";");
                if (linespl.length != 2) {
                    System.out.println("[Nether Portal Spread] The spread settings line '" + line + "' contains errors. Ignoring it.");
                    continue;
                }
                Object fromblockstr = linespl[0];
                if (!((String)fromblockstr).contains(":")) {
                    fromblockstr = "minecraft:" + (String)fromblockstr;
                }
                ResourceLocation frl = ResourceLocation.parse((String)fromblockstr);
                if (!blockRegistry.keySet().contains(frl)) {
                    System.out.println("[Nether Portal Spread] 1: Unable to find from-block '" + (String)fromblockstr + "' in the Forge block registry. Ignoring it.");
                    continue;
                }
                Optional fromBlockOptionalReference = blockRegistry.get(frl);
                if (fromBlockOptionalReference.isEmpty()) {
                    System.out.println("[Nether Portal Spread] 2: Unable to find from-block '" + (String)fromblockstr + "' in the Forge block registry. Ignoring it.");
                    continue;
                }
                String toblocks = linespl[1].replace("[", "").replace("]", "");
                double totalweight = 0.0;
                HashMap<Block, Double> tempmap = new HashMap<Block, Double>();
                for (String tb : toblocks.split("\\+")) {
                    Optional trlBlockOptionalReference;
                    String[] tbspl = tb.split(">");
                    if (tbspl.length < 2) continue;
                    Object toblockstr = tbspl[0];
                    if (!((String)toblockstr).contains(":")) {
                        toblockstr = "minecraft:" + (String)toblockstr;
                    }
                    double weight = 1.0;
                    try {
                        weight = Double.parseDouble(tbspl[1]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    totalweight += weight;
                    ResourceLocation trl = ResourceLocation.parse((String)toblockstr);
                    if (blockRegistry.keySet().contains(trl) && (trlBlockOptionalReference = blockRegistry.get(trl)).isPresent()) {
                        tempmap.put((Block)((Holder.Reference)trlBlockOptionalReference.get()).value(), weight);
                        continue;
                    }
                    System.out.println("[Nether Portal Spread] Unable to find to-block '" + (String)toblockstr + "' in the Forge block registry. Ignoring it.");
                }
                if (tempmap.size() == 0 || totalweight == 0.0) {
                    System.out.println("[Nether Portal Spread] The spread settings line '" + line + "' contains errors, no convert blocks were found. Ignoring it.");
                    continue;
                }
                for (Block key : tempmap.keySet()) {
                    Double weightvalue = (Double)tempmap.get(key);
                    tempmap.put(key, 1.0 / totalweight * weightvalue);
                }
                convertinto.put((Block)((Holder.Reference)fromBlockOptionalReference.get()).value(), tempmap);
            }
            for (Block b0 : convertinto.keySet()) {
                convertblocks.add(b0);
                convertedblocks.addAll(convertinto.get(b0).keySet());
            }
        } else {
            dir.mkdirs();
            List<String> defaultconfig = DefaultConfigs.getDefaultConfigForVersion("[1.21.10]");
            PrintWriter writer = new PrintWriter(dirpath + File.separator + "spreadsettings.txt", StandardCharsets.UTF_8);
            for (String line : defaultconfig) {
                writer.println(line);
            }
            writer.close();
            Util.loadSpreadBlocks(level);
        }
        if (preventSpreadBlock == null) {
            String psbstr = ConfigHandler.preventSpreadBlockString.strip().replaceAll("[^a-z0-9_.-:]", "");
            try {
                Optional preventSpreadBlockOptionalReference;
                ResourceLocation psbrl = ResourceLocation.parse((String)psbstr);
                if (blockRegistry.keySet().contains(psbrl) && (preventSpreadBlockOptionalReference = blockRegistry.get(psbrl)).isPresent()) {
                    preventSpreadBlock = (Block)((Holder.Reference)preventSpreadBlockOptionalReference.get()).value();
                    return;
                }
            }
            catch (ResourceLocationException resourceLocationException) {
                // empty catch block
            }
            System.out.println("[Nether Portal Spread] Unable to get a prevent-spread-block from the string '" + psbstr + "'. Using the default coal block instead.");
            preventSpreadBlock = Blocks.COAL_BLOCK;
        }
    }

    public static void loadPortalsFromWorld(Level level) {
        String portalfolder = WorldFunctions.getWorldPath((ServerLevel)((ServerLevel)level)) + File.separator + "data" + File.separator + "netherportalspread" + File.separator + "portals";
        String specificportalfolder = portalfolder + File.separator + DimensionFunctions.getSimpleDimensionString((Level)level);
        if (specificportalfolder.endsWith("overworld")) {
            File[] files;
            File sourceDir = new File(portalfolder);
            File destinationDir = new File(specificportalfolder);
            destinationDir.mkdirs();
            for (File f : files = sourceDir.listFiles(pathname -> pathname.getName().endsWith(".portal"))) {
                Path sourcePath = Paths.get(sourceDir.getAbsolutePath() + File.separator + f.getName(), new String[0]);
                Path destinationPath = Paths.get(destinationDir.getAbsolutePath() + File.separator + f.getName(), new String[0]);
                try {
                    Files.move(sourcePath, destinationPath, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        File dir = new File(specificportalfolder);
        dir.mkdirs();
        File[] listOfFiles = dir.listFiles();
        if (listOfFiles == null) {
            return;
        }
        int r = ConfigHandler.portalSpreadRadius;
        int psamount = ConfigHandler.preventSpreadBlockAmountNeeded;
        for (File listOfFile : listOfFiles) {
            String[] cs;
            String filename = listOfFile.getName();
            if (!filename.endsWith(".portal") || (cs = filename.replace(".portal", "").split("_")).length != 3 || !NumberFunctions.isNumeric((String)cs[0]) || !NumberFunctions.isNumeric((String)cs[1]) || !NumberFunctions.isNumeric((String)cs[2])) continue;
            int x = Integer.parseInt(cs[0]);
            int y = Integer.parseInt(cs[1]);
            int z = Integer.parseInt(cs[2]);
            BlockPos portal = new BlockPos(x, y, z);
            ((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(portals, (Object)level, k -> new CopyOnWriteArrayList())).add(portal);
            if (!ConfigHandler.preventSpreadWithBlock) continue;
            int coalcount = 0;
            Iterator it = BlockPos.betweenClosedStream((int)(portal.getX() - r), (int)(portal.getY() - r), (int)(portal.getZ() - r), (int)(portal.getX() + r), (int)(portal.getY() + r), (int)(portal.getZ() + r)).iterator();
            while (it.hasNext()) {
                try {
                    BlockPos np = (BlockPos)it.next();
                    if (!level.getBlockState(np).getBlock().equals(preventSpreadBlock) || ++coalcount < psamount) continue;
                    break;
                }
                catch (NullPointerException nullPointerException) {
                }
            }
            ((HashMap)HashMapFunctions.computeIfAbsent(preventedportals, (Object)level, k -> new HashMap())).put(portal, coalcount >= psamount);
        }
    }

    public static void savePortalToWorld(Level level, BlockPos portal) {
        String portalfolder = WorldFunctions.getWorldPath((ServerLevel)((ServerLevel)level)) + File.separator + "data" + File.separator + "netherportalspread" + File.separator + "portals" + File.separator + DimensionFunctions.getSimpleDimensionString((Level)level);
        File dir = new File(portalfolder);
        dir.mkdirs();
        String filename = portal.getX() + "_" + portal.getY() + "_" + portal.getZ() + ".portal";
        try {
            PrintWriter writer = new PrintWriter(portalfolder + File.separator + filename, StandardCharsets.UTF_8);
            writer.close();
        }
        catch (Exception e) {
            System.out.println("[Error] Nether Portal Spread: Something went wrong while saving a portal location.");
        }
    }

    private static Boolean portalExists(Level level, BlockPos pos) {
        for (BlockPos portalpos : (CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(portals, (Object)level, k -> new CopyOnWriteArrayList())) {
            double distance = pos.distSqr(new Vec3i(portalpos.getX(), portalpos.getY(), portalpos.getZ()));
            if (!(distance < 10.0)) continue;
            return true;
        }
        return false;
    }

    public static void validatePortalAndAdd(Level level, BlockPos p) {
        int netherblockcount;
        BlockPos rawportal = null;
        int r = 3;
        for (BlockPos nextPos : BlockPos.betweenClosed((int)(p.getX() - r), (int)(p.getY() - r), (int)(p.getZ() - r), (int)(p.getX() + r), (int)(p.getY() + r), (int)(p.getZ() + r))) {
            BlockState blockState = level.getBlockState(nextPos);
            if (!Util.isPortalBlock(blockState)) continue;
            rawportal = nextPos.immutable();
            break;
        }
        if (rawportal == null) {
            return;
        }
        while (Util.isPortalBlock(level.getBlockState(rawportal.below()))) {
            rawportal = rawportal.below().immutable();
        }
        while (Util.isPortalBlock(level.getBlockState(rawportal.west()))) {
            rawportal = rawportal.west().immutable();
        }
        while (Util.isPortalBlock(level.getBlockState(rawportal.north()))) {
            rawportal = rawportal.north().immutable();
        }
        if (((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(portals, (Object)level, k -> new CopyOnWriteArrayList())).contains(rawportal) || ((HashMap)HashMapFunctions.computeIfAbsent(preventedportals, (Object)level, k -> new HashMap())).containsKey(rawportal)) {
            return;
        }
        if (Util.portalExists(level, p).booleanValue()) {
            return;
        }
        Util.sendSpreadingMessage(level, p);
        preventedportals.get(level).put(p, false);
        portals.get(level).add(rawportal);
        Util.savePortalToWorld(level, rawportal);
        if (netherblockcount < ConfigHandler.instantConvertAmount) {
            for (netherblockcount = Util.countNetherBlocks(level, p); netherblockcount < ConfigHandler.instantConvertAmount && Util.spreadNextBlock(level, p).booleanValue(); ++netherblockcount) {
            }
        }
    }

    private static boolean isPortalBlock(BlockState blockState) {
        return blockState.getBlock().equals(Blocks.NETHER_PORTAL);
    }

    public static void removePortal(Level level, BlockPos portal) {
        String portalfolder = WorldFunctions.getWorldPath((ServerLevel)((ServerLevel)level)) + File.separator + "data" + File.separator + "netherportalspread" + File.separator + "portals";
        String filename = portal.getX() + "_" + portal.getY() + "_" + portal.getZ() + ".portal";
        File filepath = new File(portalfolder + File.separator + filename);
        try {
            Files.deleteIfExists(filepath.toPath());
        }
        catch (Exception e) {
            System.out.println("[Error] Nether Portal Spread: Something went wrong while removing an old portal location.");
        }
        ((CopyOnWriteArrayList)HashMapFunctions.computeIfAbsent(portals, (Object)level, k -> new CopyOnWriteArrayList())).remove(portal);
        ((HashMap)HashMapFunctions.computeIfAbsent(preventedportals, (Object)level, k -> new HashMap())).remove(portal);
        Util.sendBrokenPortalMessage(level, portal);
    }

    public static Boolean spreadNextBlock(Level level, BlockPos portal) {
        if (!level.hasChunk(portal.getX() >> 4, portal.getZ() >> 4)) {
            return true;
        }
        BlockState pbs = level.getBlockState(portal);
        if (pbs == null) {
            return false;
        }
        if (!CompareBlockFunctions.isPortalBlock((Block)pbs.getBlock())) {
            Util.removePortal(level, portal);
            return false;
        }
        int r = ConfigHandler.portalSpreadRadius;
        BlockPos closest = null;
        double nearestdistance = 100000.0;
        int coalcount = 0;
        int psamount = ConfigHandler.preventSpreadBlockAmountNeeded;
        Iterator it = BlockPos.betweenClosedStream((int)(portal.getX() - r), (int)(portal.getY() - r), (int)(portal.getZ() - r), (int)(portal.getX() + r), (int)(portal.getY() + r), (int)(portal.getZ() + r)).iterator();
        while (it.hasNext()) {
            try {
                BlockPos np = (BlockPos)it.next();
                if (ConfigHandler.preventSpreadWithBlock && level.getBlockState(np).getBlock().equals(preventSpreadBlock) && ++coalcount >= psamount) break;
                double npnd = portal.distSqr(new Vec3i(np.getX(), np.getY(), np.getZ()));
                if (!(npnd < nearestdistance) || !Util.isNetherTarget(level, np, false).booleanValue()) continue;
                nearestdistance = npnd;
                closest = np.immutable();
            }
            catch (NullPointerException np) {}
        }
        if (ConfigHandler.preventSpreadWithBlock && coalcount >= psamount) {
            boolean prevented = false;
            if (((HashMap)HashMapFunctions.computeIfAbsent(preventedportals, (Object)level, k -> new HashMap())).containsKey(portal)) {
                prevented = preventedportals.get(level).get(portal);
            }
            if (!prevented) {
                Util.sendPreventedMessage(level, portal);
            }
            preventedportals.get(level).put(portal, true);
            return true;
        }
        if (closest != null) {
            boolean prevented = false;
            if (((HashMap)HashMapFunctions.computeIfAbsent(preventedportals, (Object)level, k -> new HashMap())).containsKey(portal)) {
                prevented = preventedportals.get(level).get(portal);
            }
            if (prevented) {
                Util.sendSpreadingMessage(level, portal);
            }
            preventedportals.get(level).put(portal, false);
            Util.spreadNetherToBlock(level, closest);
            return true;
        }
        return false;
    }

    public static int countNetherBlocks(Level level, BlockPos p) {
        int nethercount = 0;
        int r = ConfigHandler.portalSpreadRadius;
        Iterator it = BlockPos.betweenClosedStream((int)(p.getX() - r), (int)(p.getY() - r), (int)(p.getZ() - r), (int)(p.getX() + r), (int)(p.getY() + r), (int)(p.getZ() + r)).iterator();
        while (it.hasNext()) {
            BlockPos np = (BlockPos)it.next();
            if (!Util.isNetherTarget(level, np, true).booleanValue()) continue;
            ++nethercount;
        }
        return nethercount;
    }

    public static Boolean isNetherTarget(Level level, BlockPos pos, Boolean count) {
        if (level == null) {
            return false;
        }
        BlockState state = level.getBlockState(pos);
        Block block = state.getBlock();
        if (count.booleanValue()) {
            return convertedblocks.contains(block);
        }
        return convertblocks.contains(block);
    }

    public static void spreadNetherToBlock(Level level, BlockPos pos) {
        if (level == null) {
            return;
        }
        BlockState currentBlockState = level.getBlockState(pos);
        BlockState newBlockState = null;
        Block curBlock = currentBlockState.getBlock();
        if (convertblocks.contains(curBlock)) {
            RandomCollection rc = new RandomCollection();
            HashMap<Block, Double> hashmap = convertinto.get(curBlock);
            for (Block b0 : hashmap.keySet()) {
                Double weight = hashmap.get(b0);
                rc.add(weight * 100.0, (Object)b0);
            }
            newBlockState = ((Block)rc.next()).withPropertiesOf(currentBlockState);
        }
        if (newBlockState != null) {
            level.setBlockAndUpdate(pos, newBlockState);
        }
    }

    private static void sendSpreadingMessage(Level level, BlockPos p) {
        if (!ConfigHandler.sendMessageOnPortalCreation) {
            return;
        }
        String message = ConfigHandler.messageOnPortalCreation;
        MessageFunctions.sendMessageToPlayersAround((Level)level, (BlockPos)p, (int)ConfigHandler.portalSpreadRadius, (String)Util.formatAroundString(message, ConfigHandler.preventSpreadBlockAmountNeeded, p), (ChatFormatting)ChatFormatting.RED);
    }

    private static void sendPreventedMessage(Level level, BlockPos p) {
        if (!ConfigHandler.sendMessageOnPreventSpreadBlocksFound) {
            return;
        }
        String message = ConfigHandler.messageOnPreventSpreadBlocksFound;
        MessageFunctions.sendMessageToPlayersAround((Level)level, (BlockPos)p, (int)ConfigHandler.portalSpreadRadius, (String)Util.formatAroundString(message, ConfigHandler.preventSpreadBlockAmountNeeded, p), (ChatFormatting)ChatFormatting.DARK_GREEN);
    }

    private static void sendBrokenPortalMessage(Level level, BlockPos p) {
        if (!ConfigHandler.sendMessageOnPortalBroken) {
            return;
        }
        String message = ConfigHandler.messageOnPortalBroken;
        MessageFunctions.sendMessageToPlayersAround((Level)level, (BlockPos)p, (int)ConfigHandler.portalSpreadRadius, (String)Util.formatAroundString(message, ConfigHandler.preventSpreadBlockAmountNeeded, p), (ChatFormatting)ChatFormatting.DARK_GREEN);
    }

    private static String formatAroundString(String message, int amountneeded, BlockPos portal) {
        if (preventSpreadBlock == null) {
            preventSpreadBlock = Blocks.COAL_BLOCK;
        }
        String blockstring = BlockFunctions.blockToReadableString((Block)preventSpreadBlock, (int)amountneeded);
        message = ((String)message).replace("%preventSpreadBlockString%", blockstring);
        message = ((String)message).replace("%preventSpreadBlockAmountNeeded%", "" + amountneeded);
        message = ((String)message).replace("%portalSpreadRadius%", "" + ConfigHandler.portalSpreadRadius);
        if (ConfigHandler.prefixPortalCoordsInMessage) {
            message = "Portal {" + portal.getX() + ", " + portal.getY() + ", " + portal.getZ() + "}: " + (String)message;
        }
        return message;
    }
}

