/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.omegamute_common_neoforge.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.omegamute_common_neoforge.data.Constants;
import com.natamus.omegamute_common_neoforge.data.Variables;
import com.natamus.omegamute_common_neoforge.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.world.entity.player.Player;

public class CommandOmega {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"omegamute").then(Commands.literal((String)"reload").executes(command -> CommandOmega.reload()))).then(Commands.literal((String)"query").executes(command -> CommandOmega.query()))).then(((LiteralArgumentBuilder)Commands.literal((String)"listen").requires(iCommandSender -> iCommandSender.getEntity() instanceof Player)).executes(command -> CommandOmega.listen(false)))).then(((LiteralArgumentBuilder)Commands.literal((String)"listen").requires(iCommandSender -> iCommandSender.getEntity() instanceof Player)).then(Commands.literal((String)"all").executes(command -> CommandOmega.listen(true))))).then(Commands.literal((String)"mute").then(Commands.argument((String)"string-contains", (ArgumentType)StringArgumentType.word()).executes(command -> CommandOmega.mute(StringArgumentType.getString((CommandContext)command, (String)"string-contains")))))).then(Commands.literal((String)"cull").then(Commands.argument((String)"cull-time", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3600)).then(Commands.argument((String)"string-contains", (ArgumentType)StringArgumentType.word()).executes(command -> CommandOmega.cull(StringArgumentType.getString((CommandContext)command, (String)"string-contains"), IntegerArgumentType.getInteger((CommandContext)command, (String)"cull-time"))))))).then(Commands.literal((String)"unmute").then(Commands.argument((String)"string-contains", (ArgumentType)StringArgumentType.word()).executes(command -> CommandOmega.unmute(StringArgumentType.getString((CommandContext)command, (String)"string-contains")))))).then(Commands.literal((String)"settings").then(Commands.literal((String)"serilum").executes(command -> CommandOmega.setupSettings("serilum")))));
    }

    public static int reload() {
        if (Constants.mc.player == null) {
            return 1;
        }
        MessageFunctions.sendMessage((Player)Constants.mc.player, (String)"Reloading the omega mute soundmap file now.", (ChatFormatting)ChatFormatting.DARK_GREEN);
        try {
            if (Util.loadSoundFile()) {
                MessageFunctions.sendMessage((Player)Constants.mc.player, (String)"New soundmap changes successfully loaded.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            } else {
                MessageFunctions.sendMessage((Player)Constants.mc.player, (String)"No soundmap found, a new one has been generated.", (ChatFormatting)ChatFormatting.DARK_GREEN);
            }
        }
        catch (Exception ex) {
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)"Something went wrong while loading the soundmap file.", (ChatFormatting)ChatFormatting.RED);
        }
        return 1;
    }

    public static int query() {
        HashMap<String, Integer> mutedSounds = Util.getMutedSounds();
        if (mutedSounds.size() > 0) {
            StringBuilder combined = new StringBuilder();
            for (String soundName : mutedSounds.keySet()) {
                Integer mutedValue;
                if (!combined.toString().equals("")) {
                    combined.append(", ");
                }
                if ((mutedValue = mutedSounds.get(soundName)) > 0) {
                    combined.append(soundName).append("(").append(mutedValue).append(")");
                    continue;
                }
                combined.append(soundName);
            }
            if (Constants.mc.player == null) {
                return 1;
            }
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)"The following sound events are currently muted:", (ChatFormatting)ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)combined.toString(), (ChatFormatting)ChatFormatting.YELLOW);
        } else {
            if (Constants.mc.player == null) {
                return 1;
            }
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)"There are currently no sound events muted.", (ChatFormatting)ChatFormatting.DARK_GREEN);
        }
        return 1;
    }

    public static int listen(boolean listenToAll) {
        if (Constants.mc.player == null) {
            return 1;
        }
        Variables.listeningToAll = listenToAll;
        Variables.soundsListenedTo = new ArrayList<String>();
        if (Variables.playerIsListening) {
            Variables.playerIsListening = false;
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)"You have stopped listening to the active sounds. To toggle it on use '/omegamute listen' again.", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
        } else {
            Variables.playerIsListening = true;
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)"You are now listening to the active sounds. To toggle it off use '/omegamute listen' again.", (ChatFormatting)ChatFormatting.DARK_GREEN, (boolean)true);
            if (listenToAll) {
                MessageFunctions.sendMessage((Player)Constants.mc.player, (String)"Listening to all sounds. To only see sounds once, use '/omegamute listen'", (ChatFormatting)ChatFormatting.GRAY);
            } else {
                MessageFunctions.sendMessage((Player)Constants.mc.player, (String)"Listening to sounds once. To see all sound occurences, use '/omegamute listen all'", (ChatFormatting)ChatFormatting.GRAY);
            }
        }
        return 1;
    }

    public static int mute(String wildcard) {
        List<String> muted = Util.muteWildcard(wildcard, 0);
        if (Constants.mc.player == null) {
            return 1;
        }
        if (muted.size() > 0) {
            String combined = String.join((CharSequence)", ", muted);
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)("By using the wildcard string '" + wildcard + "', the following " + muted.size() + " sound events have been muted:"), (ChatFormatting)ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)combined, (ChatFormatting)ChatFormatting.YELLOW);
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)"The soundmap file has been updated.", (ChatFormatting)ChatFormatting.DARK_GREEN);
        } else {
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)("No sound events were found by using the wildcard string '" + wildcard + "', try a different query."), (ChatFormatting)ChatFormatting.RED);
        }
        return 1;
    }

    public static int cull(String wildcard, int culltime) {
        List<String> muted = Util.muteWildcard(wildcard, culltime);
        if (Constants.mc.player == null) {
            return 1;
        }
        if (muted.size() > 0) {
            String combined = String.join((CharSequence)", ", muted);
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)("By using the wildcard string '" + wildcard + "', the following " + muted.size() + " sound events have been muted with a cull-time of " + culltime + ":"), (ChatFormatting)ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)combined, (ChatFormatting)ChatFormatting.YELLOW);
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)"The soundmap file has been updated.", (ChatFormatting)ChatFormatting.DARK_GREEN);
        } else {
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)("No sound events were found by using the wildcard string '" + wildcard + "', try a different query."), (ChatFormatting)ChatFormatting.RED);
        }
        return 1;
    }

    public static int unmute(String wildcard) {
        List<String> unmuted = Util.unmuteWildcard(wildcard);
        if (Constants.mc.player == null) {
            return 1;
        }
        if (unmuted.size() > 0) {
            String combined = String.join((CharSequence)", ", unmuted);
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)("By using the wildcard string '" + wildcard + "', the following " + unmuted.size() + " sound events have been unmuted:"), (ChatFormatting)ChatFormatting.DARK_GREEN);
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)combined, (ChatFormatting)ChatFormatting.YELLOW);
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)"The soundmap file has been updated.", (ChatFormatting)ChatFormatting.DARK_GREEN);
        } else {
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)("No sound events were found by using the wildcard string '" + wildcard + "', try a different query."), (ChatFormatting)ChatFormatting.RED);
        }
        return 1;
    }

    public static int setupSettings(String identifier) {
        if (identifier.equals("serilum")) {
            CommandOmega.cull(".step", 1);
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)" ", (ChatFormatting)ChatFormatting.WHITE);
            CommandOmega.cull(".ambient", 1);
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)" ", (ChatFormatting)ChatFormatting.WHITE);
            CommandOmega.mute("entity.cat.ambient");
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)" ", (ChatFormatting)ChatFormatting.WHITE);
            CommandOmega.mute("entity.cat.stray_ambient");
            MessageFunctions.sendMessage((Player)Constants.mc.player, (String)"Serilum's favourite Omega Mute settings have been set.", (ChatFormatting)ChatFormatting.GOLD, (boolean)true);
        }
        return 1;
    }
}

