/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.omegamute_common_forge.util;

import com.natamus.collective_common_forge.functions.DataFunctions;
import com.natamus.collective_common_forge.functions.NumberFunctions;
import com.natamus.omegamute_common_forge.data.Constants;
import com.natamus.omegamute_common_forge.data.Variables;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;

public class Util {
    private static final String dirpath = DataFunctions.getConfigDirectory() + File.separator + "omegamute";
    private static final File dir = new File(dirpath);
    private static final File file = new File(dirpath + File.separator + "soundmap.txt");

    public static boolean loadSoundFile() throws IOException {
        Variables.isMutedSoundMap = new HashMap();
        if (!(dir.isDirectory() && file.isFile() || Util.generateSoundFile())) {
            return false;
        }
        String sounds = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "soundmap.txt", new String[0])));
        for (String sound : sounds.split("\n")) {
            if (sound.length() < 4) continue;
            String soundName = sound.replace(",", "");
            int mutedValue = -1;
            if (soundName.startsWith("!")) {
                mutedValue = 0;
                soundName = soundName.substring(1);
            } else if (soundName.contains("-")) {
                try {
                    String[] soundSplit = soundName.split("-");
                    if (soundSplit.length == 2) {
                        if (NumberFunctions.isNumeric((String)soundSplit[0])) {
                            mutedValue = Integer.parseInt(soundSplit[0]);
                        }
                        soundName = soundSplit[1];
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            Variables.isMutedSoundMap.put(soundName.trim(), mutedValue);
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private static void updateSoundFile() {
        try {
            PrintWriter writer = new PrintWriter(new FileOutputStream(dirpath + File.separator + "soundmap.txt"), true);
            ArrayList<String> keySet = new ArrayList<String>(Variables.isMutedSoundMap.keySet());
            Collections.sort(keySet);
            for (String string : keySet) {
                void var3_4;
                int mutedValue = Variables.isMutedSoundMap.get(string);
                if (mutedValue >= 0) {
                    if (mutedValue == 0) {
                        String string2 = "!" + string;
                    } else {
                        String string3 = mutedValue + "-" + string;
                    }
                }
                writer.println((String)var3_4 + ",");
            }
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static boolean generateSoundFile() throws IOException {
        if (Constants.mc.level == null) {
            return false;
        }
        Registry soundEventRegistry = Constants.mc.level.registryAccess().lookupOrThrow(Registries.SOUND_EVENT);
        ArrayList soundNames = new ArrayList();
        for (ResourceLocation soundlocation : soundEventRegistry.keySet()) {
            Optional optionalSoundEventReference = soundEventRegistry.get(soundlocation);
            optionalSoundEventReference.ifPresent(soundEventReference -> soundNames.add(((SoundEvent)soundEventReference.value()).location().toString()));
        }
        Collections.sort(soundNames);
        dir.mkdirs();
        PrintWriter writer = new PrintWriter(dirpath + File.separator + "soundmap.txt", StandardCharsets.UTF_8);
        for (String soundName : soundNames) {
            Variables.isMutedSoundMap.put(soundName, -1);
            writer.println(soundName + ",");
        }
        writer.close();
        return true;
    }

    public static HashMap<String, Integer> getMutedSounds() {
        HashMap<String, Integer> mutedSounds = new HashMap<String, Integer>();
        ArrayList<String> keySet = new ArrayList<String>(Variables.isMutedSoundMap.keySet());
        Collections.sort(keySet);
        for (String soundName : keySet) {
            int mutedValue = Variables.isMutedSoundMap.get(soundName);
            if (mutedValue < 0) continue;
            mutedSounds.put(soundName, mutedValue);
        }
        return mutedSounds;
    }

    public static List<String> muteWildcard(String wildcard, int culltime) {
        ArrayList<String> mutedSounds = new ArrayList<String>();
        if (!dir.isDirectory() || !file.isFile()) {
            try {
                if (!Util.generateSoundFile()) {
                    return mutedSounds;
                }
            }
            catch (IOException ex) {
                return mutedSounds;
            }
        }
        try {
            String sounds = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "soundmap.txt", new String[0])));
            for (String sound : sounds.split("\n")) {
                if (sound.length() < 4) continue;
                String soundName = sound.replace(",", "");
                int mutedValue = -1;
                if (soundName.startsWith("!")) {
                    mutedValue = 0;
                    soundName = soundName.substring(1);
                } else if (soundName.contains("-")) {
                    try {
                        String[] soundSplit = soundName.split("-");
                        if (soundSplit.length == 2) {
                            if (NumberFunctions.isNumeric((String)soundSplit[0])) {
                                mutedValue = Integer.parseInt(soundSplit[0]);
                            }
                            soundName = soundSplit[1];
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (soundName.toLowerCase().contains(wildcard.toLowerCase())) {
                    mutedValue = culltime;
                    mutedSounds.add(soundName.trim());
                }
                Variables.isMutedSoundMap.put(soundName.trim(), mutedValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (mutedSounds.size() > 0) {
            Util.updateSoundFile();
        }
        return mutedSounds;
    }

    public static List<String> unmuteWildcard(String wildcard) {
        ArrayList<String> unmutedSounds = new ArrayList<String>();
        try {
            String sounds = new String(Files.readAllBytes(Paths.get(dirpath + File.separator + "soundmap.txt", new String[0])));
            for (String sound : sounds.split("\n")) {
                if (sound.length() < 4) continue;
                String soundName = sound.replace(",", "");
                int mutedValue = -1;
                if (soundName.startsWith("!")) {
                    mutedValue = 0;
                    soundName = soundName.substring(1);
                } else if (soundName.contains("-")) {
                    try {
                        String[] soundSplit = soundName.split("-");
                        if (soundSplit.length == 2) {
                            if (NumberFunctions.isNumeric((String)soundSplit[0])) {
                                mutedValue = Integer.parseInt(soundSplit[0]);
                            }
                            soundName = soundSplit[1];
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (soundName.toLowerCase().contains(wildcard.toLowerCase())) {
                    mutedValue = -1;
                    unmutedSounds.add(soundName.trim());
                }
                Variables.isMutedSoundMap.put(soundName.trim(), mutedValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (unmutedSounds.size() > 0) {
            Util.updateSoundFile();
        }
        return unmutedSounds;
    }
}

