/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.omegamute_common_fabric.cmds;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.natamus.collective_common_fabric.functions.MessageFunctions;
import com.natamus.omegamute_common_fabric.data.Constants;
import com.natamus.omegamute_common_fabric.data.Variables;
import com.natamus.omegamute_common_fabric.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class CommandOmega {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"omegamute").then(class_2170.method_9247((String)"reload").executes(command -> CommandOmega.reload()))).then(class_2170.method_9247((String)"query").executes(command -> CommandOmega.query()))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"listen").requires(iCommandSender -> iCommandSender.method_9228() instanceof class_1657)).executes(command -> CommandOmega.listen(false)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"listen").requires(iCommandSender -> iCommandSender.method_9228() instanceof class_1657)).then(class_2170.method_9247((String)"all").executes(command -> CommandOmega.listen(true))))).then(class_2170.method_9247((String)"mute").then(class_2170.method_9244((String)"string-contains", (ArgumentType)StringArgumentType.word()).executes(command -> CommandOmega.mute(StringArgumentType.getString((CommandContext)command, (String)"string-contains")))))).then(class_2170.method_9247((String)"cull").then(class_2170.method_9244((String)"cull-time", (ArgumentType)IntegerArgumentType.integer((int)0, (int)3600)).then(class_2170.method_9244((String)"string-contains", (ArgumentType)StringArgumentType.word()).executes(command -> CommandOmega.cull(StringArgumentType.getString((CommandContext)command, (String)"string-contains"), IntegerArgumentType.getInteger((CommandContext)command, (String)"cull-time"))))))).then(class_2170.method_9247((String)"unmute").then(class_2170.method_9244((String)"string-contains", (ArgumentType)StringArgumentType.word()).executes(command -> CommandOmega.unmute(StringArgumentType.getString((CommandContext)command, (String)"string-contains")))))).then(class_2170.method_9247((String)"settings").then(class_2170.method_9247((String)"serilum").executes(command -> CommandOmega.setupSettings("serilum")))));
    }

    public static int reload() {
        if (Constants.mc.field_1724 == null) {
            return 1;
        }
        MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)"Reloading the omega mute soundmap file now.", (class_124)class_124.field_1077);
        try {
            if (Util.loadSoundFile()) {
                MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)"New soundmap changes successfully loaded.", (class_124)class_124.field_1077);
            } else {
                MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)"No soundmap found, a new one has been generated.", (class_124)class_124.field_1077);
            }
        }
        catch (Exception ex) {
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)"Something went wrong while loading the soundmap file.", (class_124)class_124.field_1061);
        }
        return 1;
    }

    public static int query() {
        HashMap<String, Integer> mutedSounds = Util.getMutedSounds();
        if (mutedSounds.size() > 0) {
            StringBuilder combined = new StringBuilder();
            for (String soundName : mutedSounds.keySet()) {
                Integer mutedValue;
                if (!combined.toString().equals("")) {
                    combined.append(", ");
                }
                if ((mutedValue = mutedSounds.get(soundName)) > 0) {
                    combined.append(soundName).append("(").append(mutedValue).append(")");
                    continue;
                }
                combined.append(soundName);
            }
            if (Constants.mc.field_1724 == null) {
                return 1;
            }
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)"The following sound events are currently muted:", (class_124)class_124.field_1077);
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)combined.toString(), (class_124)class_124.field_1054);
        } else {
            if (Constants.mc.field_1724 == null) {
                return 1;
            }
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)"There are currently no sound events muted.", (class_124)class_124.field_1077);
        }
        return 1;
    }

    public static int listen(boolean listenToAll) {
        if (Constants.mc.field_1724 == null) {
            return 1;
        }
        Variables.listeningToAll = listenToAll;
        Variables.soundsListenedTo = new ArrayList<String>();
        if (Variables.playerIsListening) {
            Variables.playerIsListening = false;
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)"You have stopped listening to the active sounds. To toggle it on use '/omegamute listen' again.", (class_124)class_124.field_1077, (boolean)true);
        } else {
            Variables.playerIsListening = true;
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)"You are now listening to the active sounds. To toggle it off use '/omegamute listen' again.", (class_124)class_124.field_1077, (boolean)true);
            if (listenToAll) {
                MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)"Listening to all sounds. To only see sounds once, use '/omegamute listen'", (class_124)class_124.field_1080);
            } else {
                MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)"Listening to sounds once. To see all sound occurences, use '/omegamute listen all'", (class_124)class_124.field_1080);
            }
        }
        return 1;
    }

    public static int mute(String wildcard) {
        List<String> muted = Util.muteWildcard(wildcard, 0);
        if (Constants.mc.field_1724 == null) {
            return 1;
        }
        if (muted.size() > 0) {
            String combined = String.join((CharSequence)", ", muted);
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)("By using the wildcard string '" + wildcard + "', the following " + muted.size() + " sound events have been muted:"), (class_124)class_124.field_1077);
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)combined, (class_124)class_124.field_1054);
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)"The soundmap file has been updated.", (class_124)class_124.field_1077);
        } else {
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)("No sound events were found by using the wildcard string '" + wildcard + "', try a different query."), (class_124)class_124.field_1061);
        }
        return 1;
    }

    public static int cull(String wildcard, int culltime) {
        List<String> muted = Util.muteWildcard(wildcard, culltime);
        if (Constants.mc.field_1724 == null) {
            return 1;
        }
        if (muted.size() > 0) {
            String combined = String.join((CharSequence)", ", muted);
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)("By using the wildcard string '" + wildcard + "', the following " + muted.size() + " sound events have been muted with a cull-time of " + culltime + ":"), (class_124)class_124.field_1077);
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)combined, (class_124)class_124.field_1054);
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)"The soundmap file has been updated.", (class_124)class_124.field_1077);
        } else {
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)("No sound events were found by using the wildcard string '" + wildcard + "', try a different query."), (class_124)class_124.field_1061);
        }
        return 1;
    }

    public static int unmute(String wildcard) {
        List<String> unmuted = Util.unmuteWildcard(wildcard);
        if (Constants.mc.field_1724 == null) {
            return 1;
        }
        if (unmuted.size() > 0) {
            String combined = String.join((CharSequence)", ", unmuted);
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)("By using the wildcard string '" + wildcard + "', the following " + unmuted.size() + " sound events have been unmuted:"), (class_124)class_124.field_1077);
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)combined, (class_124)class_124.field_1054);
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)"The soundmap file has been updated.", (class_124)class_124.field_1077);
        } else {
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)("No sound events were found by using the wildcard string '" + wildcard + "', try a different query."), (class_124)class_124.field_1061);
        }
        return 1;
    }

    public static int setupSettings(String identifier) {
        if (identifier.equals("serilum")) {
            CommandOmega.cull(".step", 1);
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)" ", (class_124)class_124.field_1068);
            CommandOmega.cull(".ambient", 1);
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)" ", (class_124)class_124.field_1068);
            CommandOmega.mute("entity.cat.ambient");
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)" ", (class_124)class_124.field_1068);
            CommandOmega.mute("entity.cat.stray_ambient");
            MessageFunctions.sendMessage((class_1657)Constants.mc.field_1724, (String)"Serilum's favourite Omega Mute settings have been set.", (class_124)class_124.field_1065, (boolean)true);
        }
        return 1;
    }
}

