/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.stackrefill.forge.events;

import com.natamus.stackrefill_common_forge.events.RefillEvent;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerDestroyItemEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.bus.BusGroup;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class ForgeRefillEvent {
    private static final HashMap<String, InteractionHand> lasthandused = new HashMap();

    public static void registerEventsInBus() {
        BusGroup.DEFAULT.register(MethodHandles.lookup(), ForgeRefillEvent.class);
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.ServerTickEvent.Pre e) {
        RefillEvent.processTick(false);
    }

    @SubscribeEvent
    public static void onItemUse(LivingEntityUseItemEvent.Start e) {
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        ItemStack mainstack = player.getMainHandItem();
        ItemStack used = e.getItem();
        InteractionHand hand = InteractionHand.MAIN_HAND;
        if (!mainstack.getItem().equals(used.getItem()) || mainstack.getCount() != used.getCount()) {
            hand = InteractionHand.OFF_HAND;
        }
        lasthandused.put(player.getName().getString(), hand);
    }

    @SubscribeEvent
    public static void onItemUse(LivingEntityUseItemEvent.Finish e) {
        LivingEntity livingEntity = e.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        String playername = player.getName().getString();
        if (!lasthandused.containsKey(playername)) {
            return;
        }
        RefillEvent.onItemUse(player, e.getItem(), null, lasthandused.get(playername));
    }

    @SubscribeEvent
    public static void onItemBreak(PlayerDestroyItemEvent e) {
        InteractionHand interactionHand = e.getSlot().equals((Object)EquipmentSlot.MAINHAND) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
        RefillEvent.onItemBreak(e.getEntity(), e.getOriginal(), interactionHand);
    }

    @SubscribeEvent
    public static void onItemToss(ItemTossEvent e) {
        RefillEvent.onItemToss(e.getPlayer(), e.getEntity().getItem());
    }

    @SubscribeEvent
    public static void onItemRightClick(PlayerInteractEvent.RightClickItem e) {
        RefillEvent.onItemRightClick(e.getEntity(), e.getLevel(), e.getHand());
    }

    @SubscribeEvent
    public static void onBlockRightClick(PlayerInteractEvent.RightClickBlock e) {
        RefillEvent.onBlockRightClick(e.getLevel(), e.getEntity(), e.getHand(), e.getPos(), e.getHitVec());
    }
}

