/*
 * Decompiled with CFR 0.152.
 */
package com.mars.morediscs;

import com.mars.morediscs.MoreDiscs;
import com.mars.morediscs.MoreDiscsConfig;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import org.jetbrains.annotations.NotNull;

public class DiscAdder
extends LootModifier {
    public static final MapCodec<DiscAdder> CODEC = RecordCodecBuilder.mapCodec(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, DiscAdder::new));

    protected DiscAdder(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    @NotNull
    protected ObjectArrayList<ItemStack> doApply(LootTable lootTable, ObjectArrayList<ItemStack> generatedLoot, LootContext lootContext) {
        if (!MoreDiscsConfig.enable_loot_modifiers) {
            return generatedLoot;
        }
        RandomSource random = lootContext.getRandom();
        ResourceLocation currentTable = lootContext.getQueriedLootTableId();
        for (String disc_loot : MoreDiscsConfig.discs_loot_list) {
            String[] set = disc_loot.replaceAll("\\s", "").split(",");
            ArrayList<ItemStack> itemList = new ArrayList<ItemStack>();
            if (!set[0].equals(currentTable.toString())) continue;
            for (int i = 0; i < set.length - 2; ++i) {
                itemList.add(new ItemStack((ItemLike)MoreDiscs.ITEM_LIST.get(set[i + 1]).get()));
            }
            if (set[set.length - 1].equals("S")) {
                if (lootContext.getOptionalParameter(LootContextParams.DAMAGE_SOURCE) == null || !(((DamageSource)lootContext.getOptionalParameter(LootContextParams.DAMAGE_SOURCE)).getEntity() instanceof Skeleton)) continue;
                generatedLoot.add((Object)((ItemStack)itemList.get(random.nextIntBetweenInclusive(0, itemList.size() - 1))));
                continue;
            }
            if (1 != random.nextIntBetweenInclusive(1, Integer.parseInt(set[set.length - 1]))) continue;
            generatedLoot.add((Object)((ItemStack)itemList.get(random.nextIntBetweenInclusive(0, itemList.size() - 1))));
        }
        return generatedLoot;
    }

    public MapCodec<? extends IGlobalLootModifier> codec() {
        return CODEC;
    }
}

