/*
 * Decompiled with CFR 0.152.
 */
package com.mcwlights.kikoz.objects;

import com.mcwlights.kikoz.objects.LightBaseShort;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class LightBaseTall
extends LightBaseShort {
    public static final EnumProperty<LightPart> PART = EnumProperty.create((String)"part", LightPart.class);

    public LightBaseTall(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)LIT, (Comparable)Boolean.valueOf(true))).setValue(PART, (Comparable)((Object)LightPart.BASE))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    protected BlockState LightState(BlockState state, LevelReader level, BlockPos pos) {
        boolean above = level.getBlockState(pos.above()).getBlock() == this;
        boolean below = level.getBlockState(pos.below()).getBlock() == this;
        Boolean lit = (Boolean)state.getValue((Property)LIT);
        if (lit.booleanValue()) {
            if (above && below) {
                return (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)LightPart.MIDDLE))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
            }
            if (!above && below) {
                return (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)LightPart.TOP))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true));
            }
            if (above && !below) {
                return (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)LightPart.BOTTOM))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
            }
            return (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)LightPart.BASE))).setValue((Property)LIT, (Comparable)Boolean.valueOf(true));
        }
        if (above && below) {
            return (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)LightPart.MIDDLE))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        if (!above && below) {
            return (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)LightPart.TOP))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        if (above && !below) {
            return (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)LightPart.BOTTOM))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
        }
        return (BlockState)((BlockState)state.setValue(PART, (Comparable)((Object)LightPart.BASE))).setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState statetwo, boolean bool) {
        if (!statetwo.is(state.getBlock())) {
            this.LightState(state, (LevelReader)level, pos);
        }
    }

    @Override
    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return this.LightState(super.getStateForPlacement(context), (LevelReader)context.getLevel(), context.getClickedPos());
    }

    public void placeAt(Level level, BlockPos pos, int num) {
        level.setBlock(pos, this.defaultBlockState(), num);
    }

    @Override
    public BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess ticker, BlockPos currentPos, Direction facing, BlockPos facingPos, BlockState facingState, RandomSource random) {
        return this.LightState(state, level, currentPos);
    }

    @Override
    protected InteractionResult useItemOn(ItemStack itemstack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        LightPart part = (LightPart)((Object)state.getValue(PART));
        Item item = itemstack.getItem();
        if (item != this.asItem()) {
            if (worldIn.isClientSide() && part == LightPart.BOTTOM || part == LightPart.MIDDLE) {
                return InteractionResult.PASS;
            }
            if (part == LightPart.TOP || part == LightPart.BASE) {
                state = (BlockState)state.cycle((Property)LIT);
                worldIn.setBlock(pos, state, 10);
                worldIn.playSound(null, pos, SoundEvents.LEVER_CLICK, SoundSource.BLOCKS, 0.5f, worldIn.random.nextFloat() * 0.1f + 0.8f);
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{PART, LIT, POWERED});
    }

    public static enum LightPart implements StringRepresentable
    {
        BASE("base"),
        TOP("top"),
        MIDDLE("middle"),
        BOTTOM("bottom");

        private final String name;

        private LightPart(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

