/*
 * Decompiled with CFR 0.152.
 */
package baguchi.hunters_return.item;

import baguchi.hunters_return.entity.projectile.BoomerangEntity;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;

public class BoomerangItem
extends Item {
    public BoomerangItem(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult useOn(UseOnContext p_41427_) {
        return super.useOn(p_41427_);
    }

    public InteractionResult use(Level p_43099_, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return InteractionResult.CONSUME;
    }

    public boolean releaseUsing(ItemStack stack, Level world, LivingEntity entity, int timeLeft) {
        int i = this.getUseDuration(stack, entity) - timeLeft;
        if (i >= 10) {
            if (!world.isClientSide) {
                stack.hurtAndBreak(1, entity, LivingEntity.getSlotForHand((InteractionHand)entity.getUsedItemHand()));
                int heldTime = this.getUseDuration(stack, entity) - timeLeft;
                float velocity = 1.5f * BowItem.getPowerForTime((int)heldTime);
                BoomerangEntity projectile = new BoomerangEntity(world, entity, stack.copy());
                projectile.shootFromRotation((Entity)entity, entity.getXRot(), entity.getYRot(), 0.0f, velocity, 1.0f);
                world.addFreshEntity((Entity)projectile);
                world.playSound(null, entity.getX(), entity.getY(), entity.getZ(), SoundEvents.EGG_THROW, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!(entity instanceof Player) || !((Player)entity).isCreative()) {
                    stack.shrink(1);
                }
            }
            return true;
        }
        return false;
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_344979_) {
        return 70000;
    }

    public ItemUseAnimation getUseAnimation(ItemStack p_41452_) {
        return ItemUseAnimation.BOW;
    }
}

