/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.world.item.ItemStack;

public class ItemStacksDisplay
implements Renderable {
    private static final int DISPLAY_LENGTH = 20;
    private final int x;
    private final int y;
    private List<ItemStack> stacks = new ArrayList<ItemStack>();
    private int currentRenderingStack = 0;
    private float ticksToChange = 20.0f;

    public ItemStacksDisplay(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.stacks == null) {
            return;
        }
        if (this.currentRenderingStack >= 0 && this.currentRenderingStack < this.stacks.size()) {
            guiGraphics.renderItem(this.stacks.get(this.currentRenderingStack), this.x, this.y);
        }
    }

    public void tick() {
        if (!Screen.hasShiftDown()) {
            float f;
            this.ticksToChange -= 1.0f;
            if (f <= 0.0f) {
                this.changeRenderingStack(1.0);
                this.ticksToChange = 20.0f;
            }
        }
    }

    public void setStacks(List<ItemStack> stacks) {
        if (stacks == null) {
            stacks = List.of();
        }
        this.stacks = stacks;
        this.currentRenderingStack = 0;
        this.ticksToChange = 20.0f;
    }

    public ItemStack getCurrentStack() {
        if (this.stacks != null) {
            return this.currentRenderingStack >= 0 && this.currentRenderingStack < this.stacks.size() && !this.stacks.isEmpty() ? this.stacks.get(this.currentRenderingStack) : ItemStack.EMPTY;
        }
        return ItemStack.EMPTY;
    }

    public void changeRenderingStack(double direction) {
        if (this.stacks == null) {
            this.currentRenderingStack = 0;
        } else {
            int size = this.stacks.size();
            this.currentRenderingStack = (int)((double)this.currentRenderingStack + Math.signum(direction));
            if (this.currentRenderingStack < 0) {
                this.currentRenderingStack = size - 1;
            } else if (this.currentRenderingStack >= size) {
                this.currentRenderingStack = 0;
            }
        }
    }
}

