/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen.components;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Function;
import net.geforcemods.securitycraft.screen.components.GuiBlockModelRenderState;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.render.pip.PictureInPictureRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.RenderTypeHelper;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class GuiBlockModelRenderer
extends PictureInPictureRenderer<GuiBlockModelRenderState> {
    private static final Quaternionf DEFAULT_ROTATION = ClientUtils.fromXYZDegrees(-15.0f, -135.0f, 0.0f).mul((Quaternionfc)Axis.XP.rotationDegrees(180.0f));

    public GuiBlockModelRenderer(MultiBufferSource.BufferSource buffer) {
        super(buffer);
    }

    public Class<GuiBlockModelRenderState> getRenderStateClass() {
        return GuiBlockModelRenderState.class;
    }

    protected void renderToTexture(GuiBlockModelRenderState state, PoseStack pose) {
        Minecraft mc = Minecraft.getInstance();
        pose.scale(-24.0f, 24.0f, -24.0f);
        pose.translate(0.5f, -1.5f, 0.5f);
        pose.mulPose((Quaternionfc)DEFAULT_ROTATION);
        pose.mulPose((Quaternionfc)state.rotation());
        pose.translate(-0.5f, -0.5f, -0.5f);
        mc.gameRenderer.getLighting().setupFor(Lighting.Entry.ENTITY_IN_UI);
        this.renderBlockModel(mc, state.blockAndTintGetter(), state.blockState(), pose, (MultiBufferSource)this.bufferSource);
        if (state.beRenderer() != null) {
            state.beRenderer().render(state.be(), mc.getDeltaTracker().getGameTimeDeltaPartialTick(true), pose, (MultiBufferSource)this.bufferSource, 0xF000F0, OverlayTexture.NO_OVERLAY, mc.gameRenderer.getMainCamera().getPosition());
        }
    }

    protected String getTextureLabel() {
        return "SC block model";
    }

    private void renderBlockModel(Minecraft mc, BlockAndTintGetter blockAndTintGetter, BlockState state, PoseStack pose, MultiBufferSource bufferSource) {
        if (state.getRenderShape() == RenderShape.MODEL) {
            BlockRenderDispatcher blockRenderer = mc.getBlockRenderer();
            BlockStateModel blockModel = blockRenderer.getBlockModel(state);
            Function<ChunkSectionLayer, RenderType> toRenderType = RenderTypeHelper::getMovingBlockRenderType;
            blockRenderer.getModelRenderer().tesselateWithoutAO(blockAndTintGetter, blockModel.collectParts((BlockAndTintGetter)mc.level, BlockPos.ZERO, state, RandomSource.create((long)42L)), state, BlockPos.ZERO, pose, toRenderType.andThen(arg_0 -> ((MultiBufferSource)bufferSource).getBuffer(arg_0)), false, OverlayTexture.NO_OVERLAY);
        }
    }
}

