/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.components.GlobalPositions;
import net.geforcemods.securitycraft.items.SonicSecuritySystemItem;
import net.geforcemods.securitycraft.network.server.RemovePositionFromSSS;
import net.geforcemods.securitycraft.screen.components.SSSConnectionList;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class SSSItemScreen
extends Screen
implements SSSConnectionList.ConnectionAccessor {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/gui/container/blank.png");
    private final ItemStack stack;
    private int imageWidth = 176;
    private int imageHeight = 166;
    private int leftPos;
    private int topPos;
    private SSSConnectionList<SSSItemScreen> connectionList;

    public SSSItemScreen(ItemStack stack) {
        super((Component)Utils.localize(((SonicSecuritySystemItem)((Object)SCContent.SONIC_SECURITY_SYSTEM_ITEM.get())).getDescriptionId(), new Object[0]));
        this.stack = stack.getItem() instanceof SonicSecuritySystemItem ? stack : ItemStack.EMPTY;
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        this.connectionList = (SSSConnectionList)this.addRenderableWidget((GuiEventListener)new SSSConnectionList<SSSItemScreen>(this, this.minecraft, this.imageWidth - 24, this.imageHeight - 40, this.topPos + 20, this.leftPos + 12));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int textWidth = this.font.width((FormattedText)this.title);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, this.title, this.leftPos + this.imageWidth / 2 - textWidth / 2, this.topPos + 6, -12566464, false);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public List<GlobalPos> getPositions() {
        return ((GlobalPositions)this.stack.getOrDefault(SCContent.SSS_LINKED_BLOCKS, (Object)GlobalPositions.sized(30))).positions().stream().toList();
    }

    @Override
    public void removePosition(GlobalPos globalPos) {
        GlobalPositions sssLinkedBlocks = (GlobalPositions)this.stack.get(SCContent.SSS_LINKED_BLOCKS);
        if (sssLinkedBlocks != null) {
            sssLinkedBlocks.remove(SCContent.SSS_LINKED_BLOCKS, this.stack, globalPos);
        }
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new RemovePositionFromSSS(globalPos), (CustomPacketPayload[])new CustomPacketPayload[0]);
        this.connectionList.refreshPositions();
    }
}

