/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.inventory.BlockReinforcerMenu;
import net.geforcemods.securitycraft.network.server.SyncBlockReinforcer;
import net.geforcemods.securitycraft.screen.components.CallbackCheckbox;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class BlockReinforcerScreen
extends AbstractContainerScreen<BlockReinforcerMenu> {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/gui/container/universal_block_reinforcer.png");
    private static final ResourceLocation TEXTURE_LVL1 = SecurityCraft.resLoc("textures/gui/container/universal_block_reinforcer_lvl1.png");
    private final Component output = Utils.localize("gui.securitycraft:blockReinforcer.output", new Object[0]);
    private CallbackCheckbox unreinforceCheckbox;

    public BlockReinforcerScreen(BlockReinforcerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.imageHeight = 186;
    }

    protected void init() {
        super.init();
        this.unreinforceCheckbox = (CallbackCheckbox)this.addRenderableWidget((GuiEventListener)new CallbackCheckbox(this.leftPos + 24, this.topPos + 69, 20, 20, (Component)Component.empty(), !((BlockReinforcerMenu)this.menu).isReinforcing, this::updateTooltip, 0));
        this.updateTooltip(this.unreinforceCheckbox.selected());
        if (((BlockReinforcerMenu)this.menu).isLvl1) {
            this.unreinforceCheckbox.visible = false;
        }
    }

    private void updateTooltip(boolean isSelected) {
        if (isSelected) {
            this.unreinforceCheckbox.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.securitycraft:blockReinforcer.unreinforceCheckbox.checked")));
        } else {
            this.unreinforceCheckbox.setTooltip(Tooltip.create((Component)Component.translatable((String)"gui.securitycraft:blockReinforcer.unreinforceCheckbox.not_checked")));
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        NonNullList inv = ((BlockReinforcerMenu)this.menu).getItems();
        guiGraphics.drawString(this.font, this.title, (this.imageWidth - this.font.width((FormattedText)this.title)) / 2, 5, -12566464, false);
        guiGraphics.drawString(this.font, Utils.INVENTORY_TEXT, 8, this.imageHeight - 96 + 2, -12566464, false);
        if (!((ItemStack)inv.get(36)).isEmpty()) {
            guiGraphics.drawString(this.font, this.output, 50, 25, -12566464, false);
            guiGraphics.renderItem(((BlockReinforcerMenu)this.menu).reinforcingSlot.getOutput(), 116, 20);
            guiGraphics.renderItemDecorations(this.minecraft.font, ((BlockReinforcerMenu)this.menu).reinforcingSlot.getOutput(), 116, 20, null);
            if (mouseX >= this.leftPos + 114 && mouseX < this.leftPos + 134 && mouseY >= this.topPos + 17 && mouseY < this.topPos + 39) {
                guiGraphics.setTooltipForNextFrame(this.font, ((BlockReinforcerMenu)this.menu).reinforcingSlot.getOutput(), mouseX, mouseY);
            }
        }
        if (!((BlockReinforcerMenu)this.menu).isLvl1 && !((ItemStack)inv.get(37)).isEmpty()) {
            guiGraphics.drawString(this.font, this.output, 50, 50, -12566464, false);
            guiGraphics.renderItem(((BlockReinforcerMenu)this.menu).unreinforcingSlot.getOutput(), 116, 46);
            guiGraphics.renderItemDecorations(this.minecraft.font, ((BlockReinforcerMenu)this.menu).unreinforcingSlot.getOutput(), 116, 46, null);
            if (mouseX >= this.leftPos + 114 && mouseX < this.leftPos + 134 && mouseY >= this.topPos + 43 && mouseY < this.topPos + 64) {
                guiGraphics.setTooltipForNextFrame(this.font, ((BlockReinforcerMenu)this.menu).unreinforcingSlot.getOutput(), mouseX, mouseY);
            }
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, ((BlockReinforcerMenu)this.menu).isLvl1 ? TEXTURE_LVL1 : TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public void onClose() {
        super.onClose();
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncBlockReinforcer(!this.unreinforceCheckbox.selected()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

