/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import java.util.List;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.BlockPocketManagerBlockEntity;
import net.geforcemods.securitycraft.inventory.BlockPocketManagerMenu;
import net.geforcemods.securitycraft.network.server.AssembleBlockPocket;
import net.geforcemods.securitycraft.network.server.SyncBlockPocketManager;
import net.geforcemods.securitycraft.network.server.ToggleBlockPocketManager;
import net.geforcemods.securitycraft.screen.components.CallbackSlider;
import net.geforcemods.securitycraft.screen.components.ColorChooser;
import net.geforcemods.securitycraft.screen.components.ColorChooserButton;
import net.geforcemods.securitycraft.screen.components.StackHoverChecker;
import net.geforcemods.securitycraft.screen.components.ToggleComponentButton;
import net.geforcemods.securitycraft.util.IHasExtraAreas;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import org.apache.commons.lang3.ArrayUtils;

public class BlockPocketManagerScreen
extends AbstractContainerScreen<BlockPocketManagerMenu>
implements IHasExtraAreas {
    private static final ResourceLocation TEXTURE = SecurityCraft.resLoc("textures/gui/container/block_pocket_manager.png");
    private static final ResourceLocation TEXTURE_STORAGE = SecurityCraft.resLoc("textures/gui/container/block_pocket_manager_storage.png");
    private static final ItemStack BLOCK_POCKET_WALL = new ItemStack((ItemLike)SCContent.BLOCK_POCKET_WALL.get());
    private static final ItemStack REINFORCED_CHISELED_CRYSTAL_QUARTZ = new ItemStack((ItemLike)SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get());
    private static final ItemStack REINFORCED_CRYSTAL_QUARTZ_PILLAR = new ItemStack((ItemLike)SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get());
    private static final int CHISELED_NEEDED_OVERALL = 8;
    private final Component youNeed = Utils.localize("gui.securitycraft:blockPocketManager.youNeed", new Object[0]);
    private final boolean hasStorageModule;
    private final boolean isOwner;
    private final int[] materialCounts = new int[3];
    public final BlockPocketManagerBlockEntity be;
    private int size = 5;
    private final int[] allowedSizes = new int[]{5, 9, 13, 17, 21, 25};
    private Button assembleButton;
    private Button outlineButton;
    private CallbackSlider offsetSlider;
    private StackHoverChecker[] hoverCheckers = new StackHoverChecker[3];
    private ColorChooser colorChooser;
    private int wallsNeededOverall = (this.size - 2) * (this.size - 2) * 6;
    private int pillarsNeededOverall = (this.size - 2) * 12 - 1;
    private int wallsStillNeeded;
    private int pillarsStillNeeded;
    private int chiseledStillNeeded;
    private final int previousColor;

    public BlockPocketManagerScreen(BlockPocketManagerMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
        this.be = menu.be;
        this.size = this.be.getSize();
        this.isOwner = menu.isOwner;
        this.hasStorageModule = menu.hasStorageModule;
        if (this.hasStorageModule) {
            this.imageWidth = 256;
        }
        this.imageHeight = !this.hasStorageModule ? 194 : 240;
        this.previousColor = this.be.getColor();
    }

    public void init() {
        int[] nArray;
        super.init();
        int guiWidth = this.hasStorageModule ? 123 : this.imageWidth;
        int widgetWidth = this.hasStorageModule ? 110 : 120;
        int widgetOffset = widgetWidth / 2;
        if (this.hasStorageModule) {
            int[] nArray2 = new int[5];
            nArray2[0] = -76;
            nArray2[1] = -100;
            nArray2[2] = -52;
            nArray2[3] = -28;
            nArray = nArray2;
            nArray2[4] = -4;
        } else {
            int[] nArray3 = new int[5];
            nArray3[0] = -40;
            nArray3[1] = -70;
            nArray3[2] = 23;
            nArray3[3] = 47;
            nArray = nArray3;
            nArray3[4] = 71;
        }
        int[] yOffset = nArray;
        int outlineY = this.topPos + this.imageHeight / 2 + yOffset[2];
        int colorChooserButtonX = this.leftPos + guiWidth / 2 - widgetOffset + (this.hasStorageModule ? 0 : widgetWidth + 3);
        int outlineButtonX = colorChooserButtonX + (this.hasStorageModule ? 23 : -widgetWidth - 3);
        int outlineButtonWidth = widgetWidth - (this.hasStorageModule ? 23 : 0);
        int colorChooserX = colorChooserButtonX + (this.hasStorageModule ? -145 : 20);
        Button toggleButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(this.leftPos + guiWidth / 2 - widgetOffset, this.topPos + this.imageHeight / 2 + yOffset[0], widgetWidth, 20, (Component)Utils.localize("gui.securitycraft:blockPocketManager." + (!this.be.isEnabled() ? "activate" : "deactivate"), new Object[0]), this::toggleButtonClicked, Button.DEFAULT_NARRATION));
        Button sizeButton = (Button)this.addRenderableWidget((GuiEventListener)new ToggleComponentButton(this.leftPos + guiWidth / 2 - widgetOffset, this.topPos + this.imageHeight / 2 + yOffset[1], widgetWidth, 20, this::updateSizeButtonText, ArrayUtils.indexOf((int[])this.allowedSizes, (int)this.size), this.allowedSizes.length, this::sizeButtonClicked));
        this.outlineButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(outlineButtonX, outlineY, outlineButtonWidth, 20, (Component)Utils.localize("gui.securitycraft:blockPocketManager.outline." + (!this.be.showsOutline() ? "show" : "hide"), new Object[0]), this::outlineButtonClicked, Button.DEFAULT_NARRATION));
        this.assembleButton = (Button)this.addRenderableWidget((GuiEventListener)new Button(this.leftPos + guiWidth / 2 - widgetOffset, this.topPos + this.imageHeight / 2 + yOffset[3], widgetWidth, 20, (Component)Utils.localize("gui.securitycraft:blockPocketManager.assemble", new Object[0]), this::assembleButtonClicked, Button.DEFAULT_NARRATION));
        this.offsetSlider = (CallbackSlider)this.addRenderableWidget((GuiEventListener)new CallbackSlider(this.leftPos + guiWidth / 2 - widgetOffset, this.topPos + this.imageHeight / 2 + yOffset[4], widgetWidth, 20, (Component)Utils.localize("gui.securitycraft:projector.offset", ""), (Component)Component.empty(), (-this.size + 2) / 2, (this.size - 2) / 2, this.be.getAutoBuildOffset(), true, this::offsetSliderReleased));
        this.colorChooser = new ColorChooser((Component)Component.empty(), colorChooserX, outlineY, this.be.getColor()){

            @Override
            public void onColorChange() {
                BlockPocketManagerScreen.this.be.setColor(this.getRGBColor());
            }
        };
        Button colorChooserButton = (Button)this.addRenderableWidget((GuiEventListener)new ColorChooserButton(colorChooserButtonX, outlineY, 20, 20, this.colorChooser));
        if (!this.be.isOwnedBy((Entity)Minecraft.getInstance().player)) {
            colorChooserButton.active = false;
            this.offsetSlider.active = false;
            this.outlineButton.active = false;
            this.assembleButton.active = false;
            toggleButton.active = false;
            sizeButton.active = false;
        } else {
            this.updateMaterialInformation(true);
            this.offsetSlider.active = !this.be.isEnabled();
            sizeButton.active = this.offsetSlider.active;
        }
        if (!this.hasStorageModule) {
            this.hoverCheckers[0] = new StackHoverChecker(BLOCK_POCKET_WALL, this.topPos + 93, this.topPos + 113, this.leftPos + 23, this.leftPos + 43);
            this.hoverCheckers[1] = new StackHoverChecker(REINFORCED_CRYSTAL_QUARTZ_PILLAR, this.topPos + 93, this.topPos + 113, this.leftPos + 75, this.leftPos + 95);
            this.hoverCheckers[2] = new StackHoverChecker(REINFORCED_CHISELED_CRYSTAL_QUARTZ, this.topPos + 93, this.topPos + 113, this.leftPos + 128, this.leftPos + 148);
        } else {
            this.hoverCheckers[0] = new StackHoverChecker(BLOCK_POCKET_WALL, this.topPos + this.imageHeight - 73, this.topPos + this.imageHeight - 54, this.leftPos + 174, this.leftPos + 191);
            this.hoverCheckers[1] = new StackHoverChecker(REINFORCED_CRYSTAL_QUARTZ_PILLAR, this.topPos + this.imageHeight - 50, this.topPos + this.imageHeight - 31, this.leftPos + 174, this.leftPos + 191);
            this.hoverCheckers[2] = new StackHoverChecker(REINFORCED_CHISELED_CRYSTAL_QUARTZ, this.topPos + this.imageHeight - 27, this.topPos + this.imageHeight - 9, this.leftPos + 174, this.leftPos + 191);
        }
        this.updateAssembleButtonTooltip();
        colorChooserButton.setTooltip(Tooltip.create((Component)Utils.localize("gui.securitycraft:choose_outline_color_tooltip", new Object[0])));
    }

    protected void renderLabels(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        guiGraphics.drawString(this.font, this.title, (this.hasStorageModule ? 123 : this.imageWidth) / 2 - this.font.width((FormattedText)this.title) / 2, 6, -12566464, false);
        if (this.hasStorageModule) {
            guiGraphics.drawString(this.font, this.playerInventoryTitle, 8, this.imageHeight - 94, -12566464, false);
        }
        if (!this.be.isEnabled() && this.isOwner) {
            if (!this.hasStorageModule) {
                guiGraphics.drawString(this.font, this.youNeed, this.imageWidth / 2 - this.font.width((FormattedText)this.youNeed) / 2, 83, -12566464, false);
                guiGraphics.drawString(this.font, "" + this.wallsNeededOverall, 42, 100, -12566464, false);
                guiGraphics.renderItem(BLOCK_POCKET_WALL, 25, 96);
                guiGraphics.drawString(this.font, "" + this.pillarsNeededOverall, 94, 100, -12566464, false);
                guiGraphics.renderItem(REINFORCED_CRYSTAL_QUARTZ_PILLAR, 77, 96);
                guiGraphics.drawString(this.font, "8", 147, 100, -12566464, false);
                guiGraphics.renderItem(REINFORCED_CHISELED_CRYSTAL_QUARTZ, 130, 96);
            } else {
                guiGraphics.drawString(this.font, this.youNeed, 212 - this.font.width((FormattedText)this.youNeed) / 2, this.imageHeight - 83, -12566464, false);
                guiGraphics.drawString(this.font, "" + Math.max(0, this.wallsStillNeeded), 192, this.imageHeight - 66, -12566464, false);
                guiGraphics.renderItem(BLOCK_POCKET_WALL, 175, this.imageHeight - 70);
                guiGraphics.drawString(this.font, "" + Math.max(0, this.pillarsStillNeeded), 192, this.imageHeight - 44, -12566464, false);
                guiGraphics.renderItem(REINFORCED_CRYSTAL_QUARTZ_PILLAR, 175, this.imageHeight - 48);
                guiGraphics.drawString(this.font, "" + Math.max(0, this.chiseledStillNeeded), 192, this.imageHeight - 22, -12566464, false);
                guiGraphics.renderItem(REINFORCED_CHISELED_CRYSTAL_QUARTZ, 175, this.imageHeight - 26);
            }
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.hasStorageModule) {
            this.renderTooltip(guiGraphics, mouseX, mouseY);
        }
        if (!this.be.isEnabled() && this.isOwner) {
            for (StackHoverChecker shc : this.hoverCheckers) {
                if (!shc.checkHover(mouseX, mouseY)) continue;
                guiGraphics.setTooltipForNextFrame(this.font, shc.getStack(), mouseX, mouseY);
                break;
            }
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, this.hasStorageModule ? TEXTURE_STORAGE : TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.minecraft.player.isSpectator()) {
            return false;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double dragX, double dragY) {
        return this.getFocused() != null && this.isDragging() && button == 0 && this.getFocused().mouseDragged(mouseX, mouseY, button, dragX, dragY) || super.mouseDragged(mouseX, mouseY, button, dragX, dragY);
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.slotClicked(slot, slotId, mouseButton, type);
        this.updateMaterialInformation(true);
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        if (this.colorChooser != null) {
            return this.colorChooser.getGuiExtraAreas();
        }
        return List.of();
    }

    public void onClose() {
        super.onClose();
        if (this.previousColor != this.be.getColor()) {
            this.sync();
        }
    }

    private void updateMaterialInformation(boolean recalculateStoredStacks) {
        if (recalculateStoredStacks) {
            NonNullList<ItemStack> storage = this.be.getStorage();
            this.materialCounts[2] = 0;
            this.materialCounts[1] = 0;
            this.materialCounts[0] = 0;
            for (int i = 0; i < storage.size(); ++i) {
                ItemStack stack = (ItemStack)storage.get(i);
                Item item = stack.getItem();
                if (!(item instanceof BlockItem)) continue;
                BlockItem blockItem = (BlockItem)item;
                Block block = blockItem.getBlock();
                if (block == SCContent.BLOCK_POCKET_WALL.get()) {
                    this.materialCounts[0] = this.materialCounts[0] + stack.getCount();
                    continue;
                }
                if (block == SCContent.REINFORCED_CRYSTAL_QUARTZ_PILLAR.get()) {
                    this.materialCounts[1] = this.materialCounts[1] + stack.getCount();
                    continue;
                }
                if (block != SCContent.REINFORCED_CHISELED_CRYSTAL_QUARTZ.get()) continue;
                this.materialCounts[2] = this.materialCounts[2] + stack.getCount();
            }
        }
        this.wallsNeededOverall = (this.size - 2) * (this.size - 2) * 6;
        this.pillarsNeededOverall = (this.size - 2) * 12 - 1;
        this.wallsStillNeeded = this.wallsNeededOverall - this.materialCounts[0];
        this.pillarsStillNeeded = this.pillarsNeededOverall - this.materialCounts[1];
        this.chiseledStillNeeded = 8 - this.materialCounts[2];
        this.assembleButton.active = this.isOwner && (this.minecraft.player.isCreative() || !this.be.isEnabled() && this.hasStorageModule && this.wallsStillNeeded <= 0 && this.pillarsStillNeeded <= 0 && this.chiseledStillNeeded <= 0);
        this.updateAssembleButtonTooltip();
    }

    public void toggleButtonClicked(Button button) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new ToggleBlockPocketManager(this.be.getBlockPos(), this.be.getSize(), !this.be.isEnabled()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        Minecraft.getInstance().player.closeContainer();
    }

    public void sizeButtonClicked(Button button) {
        this.size = this.allowedSizes[((ToggleComponentButton)button).getCurrentIndex()];
        int newMin = (-this.size + 2) / 2;
        int newMax = (this.size - 2) / 2;
        int newOffset = this.be.getAutoBuildOffset() > 0 ? Math.min(this.be.getAutoBuildOffset(), newMax) : Math.max(this.be.getAutoBuildOffset(), newMin);
        this.updateMaterialInformation(false);
        this.be.setSize(this.size);
        this.offsetSlider.setMinValue(newMin);
        this.offsetSlider.setMaxValue(newMax);
        this.be.setAutoBuildOffset(newOffset);
        this.offsetSlider.setValue(newOffset);
        this.sync();
        ((ToggleComponentButton)button).onValueChange();
    }

    public Component updateSizeButtonText(int index) {
        return Utils.localize("gui.securitycraft:blockPocketManager.size", this.size, this.size, this.size);
    }

    public void assembleButtonClicked(Button button) {
        this.be.setSize(this.size);
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new AssembleBlockPocket(this.be.getBlockPos(), this.be.getSize()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        Minecraft.getInstance().player.closeContainer();
    }

    public void updateAssembleButtonTooltip() {
        if (!this.assembleButton.isActive()) {
            this.assembleButton.setTooltip(Tooltip.create((Component)(!this.hasStorageModule ? Utils.localize("gui.securitycraft:blockPocketManager.needStorageModule", new Object[0]) : Utils.localize("messages.securitycraft:blockpocket.notEnoughItems", new Object[0]))));
        } else {
            this.assembleButton.setTooltip(null);
        }
    }

    public void outlineButtonClicked(Button button) {
        this.be.toggleOutline();
        this.outlineButton.setMessage((Component)Utils.localize("gui.securitycraft:blockPocketManager.outline." + (!this.be.showsOutline() ? "show" : "hide"), new Object[0]));
        this.sync();
    }

    public void offsetSliderReleased(CallbackSlider slider) {
        this.be.setAutoBuildOffset(slider.getValueInt());
        this.sync();
    }

    private void sync() {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncBlockPocketManager(this.be.getBlockPos(), this.be.getSize(), this.be.showsOutline(), this.be.getAutoBuildOffset(), this.be.getColor()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

