/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.screen;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.AlarmBlockEntity;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.server.SyncAlarmSettings;
import net.geforcemods.securitycraft.screen.AlarmOptionsScreen;
import net.geforcemods.securitycraft.util.ClientUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.neoforged.neoforge.client.gui.widget.ScrollPanel;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;

public class AlarmScreen
extends Screen {
    private static final ResourceLocation GUI_TEXTURE = SecurityCraft.resLoc("textures/gui/container/alarm.png");
    private static final ResourceLocation PLAY_SOUND_SPRITE = SecurityCraft.resLoc("alarm/play_sound");
    private static final ResourceLocation PLAY_SOUND_HIGHLIGHTED_SPRITE = SecurityCraft.resLoc("alarm/play_sound_highlighted");
    protected final AlarmBlockEntity be;
    private final boolean hasSmartModule;
    private final Component smartModuleTooltip;
    private final Component currentlySelectedText = Utils.localize("gui.securitycraft:alarm.currently_selected", new Object[0]).withStyle(ChatFormatting.UNDERLINE);
    private final ResourceLocation previousSelectedSoundEvent;
    private ResourceLocation selectedSoundEvent;
    private Component selectedSoundEventText;
    private int imageWidth = 256;
    private int imageHeight = 246;
    private int leftPos;
    private int topPos;
    private SoundScrollList soundList;
    protected int previousSoundLength;
    protected int soundLength;
    protected float previousPitch;
    protected float pitch;
    private EditBox searchBar;

    public AlarmScreen(AlarmBlockEntity be, ResourceLocation selectedSoundEvent) {
        super(be.getDisplayName());
        this.be = be;
        this.hasSmartModule = be.isModuleEnabled(ModuleType.SMART);
        this.smartModuleTooltip = Utils.localize(this.hasSmartModule ? "gui.securitycraft:alarm.smart_module" : "gui.securitycraft:alarm.no_smart_module", new Object[0]);
        this.previousSelectedSoundEvent = selectedSoundEvent;
        this.soundLength = this.previousSoundLength = be.getSoundLength();
        this.pitch = this.previousPitch = be.getPitch();
        this.selectSound(selectedSoundEvent);
    }

    protected void init() {
        super.init();
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
        MutableComponent searchText = Utils.localize("gui.securitycraft:alarm.search", new Object[0]);
        this.soundList = (SoundScrollList)this.addRenderableWidget((GuiEventListener)new SoundScrollList(this.minecraft, this.imageWidth - 10, this.imageHeight - 105, this.topPos + 40, this.leftPos + 5));
        this.searchBar = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.font, this.leftPos + 30, this.topPos + 20, this.imageWidth - 60, 15, (Component)searchText));
        this.searchBar.setHint((Component)searchText);
        this.searchBar.setFilter(s -> s.matches("[a-zA-Z0-9\\._]*"));
        this.searchBar.setResponder(this.soundList::updateFilteredEntries);
        this.addRenderableWidget((GuiEventListener)new Button(this.leftPos + this.imageWidth / 2 - 85, this.topPos + 215, 170, 20, (Component)Utils.localize("menu.options", new Object[0]), b -> Minecraft.getInstance().pushGuiLayer((Screen)new AlarmOptionsScreen(this)), Button.DEFAULT_NARRATION));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        guiGraphics.drawString(this.font, this.title, this.width / 2 - this.font.width((FormattedText)this.title) / 2, this.topPos + 6, -12566464, false);
        guiGraphics.drawString(this.font, this.currentlySelectedText, this.width / 2 - this.font.width((FormattedText)this.currentlySelectedText) / 2, this.topPos + this.imageHeight - 62, -12566464, false);
        guiGraphics.drawString(this.font, this.selectedSoundEventText, this.width / 2 - this.font.width((FormattedText)this.selectedSoundEventText) / 2, this.topPos + this.imageHeight - 49, -12566464, false);
        ClientUtils.renderModuleInfo(guiGraphics, this.font, ModuleType.SMART, this.smartModuleTooltip, this.hasSmartModule, this.leftPos + 5, this.topPos + 5, mouseX, mouseY);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.renderTransparentBackground(guiGraphics);
        guiGraphics.blit(RenderPipelines.GUI_TEXTURED, GUI_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    public void selectSound(ResourceLocation eventId) {
        this.selectedSoundEvent = eventId;
        this.selectedSoundEventText = Utils.localize(this.selectedSoundEvent.toLanguageKey(), new Object[0]);
    }

    public void onClose() {
        super.onClose();
        if (this.soundList != null && this.soundList.playingSound != null) {
            Minecraft.getInstance().getSoundManager().stop(this.soundList.playingSound);
        }
        boolean changed = false;
        if (this.selectedSoundEvent != this.previousSelectedSoundEvent) {
            this.be.setSound(this.selectedSoundEvent);
            changed = true;
        }
        if (this.pitch != this.previousPitch) {
            this.be.setPitch(this.pitch);
            changed = true;
        }
        if (this.soundLength != this.previousSoundLength) {
            this.be.setSoundLength(this.soundLength);
            changed = true;
        }
        if (changed) {
            ClientPacketDistributor.sendToServer((CustomPacketPayload)new SyncAlarmSettings(this.be.getBlockPos(), this.selectedSoundEvent, this.pitch, this.soundLength), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!this.searchBar.isFocused() && this.minecraft.options.keyInventory.isActiveAndMatches(InputConstants.getKey((int)keyCode, (int)scanCode))) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public class SoundScrollList
    extends ScrollPanel {
        private static final int SLOT_HEIGHT = 12;
        private static final int TEXT_OFFSET = 11;
        public final List<ResourceLocation> allSoundEvents;
        private final Map<ResourceLocation, Component> soundEventKeys;
        private List<ResourceLocation> filteredSoundEvents;
        private SoundInstance playingSound;
        private int selectedSoundIndex;
        private int contentHeight;
        private String previousSearchText;

        public SoundScrollList(Minecraft client, int width, int height, int top, int left) {
            super(client, width, height, top, left);
            this.allSoundEvents = AlarmScreen.this.minecraft.getSoundManager().getAvailableSounds().stream().sorted(Comparator.comparing(ResourceLocation::toLanguageKey)).toList();
            this.soundEventKeys = new HashMap<ResourceLocation, Component>();
            this.contentHeight = 0;
            this.previousSearchText = "";
            this.updateFilteredEntries("");
            this.scrollDistance = this.selectedSoundIndex * 12;
            int maxScroll = this.getContentHeight() - (height - this.border);
            if (this.scrollDistance > (float)maxScroll) {
                this.scrollDistance = maxScroll;
            }
        }

        protected int getContentHeight() {
            return this.contentHeight;
        }

        protected boolean clickPanel(double mouseX, double mouseY, int button) {
            int slotIndex = (int)(mouseY + (double)(this.border / 2)) / 12;
            if (slotIndex >= 0 && slotIndex < this.filteredSoundEvents.size()) {
                Minecraft mc = Minecraft.getInstance();
                double relativeMouseY = mc.mouseHandler.ypos() * (double)mc.getWindow().getGuiScaledHeight() / (double)mc.getWindow().getScreenHeight();
                if (relativeMouseY < (double)this.top || relativeMouseY > (double)this.bottom) {
                    return false;
                }
                if (mouseX >= 0.0 && mouseX <= 9.0) {
                    this.playSound(this.filteredSoundEvents.get(slotIndex));
                } else if (AlarmScreen.this.hasSmartModule && mouseX > 9.0 && mouseX <= (double)(this.right - 6) && slotIndex != this.selectedSoundIndex) {
                    Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
                    this.selectSound(slotIndex);
                }
                return true;
            }
            return false;
        }

        protected void drawBackground(GuiGraphics guiGraphics, float partialTick) {
            this.drawGradientRect(guiGraphics, this.left, this.top, this.right, this.bottom, -1072689136, -804253680);
        }

        public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            super.render(guiGraphics, mouseX, mouseY, partialTick);
            int baseY = this.top + this.border - (int)this.scrollDistance;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
            int slotIndex = mouseListY / 12;
            if (slotIndex >= 0 && slotIndex < this.filteredSoundEvents.size() && mouseX >= this.left && mouseX < this.right - 6 && mouseListY >= 0 && mouseY >= this.top && mouseY <= this.bottom) {
                Component soundEventKey = this.getSoundEventComponent(this.filteredSoundEvents.get(slotIndex));
                int length = AlarmScreen.this.font.width((FormattedText)soundEventKey);
                if (length >= this.width - 6 - 11) {
                    guiGraphics.setTooltipForNextFrame(AlarmScreen.this.font, soundEventKey, this.left + 11 - 12, baseY + (12 * slotIndex + 12));
                }
            }
        }

        protected void drawPanel(GuiGraphics guiGraphics, int entryRight, int baseY, int mouseX, int mouseY) {
            Font font = Minecraft.getInstance().font;
            int slotBuffer = 8;
            int mouseListY = (int)((float)(mouseY - this.top) + this.scrollDistance - (float)(this.border / 2));
            int slotIndex = mouseListY / 12;
            int min = this.left + 11 - 2;
            if (AlarmScreen.this.hasSmartModule && slotIndex != this.selectedSoundIndex && mouseX >= min && mouseX <= this.right - 7 && slotIndex >= 0 && mouseListY >= 0 && slotIndex < this.filteredSoundEvents.size() && mouseY >= this.top && mouseY <= this.bottom) {
                this.renderHighlightBox(entryRight, guiGraphics, baseY, slotBuffer, slotIndex, min);
            }
            if (this.selectedSoundIndex >= 0) {
                this.renderHighlightBox(entryRight, guiGraphics, baseY, slotBuffer, this.selectedSoundIndex, min);
            }
            for (int i = 0; i < this.filteredSoundEvents.size(); ++i) {
                int yStart = baseY + 12 * i;
                if (yStart + 12 < this.top) continue;
                if (yStart > this.top + this.height) break;
                ResourceLocation soundEvent = this.filteredSoundEvents.get(i);
                Component name = this.getSoundEventComponent(soundEvent);
                guiGraphics.drawString(font, name, this.left + 11, yStart, -3750202, false);
                guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, i == slotIndex && mouseX >= this.left && mouseX < min && mouseY >= this.top && mouseY <= this.bottom ? PLAY_SOUND_HIGHLIGHTED_SPRITE : PLAY_SOUND_SPRITE, this.left, yStart - 1, 10, 10);
            }
        }

        private Component getSoundEventComponent(ResourceLocation soundEvent) {
            return this.soundEventKeys.computeIfAbsent(soundEvent, t -> Utils.localize(soundEvent.toLanguageKey(), new Object[0]));
        }

        private void renderHighlightBox(int entryRight, GuiGraphics guiGraphics, int baseY, int slotBuffer, int slotIndex, int min) {
            int max = entryRight - 6;
            int slotTop = baseY + slotIndex * 12;
            guiGraphics.fill(min, slotTop - 2, max, slotTop + slotBuffer + 2, -8355712);
            guiGraphics.fill(min + 1, slotTop - 1, max - 1, slotTop + slotBuffer + 1, -16777216);
        }

        public void selectSound(int slotIndex) {
            this.selectedSoundIndex = slotIndex;
            AlarmScreen.this.selectSound(this.filteredSoundEvents.get(slotIndex));
        }

        public void playSound(ResourceLocation soundEvent) {
            SoundManager soundManager = Minecraft.getInstance().getSoundManager();
            if (this.playingSound != null) {
                soundManager.stop(this.playingSound);
            }
            this.playingSound = SimpleSoundInstance.forUI((SoundEvent)SoundEvent.createFixedRangeEvent((ResourceLocation)soundEvent, (float)1.0f), (float)AlarmScreen.this.pitch, (float)1.0f);
            soundManager.play(this.playingSound);
        }

        public void updateFilteredEntries(String searchText) {
            this.filteredSoundEvents = new ArrayList<ResourceLocation>(this.allSoundEvents.stream().filter(e -> e.toLanguageKey().contains(searchText)).toList());
            this.recalculateContentHeight();
            this.updateSelectedSoundIndex();
            if (!searchText.equals(this.previousSearchText)) {
                this.previousSearchText = searchText;
                this.scrollDistance = 0.0f;
            }
        }

        public void recalculateContentHeight() {
            int n = this.filteredSoundEvents.size();
            Objects.requireNonNull(AlarmScreen.this.font);
            int height = n * (9 + 3);
            if (height < this.bottom - this.top - 4) {
                height = this.bottom - this.top - 4;
            }
            this.contentHeight = height;
        }

        public void updateSelectedSoundIndex() {
            this.selectedSoundIndex = Iterables.indexOf(this.filteredSoundEvents, se -> se.equals((Object)AlarmScreen.this.selectedSoundEvent));
        }

        public NarratableEntry.NarrationPriority narrationPriority() {
            return NarratableEntry.NarrationPriority.NONE;
        }

        public void updateNarration(NarrationElementOutput narrationElementOutput) {
        }
    }
}

