/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.BlendFunction;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.pipeline.RenderTarget;
import com.mojang.blaze3d.platform.DepthTestFunction;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.ByteBufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.FrameBlockEntity;
import net.geforcemods.securitycraft.blockentities.SecurityCameraBlockEntity;
import net.geforcemods.securitycraft.blocks.FrameBlock;
import net.geforcemods.securitycraft.entity.camera.CameraFeed;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class FrameBlockEntityRenderer
implements BlockEntityRenderer<FrameBlockEntity> {
    private static final ResourceLocation CAMERA_NOT_FOUND = SecurityCraft.resLoc("textures/entity/frame/camera_not_found.png");
    private static final ResourceLocation INACTIVE = SecurityCraft.resLoc("textures/entity/frame/inactive.png");
    private static final ResourceLocation NO_REDSTONE_SIGNAL = SecurityCraft.resLoc("textures/entity/frame/no_redstone_signal.png");
    private static final Material NOISE_BACKGROUND = new Material(TextureAtlas.LOCATION_BLOCKS, SecurityCraft.resLoc("entity/frame/noise_background"));
    private static final ResourceLocation SELECT_CAMERA = SecurityCraft.resLoc("textures/entity/frame/select_camera.png");
    private static final ResourceLocation WHITE = SecurityCraft.resLoc("textures/entity/frame/white.png");
    public static final RenderPipeline FRAME_PIPELINE = RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{RenderPipelines.MATRICES_PROJECTION_SNIPPET}).withLocation(SecurityCraft.resLoc("pipeline/frame_draw_fb_in_area")).withVertexShader(SecurityCraft.resLoc("frame_draw_fb_in_area")).withFragmentShader(SecurityCraft.resLoc("frame_draw_fb_in_area")).withVertexFormat(DefaultVertexFormat.POSITION_TEX, VertexFormat.Mode.QUADS).withSampler("InSampler").withBlend(BlendFunction.TRANSLUCENT).withDepthTestFunction(DepthTestFunction.LEQUAL_DEPTH_TEST).build();

    public FrameBlockEntityRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(FrameBlockEntity be, float partialTicks, PoseStack pose, MultiBufferSource buffer, int packedLight, int packedOverlay, Vec3 viewPos) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (be.isDisabled() || !be.isOwnedBy((Entity)player) && !be.isAllowed((Entity)player) || be.getCameraPositions().isEmpty()) {
            return;
        }
        Level level = be.getLevel();
        BlockState state = be.getBlockState();
        GlobalPos cameraPos = be.getCurrentCamera();
        Direction direction = (Direction)state.getValue(FrameBlock.FACING);
        Vec3i normal = direction.getUnitVec3i();
        float margin = 0.0625f;
        float xStart = 0.0f;
        float xEnd = 1.0f;
        float zStart = 0.0f;
        float zEnd = 1.0f;
        switch (direction) {
            case NORTH: {
                xStart = 0.0625f;
                xEnd = 0.9375f;
                zEnd = 0.05f;
                zStart = 0.05f;
                break;
            }
            case SOUTH: {
                xStart = 0.9375f;
                xEnd = 0.0625f;
                zEnd = 0.95f;
                zStart = 0.95f;
                break;
            }
            case WEST: {
                zStart = 0.9375f;
                zEnd = 0.0625f;
                xEnd = 0.05f;
                xStart = 0.05f;
                break;
            }
            case EAST: {
                zStart = 0.0625f;
                zEnd = 0.9375f;
                xEnd = 0.95f;
                xStart = 0.95f;
                break;
            }
        }
        if (cameraPos == null) {
            this.renderSolidTexture(pose, buffer, SELECT_CAMERA, xStart, xEnd, zStart, zEnd, packedLight, normal, 0.0625f);
        } else if (be.redstoneSignalDisabled()) {
            this.renderNoise(pose, buffer, xStart, xEnd, zStart, zEnd, packedLight, normal, 0.0625f);
            this.renderCutoutTexture(pose, buffer, NO_REDSTONE_SIGNAL, xStart, xEnd, zStart, zEnd, packedLight, normal, 0.0625f);
        } else if (!be.hasClientInteracted()) {
            this.renderNoise(pose, buffer, xStart, xEnd, zStart, zEnd, packedLight, normal, 0.0625f);
            this.renderCutoutTexture(pose, buffer, INACTIVE, xStart, xEnd, zStart, zEnd, packedLight, normal, 0.0625f);
        } else {
            BlockEntity blockEntity;
            CameraFeed feed = FrameFeedHandler.getFeed(cameraPos);
            if (!(feed != null && feed.isFrameLinked(be) && level.isLoaded(cameraPos.pos()) && (blockEntity = level.getBlockEntity(cameraPos.pos())) instanceof SecurityCameraBlockEntity)) {
                this.renderSolidTexture(pose, buffer, CAMERA_NOT_FOUND, xStart, xEnd, zStart, zEnd, packedLight, normal, 0.0625f);
            } else {
                SecurityCameraBlockEntity cameraBlockEntity = (SecurityCameraBlockEntity)blockEntity;
                if (!FrameFeedHandler.isCapturingCamera()) {
                    RenderTarget target = feed.renderTarget();
                    Vector3f backgroundColor = feed.backgroundColor();
                    this.renderOverlay(direction, pose, buffer, buffer.getBuffer(RenderType.entityShadow((ResourceLocation)WHITE)), ARGB.colorFromFloat((float)1.0f, (float)backgroundColor.x, (float)backgroundColor.y, (float)backgroundColor.z), xStart, xEnd, zStart, zEnd, 0.0625f, packedLight);
                    try (ByteBufferBuilder byteBufferBuilder = new ByteBufferBuilder(DefaultVertexFormat.POSITION_TEX.getVertexSize() * 4);){
                        BufferBuilder bufferBuilder = new BufferBuilder(byteBufferBuilder, VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
                        bufferBuilder.addVertex(pose.last().pose(), xStart, 0.0625f, zStart).setUv(1.0f, 0.0f);
                        bufferBuilder.addVertex(pose.last().pose(), xStart, 0.9375f, zStart).setUv(1.0f, 1.0f);
                        bufferBuilder.addVertex(pose.last().pose(), xEnd, 0.9375f, zEnd).setUv(0.0f, 1.0f);
                        bufferBuilder.addVertex(pose.last().pose(), xEnd, 0.0625f, zEnd).setUv(0.0f, 0.0f);
                        try (MeshData meshData = bufferBuilder.buildOrThrow();){
                            meshData.sortQuads(byteBufferBuilder, VertexSorting.DISTANCE_TO_ORIGIN);
                            GpuDevice device = RenderSystem.getDevice();
                            GpuBuffer vertexBuffer = device.createBuffer(() -> "Frame Vertex", 32, meshData.vertexBuffer());
                            GpuBuffer indexBuffer = device.createBuffer(() -> "Frame Index", 72, meshData.indexBuffer());
                            RenderTarget mainRenderTarget = mc.getMainRenderTarget();
                            GpuBufferSlice dynamicTransforms = RenderSystem.getDynamicUniforms().writeTransform((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(), (Vector3fc)new Vector3f(), (Matrix4fc)new Matrix4f(), 0.0f);
                            try (RenderPass pass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "SC camera frame at " + String.valueOf(be.getBlockPos()), mainRenderTarget.getColorTextureView(), OptionalInt.empty(), mainRenderTarget.getDepthTextureView(), OptionalDouble.empty());){
                                pass.setPipeline(FRAME_PIPELINE);
                                pass.setVertexBuffer(0, vertexBuffer);
                                pass.setIndexBuffer(indexBuffer, meshData.drawState().indexType());
                                pass.setUniform("DynamicTransforms", dynamicTransforms);
                                pass.setUniform("Projection", RenderSystem.getProjectionMatrixBuffer());
                                pass.bindSampler("InSampler", target.getColorTextureView());
                                pass.drawIndexed(0, 0, 6, 1);
                            }
                            vertexBuffer.close();
                            indexBuffer.close();
                        }
                    }
                    ItemStack lens = cameraBlockEntity.getLensContainer().getItem(0);
                    if (lens.has(DataComponents.DYED_COLOR)) {
                        this.renderOverlay(direction, pose, buffer, ((DyedItemColor)lens.get(DataComponents.DYED_COLOR)).rgb() + (cameraBlockEntity.getOpacity() << 24), xStart, xEnd, zStart, zEnd, 0.0625f, packedLight);
                    }
                }
            }
        }
    }

    private void renderNoise(PoseStack pose, MultiBufferSource buffer, float xStart, float xEnd, float zStart, float zEnd, int packedLight, Vec3i normal, float margin) {
        this.renderTexture(pose, buffer, NOISE_BACKGROUND.buffer(buffer, RenderType::entitySolid), xStart, xEnd, zStart, zEnd, packedLight, normal, margin);
    }

    private void renderSolidTexture(PoseStack pose, MultiBufferSource buffer, ResourceLocation texture, float xStart, float xEnd, float zStart, float zEnd, int packedLight, Vec3i normal, float margin) {
        this.renderTexture(pose, buffer, buffer.getBuffer(RenderType.entitySolid((ResourceLocation)texture)), xStart, xEnd, zStart, zEnd, packedLight, normal, margin);
    }

    private void renderCutoutTexture(PoseStack pose, MultiBufferSource buffer, ResourceLocation texture, float xStart, float xEnd, float zStart, float zEnd, int packedLight, Vec3i normal, float margin) {
        this.renderTexture(pose, buffer, buffer.getBuffer(RenderType.entityCutout((ResourceLocation)texture)), xStart, xEnd, zStart, zEnd, packedLight, normal, margin);
    }

    private void renderTexture(PoseStack pose, MultiBufferSource buffer, VertexConsumer bufferBuilder, float xStart, float xEnd, float zStart, float zEnd, int packedLight, Vec3i normal, float margin) {
        PoseStack.Pose last = pose.last();
        Matrix4f lastPose = last.pose();
        int nx = normal.getX();
        int ny = normal.getY();
        int nz = normal.getZ();
        bufferBuilder.addVertex(lastPose, xStart, margin, zStart).setUv(1.0f, 1.0f).setColor(0xFFFFFF).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
        bufferBuilder.addVertex(lastPose, xStart, 1.0f - margin, zStart).setUv(1.0f, 0.0f).setColor(0xFFFFFF).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
        bufferBuilder.addVertex(lastPose, xEnd, 1.0f - margin, zEnd).setUv(0.0f, 0.0f).setColor(0xFFFFFF).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
        bufferBuilder.addVertex(lastPose, xEnd, margin, zEnd).setUv(0.0f, 1.0f).setColor(0xFFFFFF).setLight(packedLight).setOverlay(OverlayTexture.NO_OVERLAY).setNormal(last, (float)nx, (float)ny, (float)nz);
        if (buffer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
            bufferSource.endBatch();
        }
    }

    private void renderOverlay(Direction direction, PoseStack pose, MultiBufferSource buffer, int color, float xStart, float xEnd, float zStart, float zEnd, float margin, int packedLight) {
        this.renderOverlay(direction, pose, buffer, buffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)WHITE)), color, xStart, xEnd, zStart, zEnd, margin, packedLight);
    }

    private void renderOverlay(Direction direction, PoseStack poseStack, MultiBufferSource buffer, VertexConsumer bufferBuilder, int color, float xStart, float xEnd, float zStart, float zEnd, float margin, int packedLight) {
        Vector3f normal = direction.getUnitVec3().toVector3f();
        PoseStack.Pose pose = poseStack.last();
        Matrix4f lastPose = poseStack.last().pose();
        bufferBuilder.addVertex(lastPose, xStart, margin, zStart).setColor(color).setUv(0.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, normal);
        bufferBuilder.addVertex(lastPose, xStart, 1.0f - margin, zStart).setColor(color).setUv(0.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, normal);
        bufferBuilder.addVertex(lastPose, xEnd, 1.0f - margin, zEnd).setColor(color).setUv(1.0f, 1.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, normal);
        bufferBuilder.addVertex(lastPose, xEnd, margin, zEnd).setColor(color).setUv(1.0f, 0.0f).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(pose, normal);
        if (buffer instanceof MultiBufferSource.BufferSource) {
            MultiBufferSource.BufferSource bufferSource = (MultiBufferSource.BufferSource)buffer;
            bufferSource.endBatch();
        }
    }
}

