/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.blockentities.DisplayCaseBlockEntity;
import net.geforcemods.securitycraft.blocks.DisplayCaseBlock;
import net.geforcemods.securitycraft.models.DisplayCaseModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionfc;

public class DisplayCaseRenderer
implements BlockEntityRenderer<DisplayCaseBlockEntity> {
    private final ResourceLocation texture = SecurityCraft.resLoc("textures/entity/display_case/normal.png");
    private final ResourceLocation glowTexture = SecurityCraft.resLoc("textures/entity/display_case/glow.png");
    private final DisplayCaseModel model;
    private final boolean glowing;

    public DisplayCaseRenderer(BlockEntityRendererProvider.Context ctx, boolean glowing) {
        this.model = new DisplayCaseModel(ctx.bakeLayer(ClientHandler.DISPLAY_CASE_LOCATION));
        this.glowing = glowing;
    }

    public void render(DisplayCaseBlockEntity be, float partialTick, PoseStack pose, MultiBufferSource buffer, int packedLight, int packedOverlay, Vec3 cameraPos) {
        BlockState state = be.getBlockState();
        Direction facing = (Direction)state.getValue(DisplayCaseBlock.FACING);
        float rotation = facing.toYRot();
        ItemStack displayedStack = be.getDisplayedStack();
        int light = this.glowing ? 0xF000F0 : packedLight;
        this.model.setUpAnim(be.getOpenness(partialTick));
        pose.pushPose();
        pose.translate(0.5, 0.5, 0.5);
        if (!displayedStack.isEmpty()) {
            double insertionAmount = 0.40625;
            pose.pushPose();
            switch ((AttachFace)state.getValue(DisplayCaseBlock.ATTACH_FACE)) {
                case CEILING: {
                    pose.translate(0.0, insertionAmount, 0.0);
                    pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-rotation + 180.0f));
                    pose.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
                    break;
                }
                case FLOOR: {
                    pose.translate(0.0, -insertionAmount, 0.0);
                    pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-rotation + 180.0f));
                    pose.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                    break;
                }
                case WALL: {
                    pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(180.0f));
                    pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-rotation));
                    pose.translate(0.0, 0.0, insertionAmount);
                }
            }
            pose.scale(0.5f, 0.5f, 0.5f);
            Minecraft.getInstance().getItemRenderer().renderStatic(displayedStack, ItemDisplayContext.FIXED, light, OverlayTexture.NO_OVERLAY, pose, buffer, be.getLevel(), 0);
            pose.popPose();
        }
        pose.mulPose((Quaternionfc)Axis.YP.rotationDegrees(-rotation));
        switch ((AttachFace)state.getValue(DisplayCaseBlock.ATTACH_FACE)) {
            case CEILING: {
                pose.translate(0.0, 0.0, 1.0);
                pose.mulPose((Quaternionfc)Axis.XP.rotationDegrees(-90.0f));
                break;
            }
            case FLOOR: {
                pose.translate(0.0, 0.0, -1.0);
                pose.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
                break;
            }
            case WALL: {
                pose.translate(0.0, 1.0, 0.0);
                pose.mulPose((Quaternionfc)Axis.XP.rotationDegrees(180.0f));
            }
        }
        VertexConsumer consumer = buffer.getBuffer(RenderType.entityCutout((ResourceLocation)(this.glowing ? this.glowTexture : this.texture)));
        pose.scale(-1.0f, 1.0f, -1.0f);
        this.model.renderToBuffer(pose, consumer, light, packedOverlay);
        pose.popPose();
    }
}

