/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.recipe;

import java.util.Map;
import net.geforcemods.securitycraft.items.UniversalBlockReinforcerItem;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public abstract class AbstractReinforcerRecipe
extends CustomRecipe {
    protected AbstractReinforcerRecipe(CraftingBookCategory category) {
        super(category);
    }

    public abstract Map<Block, Block> getBlockMap();

    public abstract boolean isCorrectReinforcer(ItemStack var1);

    public boolean matches(CraftingInput inv, Level level) {
        boolean hasCorrectBlock = false;
        boolean hasReinforcer = false;
        Map<Block, Block> blockMap = this.getBlockMap();
        for (int i = 0; i < inv.size(); ++i) {
            ItemStack stack = inv.getItem(i);
            Item item = stack.getItem();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                if (blockMap.containsKey(blockItem.getBlock())) {
                    if (hasCorrectBlock) {
                        return false;
                    }
                    hasCorrectBlock = true;
                    continue;
                }
                return false;
            }
            if (item instanceof UniversalBlockReinforcerItem) {
                if (hasReinforcer || !this.isCorrectReinforcer(stack)) {
                    return false;
                }
                hasReinforcer = true;
                continue;
            }
            if (stack.isEmpty()) continue;
            return false;
        }
        return hasReinforcer && hasCorrectBlock;
    }

    public ItemStack assemble(CraftingInput inv, HolderLookup.Provider lookupProvider) {
        for (int i = 0; i < inv.size(); ++i) {
            Item item = inv.getItem(i).getItem();
            if (!(item instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)item;
            return new ItemStack((ItemLike)this.getBlockMap().get(blockItem.getBlock()));
        }
        return ItemStack.EMPTY;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInput inv) {
        NonNullList newInv = NonNullList.withSize((int)inv.size(), (Object)ItemStack.EMPTY);
        for (int i = 0; i < newInv.size(); ++i) {
            Level level;
            ItemStack stack = inv.getItem(i);
            if (!(stack.getItem() instanceof UniversalBlockReinforcerItem)) continue;
            Player player = CommonHooks.getCraftingPlayer();
            Object object = level = player != null ? player.level() : ServerLifecycleHooks.getCurrentServer().overworld();
            if (level != null && !level.isClientSide) {
                stack.hurtAndBreak(1, (ServerLevel)level, (LivingEntity)player, item -> {});
            }
            newInv.set(i, (Object)stack.copy());
        }
        return newInv;
    }
}

