/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.mixin.camera;

import java.util.Map;
import java.util.function.Consumer;
import net.geforcemods.securitycraft.entity.camera.CameraClientChunkCacheExtension;
import net.geforcemods.securitycraft.entity.camera.FrameFeedHandler;
import net.geforcemods.securitycraft.entity.camera.SecurityCamera;
import net.geforcemods.securitycraft.misc.IChunkStorageProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientChunkCache.class}, priority=1100)
public abstract class ClientChunkCacheMixin
implements IChunkStorageProvider {
    @Shadow
    volatile ClientChunkCache.Storage storage;
    @Shadow
    @Final
    ClientLevel level;

    @Inject(method={"drop"}, at={@At(value="HEAD")})
    private void securitycraft$onDrop(ChunkPos pos, CallbackInfo ci) {
        int renderDistance = (Integer)Minecraft.getInstance().options.renderDistance().get();
        Entity cameraEntity = Minecraft.getInstance().cameraEntity;
        if (cameraEntity instanceof SecurityCamera && pos.getChessboardDistance(cameraEntity.chunkPosition()) <= renderDistance + 1 || FrameFeedHandler.shouldAddChunk(pos, renderDistance)) {
            return;
        }
        CameraClientChunkCacheExtension.drop(this.level, pos);
    }

    @Inject(method={"replaceWithPacketData"}, at={@At(value="HEAD")}, cancellable=true)
    private void securitycraft$onReplaceChunk(int x, int z, FriendlyByteBuf buffer, Map<Heightmap.Types, long[]> heightmaps, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> tagOutputConsumer, CallbackInfoReturnable<LevelChunk> cir) {
        int renderDistance = (Integer)Minecraft.getInstance().options.renderDistance().get();
        Entity cameraEntity = Minecraft.getInstance().cameraEntity;
        ChunkPos pos = new ChunkPos(x, z);
        boolean isInPlayerRange = this.storage.inRange(x, z);
        if (cameraEntity instanceof SecurityCamera && pos.getChessboardDistance(cameraEntity.chunkPosition()) <= renderDistance + 1 || FrameFeedHandler.shouldAddChunk(pos, renderDistance)) {
            LevelChunk newChunk = CameraClientChunkCacheExtension.replaceWithPacketData(this.level, x, z, new FriendlyByteBuf(buffer.copy()), heightmaps, tagOutputConsumer);
            if (!isInPlayerRange) {
                cir.setReturnValue((Object)newChunk);
            }
        }
    }

    @Inject(method={"getChunk(IILnet/minecraft/world/level/chunk/status/ChunkStatus;Z)Lnet/minecraft/world/level/chunk/LevelChunk;"}, at={@At(value="TAIL")}, cancellable=true)
    private void securitycraft$onGetChunk(int x, int z, ChunkStatus requiredStatus, boolean requireChunk, CallbackInfoReturnable<LevelChunk> cir) {
        LevelChunk chunk;
        if (!this.storage.inRange(x, z) && (chunk = CameraClientChunkCacheExtension.getChunk(x, z)) != null) {
            cir.setReturnValue((Object)chunk);
        }
    }
}

