/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items.properties;

import com.mojang.serialization.MapCodec;
import net.geforcemods.securitycraft.items.KeycardItem;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.numeric.RangeSelectItemModelProperty;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemContainerContents;

public record KeycardCount() implements RangeSelectItemModelProperty
{
    public static final MapCodec<KeycardCount> MAP_CODEC = MapCodec.unit((Object)new KeycardCount());

    public float get(ItemStack stack, ClientLevel level, LivingEntity entity, int seed) {
        ItemContainerContents containerContents = (ItemContainerContents)stack.getOrDefault(DataComponents.CONTAINER, (Object)ItemContainerContents.EMPTY);
        int size = containerContents.getSlots();
        if (size == 0) {
            return 0.0f;
        }
        long cardCount = containerContents.stream().filter(item -> item.getItem() instanceof KeycardItem).count();
        return (float)cardCount / (float)size;
    }

    public MapCodec<? extends RangeSelectItemModelProperty> type() {
        return MAP_CODEC;
    }
}

