/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items.properties;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.geforcemods.securitycraft.api.IBlockMine;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.components.GlobalPositionComponent;
import net.geforcemods.securitycraft.items.properties.HitCheck;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;

public record BlockLinked(DataComponentType<?> positionComponent, HitCheck hitCheck) implements SelectItemModelProperty<String>
{
    public static final String NO_POSITIONS = "no_positions";
    public static final String UNKNOWN = "unknown";
    public static final String NOT_LINKED = "not_linked";
    public static final String LINKED = "linked";
    public static final SelectItemModelProperty.Type<BlockLinked, String> TYPE = SelectItemModelProperty.Type.create((MapCodec)RecordCodecBuilder.mapCodec(instance -> instance.group((App)DataComponentType.CODEC.optionalFieldOf("position_component", null).forGetter(BlockLinked::positionComponent), (App)HitCheck.CODEC.fieldOf("hit_check").forGetter(BlockLinked::hitCheck)).apply((Applicative)instance, BlockLinked::new)), (Codec)Codec.STRING);

    public final String get(ItemStack stack, ClientLevel level, LivingEntity entity, int seed, ItemDisplayContext ctx) {
        Object object = stack.get(this.positionComponent);
        if (object instanceof GlobalPositionComponent) {
            Player player;
            BlockHitResult hitResult;
            GlobalPositionComponent positions = (GlobalPositionComponent)object;
            if (level != null && entity instanceof Player && (hitResult = HitCheck.getHitResult((Level)level, player = (Player)entity)) != null) {
                IOwnable ownable;
                BlockPos pos = hitResult.getBlockPos();
                BlockEntity be = level.getBlockEntity(pos);
                if (!(be instanceof IOwnable && (ownable = (IOwnable)be).isOwnedBy((Entity)player) || be != null && !(be.getBlockState().getBlock() instanceof IBlockMine) && !IDisguisable.getDisguisedBlockState(be).isPresent())) {
                    return this.returnBasedOnComponent(positions);
                }
                if (this.hitCheck.isValidHitResult((Level)level, hitResult)) {
                    GlobalPos globalPos = new GlobalPos(level.dimension(), pos);
                    return positions.isPositionAdded(globalPos) ? LINKED : NOT_LINKED;
                }
            }
            return this.returnBasedOnComponent(positions);
        }
        return NO_POSITIONS;
    }

    private final String returnBasedOnComponent(GlobalPositionComponent positions) {
        return positions.isEmpty() ? NO_POSITIONS : UNKNOWN;
    }

    public Codec<String> valueCodec() {
        return Codec.STRING;
    }

    public SelectItemModelProperty.Type<? extends SelectItemModelProperty<String>, String> type() {
        return TYPE;
    }
}

