/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items;

import net.geforcemods.securitycraft.entity.AbstractSecuritySeaBoat;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.item.BoatItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class SecuritySeaBoatItem
extends BoatItem {
    private final EntityType<? extends AbstractSecuritySeaBoat> entityType;

    public SecuritySeaBoatItem(EntityType<? extends AbstractSecuritySeaBoat> entityType, Item.Properties properties) {
        super(entityType, properties);
        this.entityType = entityType;
    }

    public InteractionResult use(Level level, Player player, InteractionHand hand) {
        BlockHitResult hitResult = SecuritySeaBoatItem.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.ANY);
        if (!level.getFluidState(hitResult.getBlockPos()).is(FluidTags.LAVA)) {
            return super.use(level, player, hand);
        }
        return InteractionResult.FAIL;
    }

    public AbstractBoat getBoat(Level level, HitResult hitResult, ItemStack stack, Player player) {
        AbstractSecuritySeaBoat boat = (AbstractSecuritySeaBoat)this.entityType.create(level, EntitySpawnReason.SPAWN_ITEM_USE);
        if (boat != null) {
            Vec3 vec3 = hitResult.getLocation();
            boat.setInitialPos(vec3.x, vec3.y, vec3.z);
            boat.setOwner(player);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                EntityType.createDefaultStackConfig((Level)serverLevel, (ItemStack)stack, (LivingEntity)player).accept(boat);
            }
        }
        return boat;
    }
}

